/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.common.editor.DesignToolsSplitEditor;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PsiNavigateUtil;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoComponentAction
extends DumbAwareAction {
    @NotNull
    private final DesignSurface<?> mySurface;

    public GotoComponentAction(@NotNull DesignSurface<?> surface2) {
        super("Go to XML");
        this.mySurface = surface2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ImmutableList<NlComponent> components;
        DesignToolsSplitEditor splitEditor;
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent instanceof MouseEvent && (this.mySurface.getGuiInputHandler().interceptPanInteraction((MouseEvent)inputEvent) || AdtUiUtils.isActionKeyDown((InputEvent)inputEvent))) {
            return;
        }
        FileEditor selectedEditor = FileEditorManager.getInstance((Project)this.mySurface.getProject()).getSelectedEditor();
        if (selectedEditor instanceof DesignToolsSplitEditor && (splitEditor = (DesignToolsSplitEditor)selectedEditor).isDesignMode()) {
            splitEditor.selectTextMode(false);
        }
        SelectionModel selectionModel = this.mySurface.getSelectionModel();
        NlComponent primary = selectionModel.getPrimary();
        NlModel model2 = this.mySurface.getModel();
        NlComponent componentToNavigate = null;
        if (primary != null) {
            componentToNavigate = primary;
        } else if (!selectionModel.getSelection().isEmpty()) {
            componentToNavigate = selectionModel.getSelection().get(0);
        } else if (model2 != null && !(components = model2.getComponents()).isEmpty()) {
            componentToNavigate = (NlComponent)components.get(0);
        }
        this.mySurface.deactivate();
        if (model2 != null && !GotoComponentAction.navigateToXml(componentToNavigate)) {
            this.switchTab(model2);
        }
    }

    private static boolean navigateToXml(@Nullable NlComponent component) {
        if (component == null) {
            return false;
        }
        XmlTag tag = component.getTag();
        if (tag == null) {
            return false;
        }
        PsiNavigateUtil.navigate((PsiElement)tag);
        return true;
    }

    private void switchTab(@NotNull NlModel model2) {
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.mySurface.getProject());
        editorManager.openTextEditor(new OpenFileDescriptor(model2.getProject(), model2.getVirtualFile(), 0), true);
    }
}

