/*
 * Decompiled with CFR 0.152.
 */
package org.toml.ide.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.TomlBundle;
import org.toml.ide.intentions.TomlElementBaseIntentionAction;
import org.toml.lang.psi.TomlElement;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlHeaderOwner;
import org.toml.lang.psi.TomlInlineTable;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlKeyValueOwner;
import org.toml.lang.psi.TomlPsiFactory;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.TomlValue;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/toml/ide/intentions/TomlExpandInlineTableIntention;", "Lorg/toml/ide/intentions/TomlElementBaseIntentionAction;", "Lorg/toml/ide/intentions/TomlExpandInlineTableIntention$Context;", "()V", "findApplicableContext", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "getFamilyName", "", "getText", "invoke", "", "ctx", "Context", "intellij.toml.core"})
public final class TomlExpandInlineTableIntention
extends TomlElementBaseIntentionAction<Context> {
    @NotNull
    public String getText() {
        return TomlBundle.INSTANCE.message("intention.toml.name.expand.into.separate.table", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Context findApplicableContext(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Object v0;
        block4: {
            void $this$firstOrNull$iv;
            PsiElement $this$parentsOfType$iv = element;
            boolean withSelf$iv = true;
            boolean $i$f$parentsOfType = false;
            $this$parentsOfType$iv = PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, TomlKeyValue.class, (boolean)withSelf$iv);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TomlKeyValue it = (TomlKeyValue)element$iv;
                boolean bl = false;
                boolean hasInlineTableValue = it.getValue() instanceof TomlInlineTable;
                boolean hasTableOrArrayParent = it.getParent() instanceof TomlKeyValueOwner && it.getParent() instanceof TomlHeaderOwner;
                boolean hasTomlFileParent = it.getParent() instanceof TomlFile;
                if (!(hasInlineTableValue && (hasTableOrArrayParent || hasTomlFileParent))) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        TomlKeyValue tomlKeyValue = v0;
        if (tomlKeyValue == null) {
            return null;
        }
        TomlKeyValue keyValue = tomlKeyValue;
        TomlValue tomlValue = keyValue.getValue();
        if (tomlValue == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.toml.lang.psi.TomlInlineTable");
        }
        TomlInlineTable inlineTable = (TomlInlineTable)tomlValue;
        PsiElement psiElement = keyValue.getParent();
        if (!(psiElement instanceof TomlKeyValueOwner)) {
            psiElement = null;
        }
        TomlKeyValueOwner parentTable = (TomlKeyValueOwner)psiElement;
        return new Context(keyValue, inlineTable, parentTable);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull Context ctx) {
        int n;
        Object object;
        String key = ctx.getKeyValue().getKey().getText();
        TomlKeyValueOwner parentTable = ctx.getParentTable();
        if (parentTable != null) {
            TomlElement tomlElement;
            TomlKeyValueOwner tomlKeyValueOwner = parentTable;
            if (!(tomlKeyValueOwner instanceof TomlHeaderOwner)) {
                tomlKeyValueOwner = null;
            }
            if ((tomlElement = (TomlHeaderOwner)((Object)tomlKeyValueOwner)) == null || (tomlElement = tomlElement.getHeader()) == null) {
                return;
            }
            TomlElement parentHeader = tomlElement;
            Object object2 = parentHeader.getKey();
            if (object2 == null || (object2 = object2.getText()) == null) {
                return;
            }
            Object parentTableKey = object2;
            object = (String)parentTableKey + "." + key;
        } else {
            object = key;
        }
        String newTableKey = object;
        TomlTable newTable = new TomlPsiFactory(project, false, 2, null).createTable(newTableKey);
        TomlPsiFactory psiFactory = new TomlPsiFactory(project, false, 2, null);
        for (TomlKeyValue entry : ctx.getInlineTable().getEntries()) {
            newTable.add(psiFactory.createNewline());
            newTable.add(entry.copy());
        }
        if (parentTable != null) {
            ctx.getKeyValue().delete();
            PsiElement parent = parentTable.getParent();
            PsiElement addedTable = parent.addAfter((PsiElement)newTable, (PsiElement)parentTable);
            parent.addAfter(psiFactory.createWhitespace("\n\n"), (PsiElement)parentTable);
            n = UtilsKt.getEndOffset((PsiElement)addedTable);
        } else {
            n = UtilsKt.getEndOffset((PsiElement)ctx.getKeyValue().replace(newTable));
        }
        int addedTableOffset = n;
        editor.getCaretModel().moveToOffset(addedTableOffset);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/toml/ide/intentions/TomlExpandInlineTableIntention$Context;", "", "keyValue", "Lorg/toml/lang/psi/TomlKeyValue;", "inlineTable", "Lorg/toml/lang/psi/TomlInlineTable;", "parentTable", "Lorg/toml/lang/psi/TomlKeyValueOwner;", "(Lorg/toml/lang/psi/TomlKeyValue;Lorg/toml/lang/psi/TomlInlineTable;Lorg/toml/lang/psi/TomlKeyValueOwner;)V", "getInlineTable", "()Lorg/toml/lang/psi/TomlInlineTable;", "getKeyValue", "()Lorg/toml/lang/psi/TomlKeyValue;", "getParentTable", "()Lorg/toml/lang/psi/TomlKeyValueOwner;", "intellij.toml.core"})
    public static final class Context {
        @NotNull
        private final TomlKeyValue keyValue;
        @NotNull
        private final TomlInlineTable inlineTable;
        @Nullable
        private final TomlKeyValueOwner parentTable;

        @NotNull
        public final TomlKeyValue getKeyValue() {
            return this.keyValue;
        }

        @NotNull
        public final TomlInlineTable getInlineTable() {
            return this.inlineTable;
        }

        @Nullable
        public final TomlKeyValueOwner getParentTable() {
            return this.parentTable;
        }

        public Context(@NotNull TomlKeyValue keyValue, @NotNull TomlInlineTable inlineTable, @Nullable TomlKeyValueOwner parentTable) {
            this.keyValue = keyValue;
            this.inlineTable = inlineTable;
            this.parentTable = parentTable;
        }
    }
}

