/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.samples;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.google.common.base.Strings;
import com.google.gct.studio.samples.GithubRepoContents;
import com.google.gct.studio.util.GctStudioBundle;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ImportSampleEvent;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class SampleModel
extends WizardModel {
    private final OptionalProperty<Sample> mySample = new OptionalValueProperty();
    private final OptionalProperty<String> myProjectName = new OptionalValueProperty();
    private final OptionalProperty<File> myDir = new OptionalValueProperty();

    @NotNull
    public static String trimSlashes(@NotNull String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    private static Logger getLog() {
        return Logger.getInstance(SampleModel.class);
    }

    public OptionalProperty<Sample> sample() {
        return this.mySample;
    }

    public OptionalProperty<String> projectName() {
        return this.myProjectName;
    }

    public OptionalProperty<File> dir() {
        return this.myDir;
    }

    protected void handleFinished() {
        if (!(((Optional)this.mySample.get()).isPresent() && ((Optional)this.myDir.get()).isPresent() && ((Optional)this.myProjectName.get()).isPresent())) {
            SampleModel.getLog().error("SampleImportWizard did not collect expected information and will not complete. Please report this error.");
            return;
        }
        Sample sample = (Sample)this.mySample.getValue();
        File dir = (File)this.myDir.getValue();
        String projectName = (String)this.myProjectName.getValue();
        if (!FileUtilRt.createDirectory((File)dir)) {
            Messages.showErrorDialog((String)GctStudioBundle.message("create.project.dir.failed", new Object[0]), (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
            return;
        }
        String url = SampleModel.trimSlashes(sample.getCloneUrl());
        GithubRepoContents downloadResult = this.downloadSample(url);
        if (downloadResult == null) {
            return;
        }
        String basePath = ((File)this.myDir.getValue()).getAbsolutePath();
        try {
            this.setGradleWrapperExecutable(new File(basePath));
        }
        catch (IOException e) {
            Messages.showWarningDialog((String)GctStudioBundle.message("sample.import.no.gradlew.exec", projectName), (String)GctStudioBundle.message("sample.import.warning.title", new Object[0]));
            SampleModel.getLog().error((Throwable)e);
        }
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.IMPORT_SAMPLE_EVENT).setImportSampleEvent(ImportSampleEvent.newBuilder().setImportSampleId(sample.getId())));
        ProjectUtil.openOrImport((String)basePath, null, (boolean)true);
    }

    private GithubRepoContents downloadSample(@NotNull String url) {
        GithubRepoContents downloadResult;
        block7: {
            Sample sample = (Sample)this.mySample.getValue();
            File dir = (File)this.myDir.getValue();
            downloadResult = GithubRepoContents.download(url, null, null);
            if (downloadResult.isCancelled()) {
                SampleModel.getLog().info("Sample download cancelled by user");
                return null;
            }
            String errorMessage = downloadResult.getErrorMessage();
            if (errorMessage != null) {
                SampleModel.getLog().warn(errorMessage);
                Messages.showErrorDialog((String)errorMessage, (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
                return null;
            }
            List<File> sampleRoots = downloadResult.getSampleRoots();
            if (sampleRoots.isEmpty()) {
                Messages.showErrorDialog((String)GctStudioBundle.message("git.project.dir.empty", new Object[0]), (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
                return null;
            }
            File rootFolder = downloadResult.getRootFolder();
            String basePath = dir.getAbsolutePath();
            try {
                String path = sample.getPath();
                if (!Strings.isNullOrEmpty((String)path)) {
                    path = SampleModel.trimSlashes(path);
                    for (File sampleRoot : sampleRoots) {
                        if (!sampleRoot.getCanonicalPath().equals(new File(rootFolder, path).getCanonicalPath())) continue;
                        FileUtil.copyDir((File)sampleRoot, (File)new File(basePath));
                        break block7;
                    }
                    Messages.showErrorDialog((String)GctStudioBundle.message("git.project.missing.sample.root", path), (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
                    return null;
                }
                FileUtil.copyDir((File)sampleRoots.get(0), (File)new File(basePath));
            }
            catch (IOException e) {
                SampleModel.getLog().error((Throwable)e);
                Messages.showErrorDialog((String)GctStudioBundle.message("sample.copy.to.project.failed", new Object[0]), (String)GctStudioBundle.message("sample.import.error.title", new Object[0]));
                return null;
            }
        }
        return downloadResult;
    }

    private void setGradleWrapperExecutable(@NotNull File projectRoot) throws IOException {
        if (!SystemInfo.isUnix) {
            return;
        }
        File gradlewFile = new File(projectRoot, "gradlew");
        if (!gradlewFile.isFile()) {
            throw new IOException("Could not find gradle wrapper. Command line builds may not work properly.");
        }
        FileUtil.setExecutable((File)gradlewFile);
    }
}

