/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.run;

import com.google.gct.studio.appengine.run.AppEngineGradleBeforeRunTaskProvider;
import com.google.gct.studio.appengine.run.AppEngineRunConfiguration;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import icons.GoogleCloudToolsIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AppEngineRunConfigurationType
implements ConfigurationType {
    public static final String ID = "AppEngineRunConfiguration";
    private final AppEngineConfigurationFactory myFactory = new AppEngineConfigurationFactory(this);

    public String getDisplayName() {
        return "App Engine DevAppServer";
    }

    public String getConfigurationTypeDescription() {
        return "Run App Engine module on the local development server";
    }

    public Icon getIcon() {
        return GoogleCloudToolsIcons.APP_ENGINE;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    public ConfigurationFactory getFactory() {
        return this.myFactory;
    }

    public static AppEngineRunConfigurationType getInstance() {
        return (AppEngineRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(AppEngineRunConfigurationType.class);
    }

    private static class AppEngineConfigurationFactory
    extends ConfigurationFactory {
        public AppEngineConfigurationFactory(ConfigurationType type) {
            super(type);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new AppEngineRunConfiguration("App Engine DevAppServer", project, this);
        }

        public void configureBeforeRunTaskDefaults(Key<? extends BeforeRunTask> providerID, BeforeRunTask task) {
            if (providerID != AppEngineGradleBeforeRunTaskProvider.ID) {
                task.setEnabled(false);
            }
        }
    }
}

