/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.run;

import com.google.gct.login.stats.UsageTrackerService;
import com.google.gct.studio.appengine.gradle.facet.AppEngineConfigurationProperties;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacet;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacetConfiguration;
import com.google.gct.studio.appengine.run.AppEngineRunConfigurationSettingsEditor;
import com.google.gct.studio.appengine.sdk.AppEngineSdk;
import com.google.gct.studio.util.GctStudioBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathsList;
import java.util.Arrays;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineRunConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element> {
    public static final String NAME = "App Engine DevAppServer";
    private String myServerAddress = "";
    private String mySdkPath = "";
    private String myServerPort = "";
    private Boolean mySyncWithGradle = false;
    private String myVmArgs = "";
    private String myWarPath = "";
    private Boolean myDisableUpdateCheck = false;
    private static final String KEY_SERVER_ADDRESS = "serverAddress";
    private static final String KEY_SERVER_PORT = "serverPort";
    private static final String KEY_SYNC = "sync";
    private static final String KEY_SDK_PATH = "sdkPath";
    private static final String KEY_VM_ARGS = "vmArgs";
    private static final String KEY_WAR_PATH = "warPath";
    private static final String KEY_DISABLE_UPDATE_CHECK = "disableUpdateCheck";

    public String getWarPath() {
        return this.myWarPath;
    }

    public void setWarPath(String warPath) {
        this.myWarPath = warPath;
    }

    public String getServerAddress() {
        return this.myServerAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.myServerAddress = serverAddress;
    }

    public String getSdkPath() {
        return this.mySdkPath;
    }

    public void setSdkPath(String sdkPath) {
        this.mySdkPath = sdkPath;
    }

    public String getServerPort() {
        return this.myServerPort;
    }

    public void setServerPort(String serverPort) {
        this.myServerPort = serverPort;
    }

    public Boolean isSyncWithGradle() {
        return this.mySyncWithGradle;
    }

    public void setSyncWithGradle(Boolean syncWithGradle) {
        this.mySyncWithGradle = syncWithGradle;
    }

    public String getVmArgs() {
        return this.myVmArgs;
    }

    public void setVmArgs(String vmArgs) {
        this.myVmArgs = vmArgs;
    }

    public Boolean isDisableUpdateCheck() {
        return this.myDisableUpdateCheck;
    }

    public void setDisableUpdateCheck(Boolean disableUpdateCheck) {
        this.myDisableUpdateCheck = disableUpdateCheck;
    }

    public AppEngineRunConfiguration(String name, Project project, ConfigurationFactory factory) {
        super(name, (RunConfigurationModule)new JavaRunConfigurationModule(project, false), factory);
    }

    public Collection<Module> getValidModules() {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        return Arrays.asList(modules);
    }

    protected ModuleBasedConfiguration createInstance() {
        return new AppEngineRunConfiguration(this.getName(), this.getProject(), this.getFactory());
    }

    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new AppEngineRunConfigurationSettingsEditor(this.getProject());
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        JavaApplicationCommandLineState state = new JavaApplicationCommandLineState(this, env);
        JavaRunConfigurationModule module = (JavaRunConfigurationModule)this.getConfigurationModule();
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), module.getSearchScope()));
        return state;
    }

    protected void syncWithBuildFileViaFacet() {
        AppEngineConfigurationProperties model;
        AppEngineGradleFacet facet;
        this.myVmArgs = "";
        this.myWarPath = "";
        this.mySdkPath = "";
        this.myServerAddress = "";
        this.myServerPort = "";
        this.myDisableUpdateCheck = false;
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        if (module != null && (facet = AppEngineGradleFacet.getInstance(module)) != null && (model = ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState()) != null) {
            this.myServerPort = model.HTTP_PORT.toString();
            this.myServerAddress = model.HTTP_ADDRESS;
            this.mySdkPath = model.APPENGINE_SDKROOT;
            this.myWarPath = model.WAR_DIR;
            this.myVmArgs = model.getJvmFlags();
            this.myDisableUpdateCheck = model.DISABLE_UPDATE_CHECK;
        }
    }

    public final void checkConfiguration() throws RuntimeConfigurationException {
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        configurationModule.checkForWarning();
        Module module = configurationModule.getModule();
        if (module == null) {
            return;
        }
        AppEngineGradleFacet facet = AppEngineGradleFacet.getAppEngineFacetByModule(module);
        if (facet == null) {
            throw new RuntimeConfigurationError(GctStudioBundle.message("appengine.run.no.facet", new Object[0]));
        }
        if (this.mySyncWithGradle.booleanValue() && (((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState() == null || StringUtil.isEmpty((String)((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState().WEB_APP_DIR))) {
            throw new RuntimeConfigurationError(GctStudioBundle.message("appengine.run.no.gradle.state", new Object[0]));
        }
        if (this.mySyncWithGradle.booleanValue()) {
            this.syncWithBuildFileViaFacet();
        }
        if (this.mySdkPath == null || this.mySdkPath.trim().isEmpty() || !new AppEngineSdk(this.mySdkPath).canRunDevAppServer()) {
            throw new RuntimeConfigurationError(GctStudioBundle.message("appengine.run.invalid.sdk", new Object[0]));
        }
        if (this.myWarPath == null || this.myWarPath.trim().isEmpty()) {
            throw new RuntimeConfigurationError(GctStudioBundle.message("appengine.run.invalid.war", new Object[0]));
        }
        if (StringUtil.containsWhitespaces((CharSequence)this.myServerAddress.trim())) {
            throw new RuntimeConfigurationError(GctStudioBundle.message("appengine.run.invalid.server.address", new Object[0]));
        }
        if (this.myServerPort != null && !this.myServerPort.trim().isEmpty()) {
            try {
                int value = Integer.parseInt(this.myServerPort);
                if (value < 1024 || value > 65535) {
                    throw new RuntimeConfigurationError(GctStudioBundle.message("appengine.run.invalid.server.port.range", 1024, 65535));
                }
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeConfigurationError(GctStudioBundle.message("appengine.run.invalid.server.port", 1024, 65535));
            }
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        this.readModule(element);
        this.myServerAddress = StringUtil.notNullize((String)JDOMExternalizer.readString((Element)element, (String)KEY_SERVER_ADDRESS));
        this.mySdkPath = ExternalizablePath.localPathValue((String)JDOMExternalizer.readString((Element)element, (String)KEY_SDK_PATH));
        this.myServerPort = StringUtil.notNullize((String)JDOMExternalizer.readString((Element)element, (String)KEY_SERVER_PORT));
        this.myVmArgs = StringUtil.notNullize((String)JDOMExternalizer.readString((Element)element, (String)KEY_VM_ARGS));
        this.myWarPath = StringUtil.notNullize((String)JDOMExternalizer.readString((Element)element, (String)KEY_WAR_PATH));
        this.mySyncWithGradle = JDOMExternalizer.readBoolean((Element)element, (String)KEY_SYNC);
        this.myDisableUpdateCheck = JDOMExternalizer.readBoolean((Element)element, (String)KEY_DISABLE_UPDATE_CHECK);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        this.writeModule(element);
        JDOMExternalizer.write((Element)element, (String)KEY_SERVER_ADDRESS, (String)this.myServerAddress);
        JDOMExternalizer.write((Element)element, (String)KEY_SDK_PATH, (String)ExternalizablePath.urlValue((String)this.mySdkPath));
        JDOMExternalizer.write((Element)element, (String)KEY_SERVER_PORT, (String)this.myServerPort);
        JDOMExternalizer.write((Element)element, (String)KEY_VM_ARGS, (String)this.myVmArgs);
        JDOMExternalizer.write((Element)element, (String)KEY_WAR_PATH, (String)this.myWarPath);
        JDOMExternalizer.write((Element)element, (String)KEY_SYNC, (boolean)this.mySyncWithGradle);
        JDOMExternalizer.write((Element)element, (String)KEY_DISABLE_UPDATE_CHECK, (boolean)this.myDisableUpdateCheck);
        PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePathsRecursively(element);
    }

    public static class JavaApplicationCommandLineState
    extends JavaCommandLineState {
        private final AppEngineRunConfiguration configuration;

        public JavaApplicationCommandLineState(@NotNull AppEngineRunConfiguration configuration, ExecutionEnvironment environment) {
            super(environment);
            this.configuration = configuration;
        }

        protected JavaParameters createJavaParameters() throws ExecutionException {
            String warPath;
            JavaParameters params = new JavaParameters();
            JavaRunConfigurationModule module = (JavaRunConfigurationModule)this.configuration.getConfigurationModule();
            params.setMainClass("com.google.appengine.tools.development.DevAppServerMain");
            AppEngineSdk sdk = new AppEngineSdk(this.configuration.mySdkPath);
            ParametersList vmParams = params.getVMParametersList();
            if (this.configuration.myVmArgs != null && !this.configuration.myVmArgs.trim().isEmpty()) {
                vmParams.addParametersString(this.configuration.myVmArgs);
            }
            sdk.addServerVmParams(vmParams);
            ParametersList programParams = params.getProgramParametersList();
            if (this.configuration.myServerAddress != null && !this.configuration.myServerAddress.trim().isEmpty()) {
                programParams.add("--address=" + this.configuration.myServerAddress);
            }
            if (this.configuration.myServerPort != null && !this.configuration.myServerPort.trim().isEmpty()) {
                programParams.add("--port=" + this.configuration.myServerPort);
            }
            if (this.configuration.myDisableUpdateCheck.booleanValue()) {
                programParams.add("--disable_update_check");
            }
            if ((warPath = this.configuration.myWarPath) == null) {
                throw new ExecutionException("War path is invalid");
            }
            programParams.add(warPath);
            params.setWorkingDirectory(warPath);
            PathsList classPath = params.getClassPath();
            classPath.add(sdk.getToolsApiJarFile().getAbsolutePath());
            Module appEngineModule = module.getModule();
            if (appEngineModule == null) {
                throw new ExecutionException("Module not defined");
            }
            params.setJdk(JavaParameters.getValidJdkToRunModule((Module)appEngineModule, (boolean)false));
            UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "appengine.run", this.configuration.isSyncWithGradle() != false ? AppEngineRunConfiguration.KEY_SYNC : "custom", null);
            return params;
        }
    }
}

