/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.gradle.service;

import com.google.common.collect.Maps;
import com.google.gct.login.stats.UsageTrackerService;
import com.google.gct.studio.appengine.gradle.project.IdeaAppEngineProject;
import com.google.gct.studio.appengine.gradle.service.AppEngineGradleProjectSetup;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineGradleProjectDataService
extends AbstractProjectDataService<IdeaAppEngineProject, Void> {
    private static final Logger LOG = Logger.getInstance(AppEngineGradleProjectDataService.class);
    @NotNull
    public static final Key<IdeaAppEngineProject> IDE_APP_ENGINE_PROJECT = Key.create(IdeaAppEngineProject.class, (int)1000);
    private NotificationGroup myLoggingNotification;

    @NotNull
    public Key<IdeaAppEngineProject> getTargetDataKey() {
        return IDE_APP_ENGINE_PROJECT;
    }

    public void importData(final @NotNull Collection<? extends DataNode<IdeaAppEngineProject>> toImport, @Nullable ProjectData projectData, @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport.isEmpty()) {
            return;
        }
        RunResult result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                Map<String, IdeaAppEngineProject> importModulesMap = AppEngineGradleProjectDataService.indexByModuleName(toImport);
                for (Module module : modelsProvider.getModules()) {
                    if (!importModulesMap.containsKey(module.getName())) continue;
                    AppEngineGradleProjectSetup.addAppEngineGradleFacet(importModulesMap.get(module.getName()), module, modelsProvider);
                    AppEngineGradleProjectSetup.addAppEngineRunConfiguration(module);
                    UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "appengine.gradle.import", null, null);
                }
            }
        }.execute();
        Throwable error = result.getThrowable();
        if (error != null) {
            LOG.warn("Failed to set up App Engine Gradle Modules");
            this.syncFailed(project, error.getMessage());
        }
    }

    public void syncFailed(@NotNull Project project, @NotNull String message) {
        Object logMsg = "Gradle sync failed";
        if (StringUtil.isNotEmpty((String)message)) {
            logMsg = (String)logMsg + String.format(": %1$s", message);
        }
        this.addToEventLog(project, (String)logMsg, MessageType.ERROR);
    }

    private void addToEventLog(@NotNull Project project, @NotNull String message, @NotNull MessageType type) {
        this.getLoggingNotification().createNotification(message, type).notify(project);
    }

    private synchronized NotificationGroup getLoggingNotification() {
        if (this.myLoggingNotification == null) {
            NotificationGroup registeredGroup = NotificationGroup.findRegisteredGroup((String)"Gradle sync");
            this.myLoggingNotification = registeredGroup != null ? registeredGroup : NotificationGroup.logOnlyGroup((String)"Gradle sync", (PluginId)PluginId.getId((String)"com.google.gct"));
        }
        return this.myLoggingNotification;
    }

    @NotNull
    private static Map<String, IdeaAppEngineProject> indexByModuleName(@NotNull Collection<? extends DataNode<IdeaAppEngineProject>> dataNodes) {
        HashMap index = Maps.newHashMap();
        for (DataNode<IdeaAppEngineProject> dataNode : dataNodes) {
            IdeaAppEngineProject appEngineProject = (IdeaAppEngineProject)dataNode.getData();
            index.put(appEngineProject.getModuleName(), appEngineProject);
        }
        return index;
    }
}

