/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.decoder.psd;

import com.android.tools.chunkio.ChunkUtils;
import com.android.tools.chunkio.RangedInputStream;
import com.android.tools.pixelprobe.ColorMode;
import com.android.tools.pixelprobe.decoder.psd.PsdFile;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;

final class PsdFile_Header__ChunkIO {
    PsdFile_Header__ChunkIO() {
    }

    static PsdFile.Header read(RangedInputStream in, LinkedList<Object> stack) throws IOException {
        PsdFile.Header header = new PsdFile.Header();
        stack.addFirst(header);
        boolean size = false;
        long byteCount = 0L;
        header.signature = ChunkUtils.readString(in, 4L, Charset.forName("ISO-8859-1"));
        ChunkUtils.checkState(header.signature.equals("8BPS"), "Value read in signature does not match expected value", new Object[0]);
        header.version = in.readShort();
        ChunkUtils.checkState(header.version == 1, "Value read in version does not match expected value", new Object[0]);
        ChunkUtils.skip(in, 6L);
        header.channels = in.readUnsignedShort();
        header.height = in.readInt();
        header.width = in.readInt();
        header.depth = in.readShort();
        header.colorMode = ColorMode.values()[Math.max(0, Math.min(in.readUnsignedShort(), ColorMode.values().length - 1))];
        stack.removeFirst();
        return header;
    }
}

