/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.decoder;

import com.android.tools.pixelprobe.decoder.Decoder;
import com.android.tools.pixelprobe.decoder.JpegDecoder;
import com.android.tools.pixelprobe.decoder.PngDecoder;
import com.android.tools.pixelprobe.decoder.psd.PsdDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class Decoders {
    private static final int READ_AHEAD_LIMIT = 1024;
    private static final List<Decoder> decoders = new ArrayList<Decoder>();

    private Decoders() {
    }

    private static void register(Decoder decoder) {
        decoders.add(decoder);
    }

    public static Decoder find(String format) {
        for (Decoder decoder : decoders) {
            if (!decoder.accept(format)) continue;
            return decoder;
        }
        return null;
    }

    public static Decoder find(InputStream in) {
        for (Decoder decoder : decoders) {
            boolean accepted = Decoders.markExecuteReset(in, inputStream -> decoder.accept(in));
            if (!accepted) continue;
            return decoder;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean markExecuteReset(InputStream in, Predicate<InputStream> op) {
        in.mark(1024);
        try {
            boolean bl = op.test(in);
            return bl;
        }
        finally {
            try {
                in.reset();
            }
            catch (IOException iOException) {}
        }
    }

    static {
        Decoders.register(new JpegDecoder());
        Decoders.register(new PngDecoder());
        Decoders.register(new PsdDecoder());
    }
}

