/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe;

import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.decoder.Decoder;
import com.android.tools.pixelprobe.decoder.Decoders;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class PixelProbe {
    private PixelProbe() {
    }

    public static Image probe(InputStream in) throws IOException {
        return PixelProbe.probe(in, null);
    }

    public static Image probe(InputStream in, Decoder.Options options) throws IOException {
        Decoder decoder;
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        if ((decoder = Decoders.find(in)) == null) {
            throw new IOException("Unknown image format");
        }
        return decoder.decode(in, options != null ? options : new Decoder.Options());
    }

    public static Image probe(String format, InputStream in) throws IOException {
        return PixelProbe.probe(format, in, null);
    }

    public static Image probe(String format, InputStream in, Decoder.Options options) throws IOException {
        Decoder decoder = Decoders.find(format);
        if (decoder == null) {
            return PixelProbe.probe(in);
        }
        return decoder.decode(in, options != null ? options : new Decoder.Options());
    }
}

