/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe;

import com.android.tools.pixelprobe.BlendMode;
import com.android.tools.pixelprobe.Effects;
import com.android.tools.pixelprobe.ShapeInfo;
import com.android.tools.pixelprobe.TextInfo;
import com.android.tools.pixelprobe.util.Lists;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Layer {
    private final String name;
    private final Type type;
    private final Rectangle2D.Float bounds;
    private final float opacity;
    private final BlendMode blendMode;
    private final boolean clipBase;
    private final List<Layer> children;
    private final BufferedImage image;
    private final ShapeInfo shapeInfo;
    private final TextInfo textInfo;
    private final Effects effects;
    private final boolean open;
    private final boolean visible;

    Layer(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.bounds = builder.bounds;
        this.opacity = builder.opacity;
        this.blendMode = builder.blendMode;
        this.clipBase = builder.clipBase;
        this.children = Lists.immutableCopy(builder.children);
        this.image = builder.image;
        this.shapeInfo = builder.shapeInfo;
        this.textInfo = builder.textInfo;
        this.effects = builder.effects;
        this.open = builder.open;
        this.visible = builder.visible;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public List<Layer> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Float(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    public float getOpacity() {
        return this.opacity;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public boolean isClipBase() {
        return this.clipBase;
    }

    public Effects getEffects() {
        return this.effects;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public ShapeInfo getShapeInfo() {
        return this.shapeInfo;
    }

    public TextInfo getTextInfo() {
        return this.textInfo;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String toString() {
        return "Layer{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", bounds=" + this.bounds + ", opacity=" + this.opacity + ", blendMode=" + (Object)((Object)this.blendMode) + ", children=" + this.children.size() + ", image=" + (this.image != null) + ", text=" + (this.textInfo != null) + ", shape=" + (this.shapeInfo != null) + ", effects=" + (this.effects != null) + ", open=" + this.open + ", visible=" + this.visible + ", clipBase=" + this.clipBase + '}';
    }

    public static final class Builder {
        final String name;
        final Type type;
        final Rectangle2D.Float bounds = new Rectangle2D.Float();
        float opacity = 1.0f;
        BlendMode blendMode = BlendMode.NORMAL;
        boolean clipBase = true;
        final List<Layer> children = new ArrayList<Layer>();
        BufferedImage image;
        ShapeInfo shapeInfo;
        TextInfo textInfo;
        Effects effects;
        private boolean open = true;
        private boolean visible = true;

        public Builder(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public Rectangle2D bounds() {
            return new Rectangle2D.Float(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        }

        public Builder bounds(int left, int top, int width, int height) {
            this.bounds.setRect(left, top, width, height);
            return this;
        }

        public Builder opacity(float opacity) {
            this.opacity = opacity;
            return this;
        }

        public Builder blendMode(BlendMode blendMode) {
            this.blendMode = blendMode;
            return this;
        }

        public Builder clipBase(boolean clipBase) {
            this.clipBase = clipBase;
            return this;
        }

        public Builder addLayer(Layer layer) {
            this.children.add(layer);
            return this;
        }

        public Builder image(BufferedImage image) {
            this.image = image;
            return this;
        }

        public Builder shapeInfo(ShapeInfo info) {
            this.shapeInfo = info;
            return this;
        }

        public Builder textInfo(TextInfo info) {
            this.textInfo = info;
            return this;
        }

        public Builder effects(Effects effects) {
            this.effects = effects;
            return this;
        }

        public Builder open(boolean open) {
            this.open = open;
            return this;
        }

        public Builder visible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public Layer build() {
            return new Layer(this);
        }
    }

    public static enum Type {
        ADJUSTMENT,
        IMAGE,
        GROUP,
        SHAPE,
        TEXT;

    }
}

