/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.ui;

import com.android.tools.adtui.util.FormScalingUtil;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleClient;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleTask;
import com.google.appindexing.ui.AppIndexingDialog;
import com.google.appindexing.util.AppIndexingBundle;
import com.google.gct.login.GoogleLogin;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CheckErrorDialog
extends DialogWrapper {
    private static final String PERSONAL_CONTENT_HELP_URL = "https://firebase.google.com/docs/app-indexing/android/personal-content";
    private static final String USER_ACTION_HELP_URL = "https://firebase.google.com/docs/app-indexing/android/log-actions";
    private JPanel myPanel;
    private JComboBox<Module> myModulesComboBox;
    private JPanel myWarningPanel;
    private JLabel myWarningTitle;
    private JLabel myWarningLabel;
    private JButton myLoginButton;
    private Project myProject;
    private FetchAsGoogleTask.RequestType myRequestType;
    private final SortedComboBoxModel<Module> myModules;

    private static Logger getLog() {
        return Logger.getInstance(CheckErrorDialog.class);
    }

    public CheckErrorDialog(@NotNull Project project, FetchAsGoogleTask.RequestType requestType) {
        super(project);
        Comparator comparator = (module, module1) -> module.getName().compareToIgnoreCase(module1.getName());
        this.$$$setupUI$$$();
        this.myModules = new SortedComboBoxModel(comparator);
        FormScalingUtil.scaleComponentTree(((Object)((Object)this)).getClass(), (JComponent)this.myPanel);
        this.init();
        this.setTitle(AppIndexingBundle.message("app.indexing.check.error.dialog.title", new Object[0]));
        this.myProject = project;
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        Arrays.stream(modules).filter(AppIndexingDialog::isModuleAccepted).forEach(arg_0 -> this.myModules.add(arg_0));
        if (this.myModules.getSize() != 0) {
            this.myModules.setSelectedItem(this.myModules.getElementAt(0));
        }
        this.myModulesComboBox.setModel((ComboBoxModel<Module>)this.myModules);
        this.myModulesComboBox.setRenderer((ListCellRenderer<Module>)new ListCellRendererWrapper<Module>(){

            public void customize(JList list, Module value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setIcon(ModuleType.get((Module)value).getIcon());
                    this.setText(value.getName());
                }
            }
        });
        this.myRequestType = requestType;
        this.myLoginButton.addActionListener(e -> {
            try {
                this.myLoginButton.setEnabled(false);
                GoogleLogin.getInstance().logIn(null, () -> ApplicationManager.getApplication().invokeLater(this::verifyInput, ModalityState.any()));
            }
            catch (Exception ex) {
                CheckErrorDialog.getLog().warn("Failed to login with your Google developer account.", (Throwable)ex);
            }
        });
        this.myWarningTitle.setIcon(AllIcons.General.BalloonError);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doHelpAction() {
        BrowserUtil.browse((String)(this.myRequestType == FetchAsGoogleTask.RequestType.USER_ACTION_LOGGING_DEBUGGING ? USER_ACTION_HELP_URL : PERSONAL_CONTENT_HELP_URL));
    }

    private boolean verifyInput() {
        this.myWarningLabel.setText("");
        this.myLoginButton.setVisible(false);
        this.myWarningPanel.setVisible(false);
        if (this.myModules.getSelectedItem() == null) {
            this.myWarningLabel.setText(AppIndexingBundle.message("app.indexing.module.not.provided.warning.message", new Object[0]));
            this.myWarningPanel.setVisible(true);
            return false;
        }
        if (!GoogleLogin.getInstance().isLoggedIn()) {
            this.myWarningLabel.setText(AppIndexingBundle.message("app.indexing.login.warning.message", new Object[0]));
            this.myLoginButton.setVisible(true);
            this.myLoginButton.setEnabled(true);
            this.myWarningPanel.setVisible(true);
            return false;
        }
        return true;
    }

    protected void doOKAction() {
        if (!this.verifyInput()) {
            return;
        }
        try {
            FetchAsGoogleTask task = FetchAsGoogleTask.createFetchAsGoogleTask(this.myProject, (Module)this.myModules.getSelectedItem(), "", false, this.myRequestType);
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)task);
            super.doOKAction();
        }
        catch (FetchAsGoogleClient.FetchAsGoogleException ex) {
            CheckErrorDialog.getLog().warn((Throwable)ex);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Module:");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myModulesComboBox = jComboBox;
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 0, 10, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("This test helps ensure that Google can find and open your URLs");
        jLabel3.setVerifyInputWhenFocusTarget(false);
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, new Dimension(-1, 50), null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myWarningPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myWarningTitle = jLabel2 = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel2.getFont());
        if (font != null) {
            jLabel2.setFont(font);
        }
        jLabel2.setText("Warning:");
        ((Component)jLabel2).setVisible(false);
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myWarningLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLoginButton = jButton = new JButton();
        jButton.setText("Sign in");
        ((Component)jButton).setVisible(false);
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

