/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/types/FlexibleTypeBoundsChecker;", "", "()V", "baseTypesToMutableEquivalent", "", "Lorg/jetbrains/kotlin/name/FqName;", "fqNames", "Lorg/jetbrains/kotlin/builtins/StandardNames$FqNames;", "mutableToBaseMap", "areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability", "", "a", "Lorg/jetbrains/kotlin/types/KotlinType;", "b", "getBaseBoundFqNameByMutability", "fqName", "type", "descriptors"})
@SourceDebugExtension(value={"SMAP\nflexibleTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 flexibleTypes.kt\norg/jetbrains/kotlin/types/FlexibleTypeBoundsChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1#2:186\n1208#3,2:187\n1238#3,4:189\n*S KotlinDebug\n*F\n+ 1 flexibleTypes.kt\norg/jetbrains/kotlin/types/FlexibleTypeBoundsChecker\n*L\n168#1:187,2\n168#1:189,4\n*E\n"})
public final class FlexibleTypeBoundsChecker {
    @NotNull
    public static final FlexibleTypeBoundsChecker INSTANCE;
    @NotNull
    private static final StandardNames.FqNames fqNames;
    @NotNull
    private static final Map<FqName, FqName> baseTypesToMutableEquivalent;
    @NotNull
    private static final Map<FqName, FqName> mutableToBaseMap;

    private FlexibleTypeBoundsChecker() {
    }

    public final boolean areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability(@NotNull KotlinType a, @NotNull KotlinType b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        ClassifierDescriptor classifierDescriptor = a.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null || (classifierDescriptor = DescriptorUtilsKt.getFqNameSafe(classifierDescriptor)) == null) {
            return false;
        }
        ClassifierDescriptor fqName2 = classifierDescriptor;
        FqName fqName3 = baseTypesToMutableEquivalent.get(fqName2);
        if (fqName3 == null && (fqName3 = mutableToBaseMap.get(fqName2)) == null) {
            return false;
        }
        FqName possiblePairBound = fqName3;
        ClassifierDescriptor classifierDescriptor2 = b.getConstructor().getDeclarationDescriptor();
        return Intrinsics.areEqual((Object)possiblePairBound, (Object)(classifierDescriptor2 != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor2) : null));
    }

    @Nullable
    public final FqName getBaseBoundFqNameByMutability(@NotNull KotlinType type2) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null && (classifierDescriptor = DescriptorUtilsKt.getFqNameSafe(classifierDescriptor)) != null) {
            ClassifierDescriptor p0 = classifierDescriptor;
            boolean bl = false;
            fqName2 = this.getBaseBoundFqNameByMutability((FqName)p0);
        } else {
            fqName2 = null;
        }
        return fqName2;
    }

    @Nullable
    public final FqName getBaseBoundFqNameByMutability(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return baseTypesToMutableEquivalent.containsKey(fqName2) ? fqName2 : mutableToBaseMap.get(fqName2);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        INSTANCE = new FlexibleTypeBoundsChecker();
        fqNames = StandardNames.FqNames.INSTANCE;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)StandardNames.FqNames.iterable, (Object)StandardNames.FqNames.mutableIterable), TuplesKt.to((Object)StandardNames.FqNames.iterator, (Object)StandardNames.FqNames.mutableIterator), TuplesKt.to((Object)StandardNames.FqNames.listIterator, (Object)StandardNames.FqNames.mutableListIterator), TuplesKt.to((Object)StandardNames.FqNames.list, (Object)StandardNames.FqNames.mutableList), TuplesKt.to((Object)StandardNames.FqNames.collection, (Object)StandardNames.FqNames.mutableCollection), TuplesKt.to((Object)StandardNames.FqNames.set, (Object)StandardNames.FqNames.mutableSet), TuplesKt.to((Object)StandardNames.FqNames.map, (Object)StandardNames.FqNames.mutableMap), TuplesKt.to((Object)StandardNames.FqNames.mapEntry, (Object)StandardNames.FqNames.mutableMapEntry)};
        baseTypesToMutableEquivalent = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$associateBy$iv = baseTypesToMutableEquivalent.entrySet();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            FqName fqName2 = (FqName)it.getValue();
            boolean bl2 = false;
            FqName fqName3 = (FqName)it.getKey();
            map.put(fqName2, fqName3);
        }
        mutableToBaseMap = destination$iv$iv;
    }
}

