/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.IncompatibleVersionErrorData;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "collectDiagnostics", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "diagnosticFor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "incompatibilityDiagnosticFor", "source", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "ClassifierUsage", "frontend"})
@SourceDebugExtension(value={"SMAP\nMissingDependencyClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingDependencyClassChecker.kt\norg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1#2:108\n1855#3,2:109\n*S KotlinDebug\n*F\n+ 1 MissingDependencyClassChecker.kt\norg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker\n*L\n93#1:109,2\n*E\n"})
public final class MissingDependencyClassChecker
implements CallChecker {
    @NotNull
    public static final MissingDependencyClassChecker INSTANCE = new MissingDependencyClassChecker();

    private MissingDependencyClassChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        block1: {
            Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object resultingDescriptor = resolvedCall2.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(resultingDescriptor, (String)"resultingDescriptor");
            for (Diagnostic diagnostic : this.collectDiagnostics(reportOn, (CallableDescriptor)resultingDescriptor)) {
                context.getTrace().report(diagnostic);
            }
            DeserializedMemberDescriptor deserializedMemberDescriptor = resultingDescriptor instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)resultingDescriptor : null;
            DeserializedContainerSource containerSource = deserializedMemberDescriptor != null ? deserializedMemberDescriptor.getContainerSource() : null;
            Diagnostic diagnostic = this.incompatibilityDiagnosticFor((SourceElement)containerSource, reportOn);
            if (diagnostic == null) break block1;
            Diagnostic diagnostic2 = diagnostic;
            BindingTrace bindingTrace = context.getTrace();
            Diagnostic p0 = diagnostic2;
            boolean bl = false;
            bindingTrace.report(p0);
        }
    }

    private final Diagnostic diagnosticFor(ClassifierDescriptor descriptor2, PsiElement reportOn) {
        if (descriptor2 instanceof NotFoundClasses.MockClassDescriptor) {
            return Errors.MISSING_DEPENDENCY_CLASS.on(reportOn, DescriptorUtilsKt.getFqNameSafe(descriptor2));
        }
        return this.incompatibilityDiagnosticFor(descriptor2.getSource(), reportOn);
    }

    private final Diagnostic incompatibilityDiagnosticFor(SourceElement source, PsiElement reportOn) {
        if (source instanceof DeserializedContainerSource) {
            IncompatibleVersionErrorData incompatibility = ((DeserializedContainerSource)source).getIncompatibility();
            if (incompatibility != null) {
                return Errors.INCOMPATIBLE_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString(), incompatibility);
            }
            if (((DeserializedContainerSource)source).isPreReleaseInvisible()) {
                return Errors.PRE_RELEASE_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString());
            }
            if (((DeserializedContainerSource)source).getAbiStability() == DeserializedContainerAbiStability.FIR_UNSTABLE) {
                return Errors.FIR_COMPILED_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString());
            }
            if (((DeserializedContainerSource)source).getAbiStability() == DeserializedContainerAbiStability.IR_UNSTABLE) {
                return Errors.IR_WITH_UNSTABLE_ABI_COMPILED_CLASS.on(reportOn, ((DeserializedContainerSource)source).getPresentableString());
            }
        }
        return null;
    }

    private final Set<Diagnostic> collectDiagnostics(PsiElement reportOn, CallableDescriptor descriptor2) {
        Object object;
        Set result2 = CollectionsKt.newLinkedHashSetWithExpectedSize((int)1);
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType != null) {
            KotlinType p0 = kotlinType;
            boolean bl = false;
            MissingDependencyClassChecker.collectDiagnostics$consider$2(reportOn, result2, p0);
        }
        if ((object = descriptor2.getExtensionReceiverParameter()) != null && (object = object.getValue()) != null && (object = object.getType()) != null) {
            Object p0 = object;
            boolean bl = false;
            MissingDependencyClassChecker.collectDiagnostics$consider$2(reportOn, result2, (KotlinType)p0);
        }
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"descriptor.valueParameters");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl = false;
            KotlinType kotlinType2 = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"it.type");
            MissingDependencyClassChecker.collectDiagnostics$consider$2(reportOn, result2, kotlinType2);
        }
        return result2;
    }

    private static final void collectDiagnostics$consider(PsiElement $reportOn, Set<Diagnostic> result2, ClassDescriptor classDescriptor2) {
        block1: {
            Diagnostic diagnostic = INSTANCE.diagnosticFor(classDescriptor2, $reportOn);
            if (diagnostic != null) {
                result2.add(diagnostic);
                return;
            }
            DeclarationDescriptor declarationDescriptor = classDescriptor2.getContainingDeclaration();
            ClassDescriptor classDescriptor3 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor3 == null) break block1;
            ClassDescriptor p0 = classDescriptor3;
            boolean bl = false;
            MissingDependencyClassChecker.collectDiagnostics$consider($reportOn, result2, p0);
        }
    }

    private static final void collectDiagnostics$consider$2(PsiElement $reportOn, Set<Diagnostic> result2, KotlinType type2) {
        block1: {
            if (CallCheckerKt.isComputingDeferredType(INSTANCE, type2)) break block1;
            ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor2 != null) {
                ClassDescriptor p0 = classDescriptor2;
                boolean bl = false;
                MissingDependencyClassChecker.collectDiagnostics$consider($reportOn, result2, p0);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nMissingDependencyClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingDependencyClassChecker.kt\norg/jetbrains/kotlin/resolve/checkers/MissingDependencyClassChecker$ClassifierUsage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        @NotNull
        public static final ClassifierUsage INSTANCE = new ClassifierUsage();

        private ClassifierUsage() {
        }

        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context) {
            block1: {
                Object object;
                Intrinsics.checkNotNullParameter((Object)targetDescriptor, (String)"targetDescriptor");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Diagnostic diagnostic = INSTANCE.diagnosticFor(targetDescriptor, element);
                if (diagnostic != null) {
                    Diagnostic diagnostic2 = diagnostic;
                    object = context.getTrace();
                    Diagnostic p0 = diagnostic2;
                    boolean bl = false;
                    object.report(p0);
                }
                DeserializedMemberDescriptor deserializedMemberDescriptor = targetDescriptor instanceof DeserializedMemberDescriptor ? (DeserializedMemberDescriptor)((Object)targetDescriptor) : null;
                DeserializedContainerSource containerSource = deserializedMemberDescriptor != null ? deserializedMemberDescriptor.getContainerSource() : null;
                Diagnostic diagnostic3 = INSTANCE.incompatibilityDiagnosticFor((SourceElement)containerSource, element);
                if (diagnostic3 == null) break block1;
                object = diagnostic3;
                BindingTrace bindingTrace = context.getTrace();
                Object p0 = object;
                boolean bl = false;
                bindingTrace.report((Diagnostic)p0);
            }
        }
    }
}

