/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "extendThrowableFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getExtendThrowableFunction", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "newThrowableFunction", "throwableConstructors", "", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "undefinedValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "extractThrowableArguments", "Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$ThrowableArguments;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "ThrowableArguments", "Transformer", "backend.js"})
public final class ThrowableLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrSimpleFunctionSymbol extendThrowableFunction;
    @NotNull
    private final List<IrConstructorSymbol> throwableConstructors;
    @NotNull
    private final IrSimpleFunctionSymbol newThrowableFunction;

    public ThrowableLowering(@NotNull JsIrBackendContext context, @NotNull IrSimpleFunctionSymbol extendThrowableFunction) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)extendThrowableFunction, (String)"extendThrowableFunction");
        this.context = context;
        this.extendThrowableFunction = extendThrowableFunction;
        this.throwableConstructors = this.context.getThrowableConstructors();
        this.newThrowableFunction = this.context.getNewThrowableSymbol();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrSimpleFunctionSymbol getExtendThrowableFunction() {
        return this.extendThrowableFunction;
    }

    private final IrExpression undefinedValue() {
        return IrJsUtilsKt.getVoid(this.context);
    }

    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        IrClass enclosingClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)container);
        boolean bl = false;
        IrElementTransformer irElementTransformer = new Transformer();
        IrClass irClass = enclosingClass;
        if (irClass == null) {
            irClass = IrUtilsKt.getFile((IrDeclaration)container);
        }
        irBody.transformChildren(irElementTransformer, (Object)irClass);
    }

    private final ThrowableArguments extractThrowableArguments(IrFunctionAccessExpression $this$extractThrowableArguments) {
        ThrowableArguments throwableArguments;
        switch ($this$extractThrowableArguments.getValueArgumentsCount()) {
            case 0: {
                throwableArguments = new ThrowableArguments(this.undefinedValue(), this.undefinedValue());
                break;
            }
            case 2: {
                IrExpression irExpression = $this$extractThrowableArguments.getValueArgument(0);
                Intrinsics.checkNotNull((Object)irExpression);
                IrExpression irExpression2 = $this$extractThrowableArguments.getValueArgument(1);
                Intrinsics.checkNotNull((Object)irExpression2);
                throwableArguments = new ThrowableArguments(irExpression, irExpression2);
                break;
            }
            default: {
                IrExpression irExpression = $this$extractThrowableArguments.getValueArgument(0);
                Intrinsics.checkNotNull((Object)irExpression);
                IrExpression arg = irExpression;
                IrValueParameter parameter = (IrValueParameter)((IrFunctionSymbol)$this$extractThrowableArguments.getSymbol()).getOwner().getValueParameters().get(0);
                if (IrTypePredicatesKt.isNullableString((IrType)parameter.getType())) {
                    throwableArguments = new ThrowableArguments(arg, this.undefinedValue());
                    break;
                }
                boolean bl = IrTypeUtilsKt.isThrowable((IrType)IrTypesKt.makeNotNull((IrType)parameter.getType()));
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                throwableArguments = new ThrowableArguments(this.undefinedValue(), arg);
            }
        }
        return throwableArguments;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering;)V", "anyConstructor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "data", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "backend.js"})
    public final class Transformer
    implements IrElementTransformer<IrDeclarationParent> {
        @NotNull
        private final IrConstructorSymbol anyConstructor;

        public Transformer() {
            this.anyConstructor = (IrConstructorSymbol)SequencesKt.first((Sequence)IrUtilsKt.getConstructors((IrClassSymbol)ThrowableLowering.this.getContext().getIrBuiltIns().getAnyClass()));
        }

        @NotNull
        public IrStatement visitClass(@NotNull IrClass declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return IrElementTransformer.DefaultImpls.visitClass((IrElementTransformer)this, (IrClass)declaration, (Object)declaration);
        }

        @NotNull
        public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull IrDeclarationParent data) {
            IrCallImpl irCallImpl;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            expression2.transformChildren((IrElementTransformer)this, (Object)data);
            if (!ThrowableLowering.this.throwableConstructors.contains(expression2.getSymbol())) {
                return (IrExpression)expression2;
            }
            ThrowableArguments throwableArguments = ThrowableLowering.this.extractThrowableArguments((IrFunctionAccessExpression)expression2);
            IrExpression messageArg = throwableArguments.component1();
            IrExpression causeArg = throwableArguments.component2();
            IrConstructorCall irConstructorCall = expression2;
            ThrowableLowering throwableLowering = ThrowableLowering.this;
            IrConstructorCall $this$visitConstructorCall_u24lambda_u241 = irConstructorCall;
            boolean bl = false;
            int n = $this$visitConstructorCall_u24lambda_u241.getStartOffset();
            int n2 = $this$visitConstructorCall_u24lambda_u241.getEndOffset();
            IrType irType = $this$visitConstructorCall_u24lambda_u241.getType();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = throwableLowering.newThrowableFunction;
            IrCallImpl it = irCallImpl = new IrCallImpl(n, n2, irType, irSimpleFunctionSymbol, 0, 2, null, null, 192, null);
            boolean bl2 = false;
            it.putValueArgument(0, messageArg);
            it.putValueArgument(1, causeArg);
            return (IrExpression)irCallImpl;
        }

        @NotNull
        public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull IrDeclarationParent data) {
            IrExpression irExpression;
            IrCallImpl irCallImpl;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            expression2.transformChildren((IrElementTransformer)this, (Object)data);
            if (!ThrowableLowering.this.throwableConstructors.contains(expression2.getSymbol())) {
                return (IrExpression)expression2;
            }
            ThrowableArguments throwableArguments = ThrowableLowering.this.extractThrowableArguments((IrFunctionAccessExpression)expression2);
            IrExpression messageArg = throwableArguments.component1();
            IrExpression causeArg = throwableArguments.component2();
            IrClass klass = (IrClass)data;
            int n = expression2.getStartOffset();
            int n2 = expression2.getEndOffset();
            IrValueParameter irValueParameter = klass.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            IrGetValueImpl thisReceiver = new IrGetValueImpl(n, n2, (IrValueSymbol)irValueParameter.getSymbol(), null, 8, null);
            Object[] objectArray = expression2;
            ThrowableLowering throwableLowering = ThrowableLowering.this;
            Object[] $this$visitDelegatingConstructorCall_u24lambda_u243 = objectArray;
            boolean bl = false;
            int n3 = $this$visitDelegatingConstructorCall_u24lambda_u243.getStartOffset();
            int n4 = $this$visitDelegatingConstructorCall_u24lambda_u243.getEndOffset();
            IrType irType = $this$visitDelegatingConstructorCall_u24lambda_u243.getType();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = throwableLowering.getExtendThrowableFunction();
            IrCallImpl it = irCallImpl = new IrCallImpl(n3, n4, irType, irSimpleFunctionSymbol, 0, 3, null, null, 192, null);
            boolean bl2 = false;
            it.putValueArgument(0, (IrExpression)thisReceiver);
            it.putValueArgument(1, messageArg);
            it.putValueArgument(2, causeArg);
            IrCallImpl expressionReplacement = irCallImpl;
            if (!ThrowableLowering.this.getContext().getEs6mode()) {
                irExpression = (IrExpression)expressionReplacement;
            } else {
                objectArray = new IrFunctionAccessExpression[]{new IrDelegatingConstructorCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), ThrowableLowering.this.getContext().getIrBuiltIns().getAnyType(), this.anyConstructor, 0, 0), expressionReplacement};
                irExpression = (IrExpression)JsIrBuilder.INSTANCE.buildComposite(ThrowableLowering.this.getContext().getIrBuiltIns().getUnitType(), CollectionsKt.listOf((Object[])objectArray));
            }
            return irExpression;
        }

        @NotNull
        public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitAnonymousInitializer((IrElementTransformer)this, (IrAnonymousInitializer)declaration, (Object)data);
        }

        @NotNull
        public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitBlock((IrElementTransformer)this, (IrBlock)expression2, (Object)data);
        }

        @NotNull
        public IrBody visitBlockBody(@NotNull IrBlockBody body2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitBlockBody((IrElementTransformer)this, (IrBlockBody)body2, (Object)data);
        }

        @NotNull
        public IrBody visitBody(@NotNull IrBody body2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitBody((IrElementTransformer)this, (IrBody)body2, (Object)data);
        }

        @NotNull
        public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitBranch((IrElementTransformer)this, (IrBranch)branch, (Object)data);
        }

        @NotNull
        public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitBreak((IrElementTransformer)this, (IrBreak)jump, (Object)data);
        }

        @NotNull
        public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitBreakContinue((IrElementTransformer)this, (IrBreakContinue)jump, (Object)data);
        }

        @NotNull
        public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitCall((IrElementTransformer)this, (IrCall)expression2, (Object)data);
        }

        @NotNull
        public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitCallableReference((IrElementTransformer)this, expression2, (Object)data);
        }

        @NotNull
        public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitCatch((IrElementTransformer)this, (IrCatch)aCatch, (Object)data);
        }

        @NotNull
        public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitClassReference((IrElementTransformer)this, (IrClassReference)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitComposite((IrElementTransformer)this, (IrComposite)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitConst(@NotNull IrConst<?> expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitConst((IrElementTransformer)this, expression2, (Object)data);
        }

        @NotNull
        public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitConstantArray((IrElementTransformer)this, (IrConstantArray)expression2, (Object)data);
        }

        @NotNull
        public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitConstantObject((IrElementTransformer)this, (IrConstantObject)expression2, (Object)data);
        }

        @NotNull
        public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitConstantPrimitive((IrElementTransformer)this, (IrConstantPrimitive)expression2, (Object)data);
        }

        @NotNull
        public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitConstantValue((IrElementTransformer)this, (IrConstantValue)expression2, (Object)data);
        }

        @NotNull
        public IrStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitConstructor((IrElementTransformer)this, (IrConstructor)declaration, (Object)data);
        }

        @NotNull
        public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitContainerExpression((IrElementTransformer)this, (IrContainerExpression)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitContinue((IrElementTransformer)this, (IrContinue)jump, (Object)data);
        }

        @NotNull
        public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitDeclaration((IrElementTransformer)this, (IrDeclarationBase)declaration, (Object)data);
        }

        @NotNull
        public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitDeclarationReference((IrElementTransformer)this, (IrDeclarationReference)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitDoWhileLoop((IrElementTransformer)this, (IrDoWhileLoop)loop, (Object)data);
        }

        @NotNull
        public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitDynamicExpression((IrElementTransformer)this, (IrDynamicExpression)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression((IrElementTransformer)this, (IrDynamicMemberExpression)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression((IrElementTransformer)this, (IrDynamicOperatorExpression)expression2, (Object)data);
        }

        @NotNull
        public IrElement visitElement(@NotNull IrElement element, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitElement((IrElementTransformer)this, (IrElement)element, (Object)data);
        }

        @NotNull
        public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitElseBranch((IrElementTransformer)this, (IrElseBranch)branch, (Object)data);
        }

        @NotNull
        public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitEnumConstructorCall((IrElementTransformer)this, (IrEnumConstructorCall)expression2, (Object)data);
        }

        @NotNull
        public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitEnumEntry((IrElementTransformer)this, (IrEnumEntry)declaration, (Object)data);
        }

        @NotNull
        public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitErrorCallExpression((IrElementTransformer)this, (IrErrorCallExpression)expression2, (Object)data);
        }

        @NotNull
        public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitErrorDeclaration((IrElementTransformer)this, (IrErrorDeclaration)declaration, (Object)data);
        }

        @NotNull
        public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitErrorExpression((IrElementTransformer)this, (IrErrorExpression)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitExpression((IrElementTransformer)this, (IrExpression)expression2, (Object)data);
        }

        @NotNull
        public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitExpressionBody((IrElementTransformer)this, (IrExpressionBody)body2, (Object)data);
        }

        @NotNull
        public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitExternalPackageFragment((IrElementTransformer)this, (IrExternalPackageFragment)declaration, (Object)data);
        }

        @NotNull
        public IrStatement visitField(@NotNull IrField declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitField((IrElementTransformer)this, (IrField)declaration, (Object)data);
        }

        @NotNull
        public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitFieldAccess((IrElementTransformer)this, (IrFieldAccessExpression)expression2, (Object)data);
        }

        @NotNull
        public IrFile visitFile(@NotNull IrFile declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitFile((IrElementTransformer)this, (IrFile)declaration, (Object)data);
        }

        @NotNull
        public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitFunction((IrElementTransformer)this, (IrFunction)declaration, (Object)data);
        }

        @NotNull
        public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitFunctionAccess((IrElementTransformer)this, (IrFunctionAccessExpression)expression2, (Object)data);
        }

        @NotNull
        public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitFunctionExpression((IrElementTransformer)this, (IrFunctionExpression)expression2, (Object)data);
        }

        @NotNull
        public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitFunctionReference((IrElementTransformer)this, (IrFunctionReference)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitGetClass((IrElementTransformer)this, (IrGetClass)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitGetEnumValue((IrElementTransformer)this, (IrGetEnumValue)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitGetField((IrElementTransformer)this, (IrGetField)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitGetObjectValue((IrElementTransformer)this, (IrGetObjectValue)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitGetValue((IrElementTransformer)this, (IrGetValue)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall((IrElementTransformer)this, (IrInstanceInitializerCall)expression2, (Object)data);
        }

        @NotNull
        public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty((IrElementTransformer)this, (IrLocalDelegatedProperty)declaration, (Object)data);
        }

        @NotNull
        public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementTransformer)this, (IrLocalDelegatedPropertyReference)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitLoop(@NotNull IrLoop loop, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitLoop((IrElementTransformer)this, (IrLoop)loop, (Object)data);
        }

        @NotNull
        public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitMemberAccess((IrElementTransformer)this, expression2, (Object)data);
        }

        @NotNull
        public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitModuleFragment((IrElementTransformer)this, (IrModuleFragment)declaration, (Object)data);
        }

        @NotNull
        public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitPackageFragment((IrElementTransformer)this, (IrPackageFragment)declaration, (Object)data);
        }

        @NotNull
        public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitProperty((IrElementTransformer)this, (IrProperty)declaration, (Object)data);
        }

        @NotNull
        public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitPropertyReference((IrElementTransformer)this, (IrPropertyReference)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitRawFunctionReference((IrElementTransformer)this, (IrRawFunctionReference)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitReturn((IrElementTransformer)this, (IrReturn)expression2, (Object)data);
        }

        @NotNull
        public IrStatement visitScript(@NotNull IrScript declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitScript((IrElementTransformer)this, (IrScript)declaration, (Object)data);
        }

        @NotNull
        public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSetField((IrElementTransformer)this, (IrSetField)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitSetValue(@NotNull IrSetValue expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSetValue((IrElementTransformer)this, (IrSetValue)expression2, (Object)data);
        }

        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSimpleFunction((IrElementTransformer)this, (IrSimpleFunction)declaration, (Object)data);
        }

        @NotNull
        public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSingletonReference((IrElementTransformer)this, (IrGetSingletonValue)expression2, (Object)data);
        }

        @NotNull
        public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSpreadElement((IrElementTransformer)this, (IrSpreadElement)spread, (Object)data);
        }

        @NotNull
        public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitStringConcatenation((IrElementTransformer)this, (IrStringConcatenation)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSuspendableExpression((IrElementTransformer)this, (IrSuspendableExpression)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSuspensionPoint((IrElementTransformer)this, (IrSuspensionPoint)expression2, (Object)data);
        }

        @NotNull
        public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitSyntheticBody((IrElementTransformer)this, (IrSyntheticBody)body2, (Object)data);
        }

        @NotNull
        public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitThrow((IrElementTransformer)this, (IrThrow)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitTry(@NotNull IrTry aTry, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitTry((IrElementTransformer)this, (IrTry)aTry, (Object)data);
        }

        @NotNull
        public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitTypeAlias((IrElementTransformer)this, (IrTypeAlias)declaration, (Object)data);
        }

        @NotNull
        public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitTypeOperator((IrElementTransformer)this, (IrTypeOperatorCall)expression2, (Object)data);
        }

        @NotNull
        public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitTypeParameter((IrElementTransformer)this, (IrTypeParameter)declaration, (Object)data);
        }

        @NotNull
        public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitValueAccess((IrElementTransformer)this, (IrValueAccessExpression)expression2, (Object)data);
        }

        @NotNull
        public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitValueParameter((IrElementTransformer)this, (IrValueParameter)declaration, (Object)data);
        }

        @NotNull
        public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitVararg((IrElementTransformer)this, (IrVararg)expression2, (Object)data);
        }

        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitVariable((IrElementTransformer)this, (IrVariable)declaration, (Object)data);
        }

        @NotNull
        public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitWhen((IrElementTransformer)this, (IrWhen)expression2, (Object)data);
        }

        @NotNull
        public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop, @NotNull IrDeclarationParent data) {
            return IrElementTransformer.DefaultImpls.visitWhileLoop((IrElementTransformer)this, (IrWhileLoop)loop, (Object)data);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$ThrowableArguments;", "", "message", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "cause", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getCause", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getMessage", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "backend.js"})
    public static final class ThrowableArguments {
        @NotNull
        private final IrExpression message;
        @NotNull
        private final IrExpression cause;

        public ThrowableArguments(@NotNull IrExpression message, @NotNull IrExpression cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            this.message = message;
            this.cause = cause;
        }

        @NotNull
        public final IrExpression getMessage() {
            return this.message;
        }

        @NotNull
        public final IrExpression getCause() {
            return this.cause;
        }

        @NotNull
        public final IrExpression component1() {
            return this.message;
        }

        @NotNull
        public final IrExpression component2() {
            return this.cause;
        }

        @NotNull
        public final ThrowableArguments copy(@NotNull IrExpression message, @NotNull IrExpression cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            return new ThrowableArguments(message, cause);
        }

        public static /* synthetic */ ThrowableArguments copy$default(ThrowableArguments throwableArguments, IrExpression irExpression, IrExpression irExpression2, int n, Object object) {
            if ((n & 1) != 0) {
                irExpression = throwableArguments.message;
            }
            if ((n & 2) != 0) {
                irExpression2 = throwableArguments.cause;
            }
            return throwableArguments.copy(irExpression, irExpression2);
        }

        @NotNull
        public String toString() {
            return "ThrowableArguments(message=" + this.message + ", cause=" + this.cause + ')';
        }

        public int hashCode() {
            int result2 = this.message.hashCode();
            result2 = result2 * 31 + this.cause.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThrowableArguments)) {
                return false;
            }
            ThrowableArguments throwableArguments = (ThrowableArguments)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)throwableArguments.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cause, (Object)throwableArguments.cause);
        }
    }
}

