/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.ir.ValueRemapper;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6_BOX_PARAMETER;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6_BOX_PARAMETER_DEFAULT_RESOLUTION;
import org.jetbrains.kotlin.ir.backend.js.lower.PrimaryConstructorLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.PrimaryConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\f\u0010\u0013\u001a\u00020\n*\u00020\fH\u0002J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\b*\u00020\u0015H\u0002J\u001c\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6AddBoxParameterToConstructorsLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "createJsObjectLiteral", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "hackEnums", "", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "hackExceptions", "hackSimpleClassWithCapturing", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "addBoxParameter", "generateBoxParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateDefaultResolution", "replaceThisWithBoxBeforeSuperCall", "", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "boxParameterSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nES6AddBoxParameterLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ES6AddBoxParameterLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6AddBoxParameterToConstructorsLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n1#2:184\n350#3,7:185\n350#3,7:192\n*S KotlinDebug\n*F\n+ 1 ES6AddBoxParameterLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6AddBoxParameterToConstructorsLowering\n*L\n140#1:185,7\n144#1:192,7\n*E\n"})
public final class ES6AddBoxParameterToConstructorsLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public ES6AddBoxParameterToConstructorsLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!this.context.getEs6mode() || !(declaration instanceof IrConstructor) || IrJsUtilsKt.hasStrictSignature((IrConstructor)declaration, this.context)) {
            return null;
        }
        this.hackEnums((IrConstructor)declaration);
        this.hackExceptions((IrConstructor)declaration);
        this.hackSimpleClassWithCapturing((IrConstructor)declaration);
        if (!PrimaryConstructorLoweringKt.isSyntheticPrimaryConstructor(declaration)) {
            this.addBoxParameter((IrConstructor)declaration);
        }
        return null;
    }

    private final void addBoxParameter(IrConstructor $this$addBoxParameter) {
        IrValueParameter irValueParameter;
        IrClass irClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)$this$addBoxParameter));
        IrValueParameter it = irValueParameter = this.generateBoxParameter($this$addBoxParameter, irClass);
        boolean bl = false;
        $this$addBoxParameter.setValueParameters(CollectionsKt.plus((Collection)$this$addBoxParameter.getValueParameters(), (Object)it));
        IrValueParameter boxParameter = irValueParameter;
        IrBody irBody = $this$addBoxParameter.getBody();
        IrBlockBody irBlockBody = irBody instanceof IrBlockBody ? (IrBlockBody)irBody : null;
        if (irBlockBody == null) {
            return;
        }
        IrBlockBody body2 = irBlockBody;
        boolean isBoxUsed = this.replaceThisWithBoxBeforeSuperCall((IrBody)body2, irClass, (IrValueSymbol)boxParameter.getSymbol());
        if (isBoxUsed) {
            body2.getStatements().add(0, this.generateDefaultResolution(boxParameter));
        }
    }

    private final IrExpression createJsObjectLiteral() {
        return (IrExpression)JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIntrinsics().getJsEmptyObject(), null, null, null, null, 30, null);
    }

    private final IrValueParameter generateBoxParameter(IrConstructor $this$generateBoxParameter, IrClass irClass) {
        JsIrBuilder jsIrBuilder = JsIrBuilder.INSTANCE;
        String string2 = Namer.INSTANCE.getES6_BOX_PARAMETER_NAME();
        int n = $this$generateBoxParameter.getValueParameters().size();
        IrType irType = IrTypesKt.makeNullable((IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)irClass)));
        ES6_BOX_PARAMETER eS6_BOX_PARAMETER = ES6_BOX_PARAMETER.INSTANCE;
        return jsIrBuilder.buildValueParameter((IrFunction)$this$generateBoxParameter, string2, n, irType, true, (IrDeclarationOrigin)eS6_BOX_PARAMETER);
    }

    private final IrExpression generateDefaultResolution(IrValueParameter $this$generateDefaultResolution) {
        DeclarationIrBuilder $this$generateDefaultResolution_u24lambda_u241 = LowerUtilsKt.createIrBuilder((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)$this$generateDefaultResolution.getSymbol()), (int)-1, (int)-1);
        boolean bl = false;
        return (IrExpression)ExpressionHelpersKt.irIfThen((IrBuilderWithScope)((IrBuilderWithScope)$this$generateDefaultResolution_u24lambda_u241), (IrType)$this$generateDefaultResolution_u24lambda_u241.getContext().getIrBuiltIns().getUnitType(), (IrExpression)ExpressionHelpersKt.irEqeqeqWithoutBox((IrBuilderWithScope)((IrBuilderWithScope)$this$generateDefaultResolution_u24lambda_u241), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$generateDefaultResolution_u24lambda_u241), (IrType)$this$generateDefaultResolution.getType(), (IrValueSymbol)((IrValueSymbol)$this$generateDefaultResolution.getSymbol()))), (IrExpression)IrJsUtilsKt.getVoid(this.context)), (IrExpression)((IrExpression)ExpressionHelpersKt.irSet$default((IrBuilderWithScope)((IrBuilderWithScope)$this$generateDefaultResolution_u24lambda_u241), (IrValueSymbol)((IrValueSymbol)$this$generateDefaultResolution.getSymbol()), (IrExpression)this.createJsObjectLiteral(), null, (int)4, null)), (IrStatementOrigin)((IrStatementOrigin)ES6_BOX_PARAMETER_DEFAULT_RESOLUTION.INSTANCE));
    }

    private final boolean replaceThisWithBoxBeforeSuperCall(IrBody $this$replaceThisWithBoxBeforeSuperCall, IrClass irClass, IrValueSymbol boxParameterSymbol) {
        Ref.BooleanRef meetCapturing = new Ref.BooleanRef();
        Ref.BooleanRef meetDelegatingConstructor = new Ref.BooleanRef();
        IrValueParameter irValueParameter = irClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrValueParameterSymbol selfParameterSymbol = irValueParameter.getSymbol();
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)selfParameterSymbol, (Object)boxParameterSymbol));
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)$this$replaceThisWithBoxBeforeSuperCall), (IrElementTransformerVoid)((IrElementTransformerVoid)new ValueRemapper(meetDelegatingConstructor, boxParameterSymbol, meetCapturing, map){
            final /* synthetic */ Ref.BooleanRef $meetDelegatingConstructor;
            final /* synthetic */ IrValueSymbol $boxParameterSymbol;
            final /* synthetic */ Ref.BooleanRef $meetCapturing;
            {
                this.$meetDelegatingConstructor = $meetDelegatingConstructor;
                this.$boxParameterSymbol = $boxParameterSymbol;
                this.$meetCapturing = $meetCapturing;
                super($super_call_param$1);
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                return this.$meetDelegatingConstructor.element ? (IrExpression)expression2 : super.visitGetValue(expression2);
            }

            @NotNull
            public IrExpression visitSetField(@NotNull IrSetField expression2) {
                IrGetValue receiver;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (this.$meetDelegatingConstructor.element) {
                    return (IrExpression)expression2;
                }
                IrExpression newExpression = super.visitSetField(expression2);
                IrExpression irExpression = expression2.getReceiver();
                IrGetValue irGetValue = receiver = irExpression instanceof IrGetValue ? (IrGetValue)irExpression : null;
                if (Intrinsics.areEqual((Object)(irGetValue != null ? irGetValue.getSymbol() : null), (Object)this.$boxParameterSymbol)) {
                    this.$meetCapturing.element = true;
                }
                return newExpression;
            }

            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.$meetDelegatingConstructor.element = true;
                return super.visitDelegatingConstructorCall(expression2);
            }
        }));
        return meetCapturing.element;
    }

    private final void hackEnums(IrConstructor constructor) {
        constructor.transformChildren((IrElementTransformer)new IrElementTransformerVoid(){

            @NotNull
            public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression irExpression = expression2.getArgument();
                IrDelegatingConstructorCall irDelegatingConstructorCall = irExpression instanceof IrDelegatingConstructorCall ? (IrDelegatingConstructorCall)irExpression : null;
                return irDelegatingConstructorCall != null ? (IrExpression)irDelegatingConstructorCall : (IrExpression)expression2;
            }
        }, null);
    }

    /*
     * Unable to fully structure code
     */
    private final void hackSimpleClassWithCapturing(IrConstructor constructor) {
        block13: {
            block12: {
                irClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)constructor));
                if (IrUtilsKt.getSuperClass((IrClass)irClass) != null || !irClass.isInner() && !AdditionalIrUtilsKt.isLocal((IrDeclaration)((IrDeclaration)irClass))) {
                    return;
                }
                var5_3 = constructor.getBody();
                v0 = var5_3 instanceof IrBlockBody != false ? (IrBlockBody)var5_3 : null;
                if (v0 == null || (v0 = v0.getStatements()) == null) {
                    return;
                }
                $this$indexOfFirst$iv = statements = v0;
                $i$f$indexOfFirst = false;
                index$iv = 0;
                var8_9 = $this$indexOfFirst$iv.iterator();
                while (var8_9.hasNext()) {
                    item$iv = var8_9.next();
                    it = (IrStatement)item$iv;
                    $i$a$-indexOfFirst-ES6AddBoxParameterToConstructorsLowering$hackSimpleClassWithCapturing$delegationConstructorIndex$1 = false;
                    if (it instanceof IrDelegatingConstructorCall) {
                        v1 = index$iv;
                        break block12;
                    }
                    ++index$iv;
                }
                v1 = delegationConstructorIndex = -1;
            }
            if (delegationConstructorIndex == -1) {
                return;
            }
            $this$indexOfFirst$iv = statements;
            $i$f$indexOfFirst = false;
            index$iv = 0;
            var9_11 = $this$indexOfFirst$iv.iterator();
            while (var9_11.hasNext()) {
                block15: {
                    block14: {
                        item$iv = var9_11.next();
                        statement = (IrStatement)item$iv;
                        $i$a$-indexOfFirst-ES6AddBoxParameterToConstructorsLowering$hackSimpleClassWithCapturing$firstClassFieldAssignment$1 = false;
                        if (!(statement instanceof IrSetField)) ** GOTO lbl-1000
                        if (((IrSetField)statement).getReceiver() == null) break block14;
                        $i$a$-let-ES6AddBoxParameterToConstructorsLowering$hackSimpleClassWithCapturing$firstClassFieldAssignment$1$1 = false;
                        if (!(it instanceof IrGetValue)) ** GOTO lbl-1000
                        v2 = irClass.getThisReceiver();
                        if (Intrinsics.areEqual((Object)((IrGetValue)it).getSymbol(), (Object)(v2 != null ? v2.getSymbol() : null))) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        v4 = v3;
                        break block15;
                    }
                    v4 = false;
                }
                if (v4) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                if (v5) {
                    v6 = index$iv;
                    break block13;
                }
                ++index$iv;
            }
            v6 = firstClassFieldAssignment = -1;
        }
        if (firstClassFieldAssignment == -1 || firstClassFieldAssignment > delegationConstructorIndex) {
            return;
        }
        statements.add(firstClassFieldAssignment, statements.get(delegationConstructorIndex));
        statements.remove(delegationConstructorIndex + 1);
    }

    private final void hackExceptions(IrConstructor constructor) {
        IrSimpleFunctionSymbol setPropertiesSymbol = this.context.getSetPropertiesToThrowableInstanceSymbol();
        IrBody irBody = constructor.getBody();
        Object object = irBody instanceof IrBlockBody ? (IrBlockBody)irBody : null;
        if (object == null || (object = object.getStatements()) == null) {
            return;
        }
        Object statements = object;
        int callIndex = -1;
        int superCallIndex = -1;
        int n = statements.size();
        for (int i = 0; i < n; ++i) {
            IrStatement s = (IrStatement)statements.get(i);
            if (s instanceof IrCall && ((IrCall)s).getSymbol() == setPropertiesSymbol) {
                callIndex = i;
            }
            if (!(s instanceof IrDelegatingConstructorCall) || ((IrConstructor)((IrDelegatingConstructorCall)s).getSymbol().getOwner()).getOrigin() != PrimaryConstructorLowering.SYNTHETIC_PRIMARY_CONSTRUCTOR.INSTANCE) continue;
            superCallIndex = i;
        }
        if (callIndex != -1 && superCallIndex != -1) {
            IrStatement tmp = (IrStatement)statements.get(callIndex);
            statements.set(callIndex, statements.get(superCallIndex));
            statements.set(superCallIndex, tmp);
        }
    }
}

