/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.export.ErrorDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGenerator;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.export.Exportability;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedClass;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedClassDeclarationsInfo;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedConstructor;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedFunction;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedModule;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedNamespace;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedObject;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedParameter;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedProperty;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedRegularClass;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedType;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedVisibility;
import org.jetbrains.kotlin.ir.backend.js.export.TransitiveExportCollector;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddBoxParameterLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00fa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J:\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001eH\u0002J6\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0016\b\u0002\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00120$H\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00122\u0006\u0010&\u001a\u00020'H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00122\u0006\u0010)\u001a\u00020*H\u0002J\u001e\u0010+\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J \u0010,\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J$\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00122\u0006\u00103\u001a\u000204H\u0002J \u00105\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010\u00122\u0006\u0010;\u001a\u00020<H\u0002J\u001c\u0010=\u001a\u00020\u00122\u0006\u0010;\u001a\u00020<2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?H\u0002J\u001a\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020\u001c2\b\b\u0002\u0010B\u001a\u00020\u0005H\u0002J\u0010\u0010C\u001a\u00020?2\u0006\u0010A\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020\u000e2\u0006\u00103\u001a\u000204H\u0002J\u001e\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0\u001b2\b\b\u0002\u0010N\u001a\u00020OJ\u0014\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\u0006\u0010P\u001a\u00020QJ\u001a\u0010R\u001a\u00020S*\b\u0012\u0004\u0012\u00020\u00120T2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010U\u001a\u00020S*\b\u0012\u0004\u0012\u00020\u00120T2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\f\u0010V\u001a\u00020\u0005*\u00020\u001cH\u0002J\u0012\u0010W\u001a\b\u0012\u0004\u0012\u00020\u001c0X*\u00020YH\u0002J\f\u0010Z\u001a\u00020?*\u00020\u0010H\u0002J\f\u0010[\u001a\u00020\\*\u00020\u0014H\u0002J\f\u0010]\u001a\u00020\u0005*\u00020\u0010H\u0002J\f\u0010^\u001a\u00020\u0005*\u00020\u001cH\u0002J\f\u0010_\u001a\u00020\u0005*\u000209H\u0002J\u001a\u0010`\u001a\u00020\u0005*\u00020\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\f\u0010a\u001a\u00020\u0005*\u00020\u0010H\u0002J\f\u0010b\u001a\u00020\u0005*\u00020\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/export/ExportModelGenerator;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "generateNamespacesForPackages", "", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getGenerateNamespacesForPackages", "()Z", "transitiveExportCollector", "Lorg/jetbrains/kotlin/ir/backend/js/export/TransitiveExportCollector;", "classExportability", "Lorg/jetbrains/kotlin/ir/backend/js/export/Exportability;", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "exportAsEnumMember", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;", "candidate", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "enumEntriesToOrdinal", "", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "", "exportClass", "superTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "members", "", "nestedClasses", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedClass;", "exportClassDeclarations", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedClassDeclarationsInfo;", "specialProcessing", "Lkotlin/Function1;", "exportConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "exportDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "exportDeclarationImplicitly", "exportEnumClass", "exportEnumEntry", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedProperty;", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "enumEntries", "exportFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "exportOrdinaryClass", "exportParameter", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedParameter;", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "exportProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "exportPropertyUnsafely", "specializeType", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedType;", "exportType", "type", "shouldCalculateExportedSupertypeForImplicit", "exportTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "exportTypeParameter", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedType$TypeParameter;", "typeParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "functionExportability", "generateExport", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedModule;", "modules", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "moduleKind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "addMagicInterfaceProperty", "", "", "addMagicPropertyForInterfaceImplementation", "canBeUsedAsSuperTypeOfExportedClasses", "collectSuperTransitiveHierarchy", "", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "generateTagType", "getExportedIdentifier", "", "isOwnMagicPropertyAdded", "shouldAddMagicPropertyOfSuper", "shouldBeExported", "shouldContainImplementationOfMagicProperty", "shouldNotBeImplemented", "shouldPresentInsideImplementsClause", "backend.js"})
@SourceDebugExtension(value={"SMAP\nExportModelGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/export/ExportModelGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,861:1\n1360#2:862\n1446#2,5:863\n1360#2:868\n1446#2,5:869\n1549#2:874\n1620#2,3:875\n766#2:878\n857#2,2:879\n1549#2:881\n1620#2,3:882\n819#2:885\n847#2,2:886\n1549#2:888\n1620#2,3:889\n1549#2:892\n1620#2,3:893\n766#2:896\n857#2,2:897\n1549#2:899\n1620#2,3:900\n766#2:903\n857#2,2:904\n800#2,11:906\n1603#2,9:917\n1855#2:926\n1856#2:928\n1612#2:929\n1747#2,3:930\n766#2:933\n857#2,2:934\n1549#2:936\n1620#2,3:937\n2661#2,7:940\n1747#2,3:948\n1549#2:951\n1620#2,3:952\n766#2:955\n857#2,2:956\n1549#2:958\n1620#2,3:959\n766#2:962\n857#2,2:963\n766#2:965\n857#2,2:966\n1549#2:968\n1620#2,3:969\n766#2:972\n857#2,2:973\n1549#2:975\n1620#2,3:976\n1549#2:979\n1620#2,3:980\n2661#2,7:983\n2661#2,7:994\n2661#2,7:1001\n1549#2:1008\n1620#2,3:1009\n1549#2:1013\n1620#2,3:1014\n2661#2,7:1017\n1549#2:1024\n1620#2,3:1025\n1747#2,3:1028\n1747#2,3:1031\n1#3:927\n1#3:947\n125#4:990\n152#4,3:991\n216#5:1012\n*S KotlinDebug\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/export/ExportModelGenerator\n*L\n37#1:862\n37#1:863,5\n49#1:868\n49#1:869,5\n87#1:874\n87#1:875,3\n94#1:878\n94#1:879,2\n95#1:881\n95#1:882,3\n105#1:885\n105#1:886,2\n105#1:888\n105#1:889,3\n222#1:892\n222#1:893,3\n224#1:896\n224#1:897,2\n225#1:899\n225#1:900,3\n226#1:903\n226#1:904,2\n271#1:906,11\n272#1:917,9\n272#1:926\n272#1:928\n272#1:929\n370#1:930,3\n381#1:933\n381#1:934,2\n388#1:936\n388#1:937,3\n389#1:940,7\n402#1:948,3\n427#1:951\n427#1:952,3\n430#1:955\n430#1:956,2\n431#1:958\n431#1:959,3\n432#1:962\n432#1:963,2\n435#1:965\n435#1:966,2\n436#1:968\n436#1:969,3\n437#1:972\n437#1:973,2\n484#1:975\n484#1:976,3\n485#1:979\n485#1:980,3\n486#1:983,7\n489#1:994,7\n546#1:1001,7\n587#1:1008\n587#1:1009,3\n603#1:1013\n603#1:1014,3\n603#1:1017,7\n618#1:1024\n618#1:1025,3\n638#1:1028,3\n667#1:1031,3\n272#1:927\n488#1:990\n488#1:991,3\n600#1:1012\n*E\n"})
public final class ExportModelGenerator {
    @NotNull
    private final JsIrBackendContext context;
    private final boolean generateNamespacesForPackages;
    @NotNull
    private final TransitiveExportCollector transitiveExportCollector;

    public ExportModelGenerator(@NotNull JsIrBackendContext context, boolean generateNamespacesForPackages) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.generateNamespacesForPackages = generateNamespacesForPackages;
        this.transitiveExportCollector = new TransitiveExportCollector(this.context);
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public final boolean getGenerateNamespacesForPackages() {
        return this.generateNamespacesForPackages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ExportedDeclaration> generateExport(@NotNull IrPackageFragment file2) {
        List list2;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FqName namespaceFqName = file2.getFqName();
        Iterable $this$flatMap$iv = file2.getDeclarations();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrDeclaration declaration = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object)this.exportDeclaration(declaration));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List exports = (List)destination$iv$iv;
        if (exports.isEmpty()) {
            list2 = CollectionsKt.emptyList();
        } else if (!this.generateNamespacesForPackages || namespaceFqName.isRoot()) {
            list2 = exports;
        } else {
            String string2 = namespaceFqName.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"namespaceFqName.toString()");
            list2 = CollectionsKt.listOf((Object)new ExportedNamespace(string2, exports));
        }
        return list2;
    }

    @NotNull
    public final ExportedModule generateExport(@NotNull Iterable<? extends IrModuleFragment> modules, @NotNull ModuleKind moduleKind) {
        Iterable list$iv$iv;
        IrModuleFragment it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter((Object)((Object)moduleKind), (String)"moduleKind");
        Object object = this.context.getConfiguration().get(CommonConfigurationKeys.MODULE_NAME);
        Intrinsics.checkNotNull((Object)object);
        Iterable<? extends IrModuleFragment> iterable = modules;
        List list2 = this.context.getExternalPackageFragment().values();
        ModuleKind moduleKind2 = moduleKind;
        String string2 = (String)object;
        boolean $i$f$flatMap = false;
        void var5_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrModuleFragment)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        $this$flatMap$iv = CollectionsKt.plus(list2, (Iterable)list3);
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrFile)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.generateExport((IrPackageFragment)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list4 = list2 = (List)destination$iv$iv;
        ModuleKind moduleKind3 = moduleKind2;
        String string3 = string2;
        return new ExportedModule(string3, moduleKind3, list4);
    }

    public static /* synthetic */ ExportedModule generateExport$default(ExportModelGenerator exportModelGenerator, Iterable iterable, ModuleKind moduleKind, int n, Object object) {
        if ((n & 2) != 0) {
            moduleKind = ModuleKind.PLAIN;
        }
        return exportModelGenerator.generateExport(iterable, moduleKind);
    }

    private final ExportedDeclaration exportDeclaration(IrDeclaration declaration) {
        ExportedDeclaration exportedDeclaration;
        IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.access$getExportCandidate(declaration);
        if (irDeclarationWithName == null) {
            return null;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        if (!ExportModelGeneratorKt.access$shouldDeclarationBeExportedImplicitlyOrExplicitly(candidate2, this.context)) {
            return null;
        }
        IrDeclarationWithName irDeclarationWithName2 = candidate2;
        if (irDeclarationWithName2 instanceof IrSimpleFunction) {
            exportedDeclaration = this.exportFunction((IrSimpleFunction)candidate2);
        } else if (irDeclarationWithName2 instanceof IrProperty) {
            exportedDeclaration = this.exportProperty((IrProperty)candidate2);
        } else if (irDeclarationWithName2 instanceof IrClass) {
            exportedDeclaration = this.exportClass((IrClass)candidate2);
        } else if (irDeclarationWithName2 instanceof IrField) {
            exportedDeclaration = null;
        } else {
            throw new IllegalStateException(("Can't export declaration " + candidate2).toString());
        }
        return exportedDeclaration;
    }

    private final ExportedDeclaration exportClass(IrClass candidate2) {
        Set superTypes2 = SetsKt.plus(this.collectSuperTransitiveHierarchy(IrUtilsKt.getDefaultType((IrClass)candidate2)), (Iterable)candidate2.getSuperTypes());
        return IrUtilsKt.isEnumClass((IrClass)candidate2) ? this.exportEnumClass(candidate2, superTypes2) : this.exportOrdinaryClass(candidate2, superTypes2);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportFunction(IrSimpleFunction function2) {
        ExportedDeclaration exportedDeclaration;
        Exportability exportability = this.functionExportability(function2);
        if (exportability instanceof Exportability.NotNeeded ? true : exportability instanceof Exportability.Implicit) {
            exportedDeclaration = null;
        } else if (exportability instanceof Exportability.Prohibited) {
            exportedDeclaration = new ErrorDeclaration(((Exportability.Prohibited)exportability).getReason());
        } else if (exportability instanceof Exportability.Allowed) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            IrValueParameter it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void p0;
            Collection collection;
            void $this$mapTo$iv$iv2;
            IrDeclarationParent parent2 = function2.getParent();
            String string2 = this.getExportedIdentifier((IrDeclarationWithName)function2);
            ExportedType exportedType = ExportModelGenerator.exportType$default(this, function2.getReturnType(), false, 2, null);
            Iterable $this$map$iv2 = function2.getTypeParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.exportTypeParameter((IrTypeParameter)p0));
            }
            List list2 = (List)destination$iv$iv;
            boolean bl = parent2 instanceof IrClass;
            boolean bl2 = ExportModelGeneratorKt.access$isStaticMethod((IrFunction)function2);
            boolean bl3 = parent2 instanceof IrClass && !IrUtilsKt.isInterface((IrClass)((IrClass)parent2)) && function2.getModality() == Modality.ABSTRACT;
            boolean bl4 = Intrinsics.areEqual((Object)function2.getVisibility(), (Object)DescriptorVisibilities.PROTECTED);
            Iterable iterable2 = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)function2.getExtensionReceiverParameter()), (Iterable)function2.getValueParameters());
            boolean $i$f$filter = false;
            p0 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (IrValueParameter)element$iv$iv;
                boolean bl5 = false;
                if (!this.shouldBeExported(it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl6 = false;
                collection.add(this.exportParameter(it));
            }
            List list3 = (List)destination$iv$iv2;
            exportedDeclaration = new ExportedFunction(string2, exportedType, list3, list2, bl, bl2, bl3, bl4, function2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return exportedDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportConstructor(IrConstructor constructor) {
        void $this$mapTo$iv$iv;
        IrValueParameter it;
        Iterable $this$filterNotTo$iv$iv;
        if (!constructor.isPrimary()) {
            return null;
        }
        List allValueParameters = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)constructor.getExtensionReceiverParameter()), (Iterable)constructor.getValueParameters());
        Iterable $this$filterNot$iv = allValueParameters;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (IrValueParameter)element$iv$iv;
            boolean bl = false;
            if (ES6AddBoxParameterLoweringKt.isBoxParameter(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.exportParameter(it));
        }
        ExportedVisibility exportedVisibility = ExportModelGeneratorKt.access$toExportedVisibility(constructor.getVisibility());
        List list2 = (List)destination$iv$iv;
        return new ExportedConstructor(list2, exportedVisibility);
    }

    private final ExportedParameter exportParameter(IrValueParameter parameter) {
        String string2 = parameter.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parameter.name.asString()");
        String parameterName = NameTablesKt.sanitizeName(string2, false);
        if (ExportModelGeneratorKt.access$getAllReservedWords$p().contains(parameterName)) {
            parameterName = '_' + parameterName;
        }
        return new ExportedParameter(parameterName, ExportModelGenerator.exportType$default(this, parameter.getType(), false, 2, null), Intrinsics.areEqual((Object)parameter.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.JS_SHADOWED_DEFAULT_PARAMETER.INSTANCE)));
    }

    private final ExportedDeclaration exportProperty(IrProperty property) {
        Object[] objectArray = new IrSimpleFunction[]{property.getGetter(), property.getSetter()};
        for (IrSimpleFunction accessor : CollectionsKt.listOfNotNull((Object[])objectArray)) {
            if (accessor.getExtensionReceiverParameter() != null) {
                return null;
            }
            if (!accessor.isFakeOverride() || ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration((IrOverridableDeclaration)accessor, this.context)) continue;
            return null;
        }
        return ExportModelGenerator.exportPropertyUnsafely$default(this, property, null, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final ExportedDeclaration exportPropertyUnsafely(IrProperty property, ExportedType specializeType) {
        var4_3 = property.getParent();
        v0 = parentClass = var4_3 instanceof IrClass != false ? (IrClass)var4_3 : null;
        if (!IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)((IrPossiblyExternalDeclaration)property)) || !(property.getParent() instanceof IrClass)) ** GOTO lbl-1000
        v1 = property.getGetter();
        v2 = v1 != null && (v1 = v1.getReturnType()) != null ? org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable((IrType)v1) : false;
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        isOptional = v3;
        var5_6 = this.getExportedIdentifier((IrDeclarationWithName)property);
        v4 = specializeType;
        if (v4 == null) {
            v5 = property.getGetter();
            Intrinsics.checkNotNull((Object)v5);
            v4 = ExportModelGenerator.exportType$default(this, v5.getReturnType(), false, 2, null);
        }
        var6_7 = v4;
        var7_8 = property.isVar();
        var8_9 = parentClass != null;
        v6 = parentClass;
        var9_10 = (v6 != null ? !IrUtilsKt.isInterface((IrClass)v6) : false) != false && property.getModality() == Modality.ABSTRACT;
        var10_11 = Intrinsics.areEqual((Object)property.getVisibility(), (Object)DescriptorVisibilities.PROTECTED);
        v7 = parentClass;
        var11_12 = v7 != null ? IrUtilsKt.isInterface((IrClass)v7) : false;
        var12_13 = property.getGetter();
        var13_14 = property.getSetter();
        v8 = property.getGetter();
        if (v8 == null) {
            v8 = property.getSetter();
        }
        var14_15 = v8 != null ? IrDeclarationsKt.isStaticMethodOfClass((IrFunction)((IrFunction)v8)) : false;
        return new ExportedProperty(var5_6, var6_7, var7_8, var8_9, var14_15, var9_10, var10_11, var11_12, (IrFunction)var12_13, (IrFunction)var13_14, isOptional);
    }

    static /* synthetic */ ExportedDeclaration exportPropertyUnsafely$default(ExportModelGenerator exportModelGenerator, IrProperty irProperty, ExportedType exportedType, int n, Object object) {
        if ((n & 2) != 0) {
            exportedType = null;
        }
        return exportModelGenerator.exportPropertyUnsafely(irProperty, exportedType);
    }

    private final ExportedProperty exportEnumEntry(IrField field, Map<IrEnumEntry, Integer> enumEntries2) {
        IrEnumEntry irEnumEntry = (IrEnumEntry)this.context.getMapping().getFieldToEnumEntry().get((IrDeclaration)field);
        if (irEnumEntry == null) {
            throw new IllegalStateException(("Unable to find enum entry for " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)field))).toString());
        }
        IrEnumEntry irEnumEntry2 = irEnumEntry;
        IrDeclarationParent irDeclarationParent = field.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass parentClass = (IrClass)irDeclarationParent;
        String name = this.getExportedIdentifier((IrDeclarationWithName)irEnumEntry2);
        int ordinal = ((Number)MapsKt.getValue(enumEntries2, (Object)irEnumEntry2)).intValue();
        ExportedProperty nameProperty = ExportModelGenerator.exportEnumEntry$fakeProperty("name", new ExportedType.LiteralType.StringLiteralType(name));
        ExportedProperty ordinalProperty = ExportModelGenerator.exportEnumEntry$fakeProperty("ordinal", new ExportedType.LiteralType.NumberLiteralType(ordinal));
        Object[] objectArray = new ExportedProperty[]{nameProperty, ordinalProperty};
        ExportedType.InlineInterfaceType type2 = new ExportedType.InlineInterfaceType(CollectionsKt.listOf((Object[])objectArray));
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)this.context.getMapping().getEnumEntryToGetInstanceFun().get((IrDeclaration)irEnumEntry2);
        if (irSimpleFunction == null) {
            throw new IllegalStateException(("Unable to find get instance fun for " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)field))).toString());
        }
        return new ExportedProperty(name, new ExportedType.IntersectionType(ExportModelGenerator.exportType$default(this, (IrType)IrUtilsKt.getDefaultType((IrClass)parentClass), false, 2, null), type2), false, true, true, false, Intrinsics.areEqual((Object)parentClass.getVisibility(), (Object)DescriptorVisibilities.PROTECTED), false, (IrFunction)irSimpleFunction, null, false, 1696, null);
    }

    private final Exportability classExportability(IrClass klass) {
        switch (WhenMappings.$EnumSwitchMapping$0[klass.getKind().ordinal()]) {
            case 1: {
                return new Exportability.Prohibited("Class " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass)) + " with kind: " + klass.getKind());
            }
        }
        if (AnnotationUtilsKt.isJsImplicitExport((IrAnnotationContainer)klass)) {
            return Exportability.Implicit.INSTANCE;
        }
        if (IrDeclarationsKt.isSingleFieldValueClass((IrClass)klass)) {
            return new Exportability.Prohibited("Inline class " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass)));
        }
        return Exportability.Allowed.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportDeclarationImplicitly(IrClass klass, Iterable<? extends IrType> superTypes2) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2 = klass.getTypeParameters();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.exportTypeParameter((IrTypeParameter)p0));
        }
        List typeParameters2 = (List)destination$iv$iv;
        Iterable<? extends IrType> $i$f$map22 = superTypes2;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrType it = (IrType)element$iv$iv;
            boolean bl = false;
            IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail((IrType)it).getOwner();
            IrDeclaration irDeclaration2 = irSymbolOwner instanceof IrDeclaration ? (IrDeclaration)irSymbolOwner : null;
            if (!(irDeclaration2 != null ? ExportModelGeneratorKt.isExportedImplicitlyOrExplicitly(irDeclaration2, this.context) : false)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrType it = (IrType)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(ExportModelGenerator.exportType$default(this, it, false, 2, null));
        }
        $this$map$iv = (List)destination$iv$iv2;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ExportedType it = (ExportedType)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof ExportedType.ErrorType))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List superInterfaces = (List)destination$iv$iv2;
        String name = this.getExportedIdentifier((IrDeclarationWithName)klass);
        ExportedClassDeclarationsInfo exportedClassDeclarationsInfo = ExportModelGenerator.exportClassDeclarations$default(this, klass, superTypes2, null, 4, null);
        List<ExportedDeclaration> members = exportedClassDeclarationsInfo.component1();
        List<ExportedClass> nestedClasses2 = exportedClassDeclarationsInfo.component2();
        return new ExportedRegularClass(name, true, false, CollectionsKt.emptyList(), superInterfaces, typeParameters2, members, nestedClasses2, klass);
    }

    private final ExportedDeclaration exportOrdinaryClass(IrClass klass, Iterable<? extends IrType> superTypes2) {
        Exportability exportability = this.classExportability(klass);
        if (exportability instanceof Exportability.Prohibited) {
            throw new IllegalStateException(((Exportability.Prohibited)exportability).getReason().toString());
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.NotNeeded.INSTANCE)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.Implicit.INSTANCE)) {
            return this.exportDeclarationImplicitly(klass, superTypes2);
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.Allowed.INSTANCE)) {
            // empty if block
        }
        ExportedClassDeclarationsInfo exportedClassDeclarationsInfo = ExportModelGenerator.exportClassDeclarations$default(this, klass, superTypes2, null, 4, null);
        List<ExportedDeclaration> members = exportedClassDeclarationsInfo.component1();
        List<ExportedClass> nestedClasses2 = exportedClassDeclarationsInfo.component2();
        return this.exportClass(klass, superTypes2, members, nestedClasses2);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportEnumClass(IrClass klass, Iterable<? extends IrType> superTypes2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Exportability exportability = this.classExportability(klass);
        if (exportability instanceof Exportability.Prohibited) {
            throw new IllegalStateException(((Exportability.Prohibited)exportability).getReason().toString());
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.NotNeeded.INSTANCE)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.Implicit.INSTANCE)) {
            return this.exportDeclarationImplicitly(klass, superTypes2);
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.Allowed.INSTANCE)) {
            // empty if block
        }
        Iterable iterable = klass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        void var6_7 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrEnumEntry it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrField it = (IrField)element$iv$iv;
            boolean bl2 = false;
            if ((IrEnumEntry)this.context.getMapping().getFieldToEnumEntry().get((IrDeclaration)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List enumEntries2 = (List)destination$iv$iv;
        Map enumEntriesToOrdinal2 = org.jetbrains.kotlin.utils.CollectionsKt.keysToMap((Iterable)enumEntries2, (Function1)((Function1)new Function1<IrEnumEntry, Integer>((Object)enumEntries2){

            @NotNull
            public final Integer invoke(@NotNull IrEnumEntry p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((List)this.receiver).indexOf(p0);
            }

            @NotNull
            public final String getSignature() {
                return "indexOf(Ljava/lang/Object;)I";
            }

            @NotNull
            public final String getName() {
                return "indexOf";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(List.class);
            }
        }));
        ExportedClassDeclarationsInfo exportedClassDeclarationsInfo = this.exportClassDeclarations(klass, superTypes2, (Function1<? super IrDeclarationWithName, ? extends ExportedDeclaration>)((Function1)new Function1<IrDeclarationWithName, ExportedDeclaration>(this, (Map<IrEnumEntry, Integer>)enumEntriesToOrdinal2){
            final /* synthetic */ ExportModelGenerator this$0;
            final /* synthetic */ Map<IrEnumEntry, Integer> $enumEntriesToOrdinal;
            {
                this.this$0 = $receiver;
                this.$enumEntriesToOrdinal = $enumEntriesToOrdinal;
                super(1);
            }

            @Nullable
            public final ExportedDeclaration invoke(@NotNull IrDeclarationWithName candidate2) {
                Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
                ExportedDeclaration enumExportedMember = ExportModelGenerator.access$exportAsEnumMember(this.this$0, candidate2, this.$enumEntriesToOrdinal);
                return enumExportedMember;
            }
        }));
        List<ExportedDeclaration> members = exportedClassDeclarationsInfo.component1();
        List<ExportedClass> nestedClasses2 = exportedClassDeclarationsInfo.component2();
        ExportedConstructor privateConstructor = new ExportedConstructor(CollectionsKt.emptyList(), ExportedVisibility.PRIVATE);
        return this.exportClass(klass, superTypes2, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)privateConstructor), (Iterable)members), nestedClasses2);
    }

    private final ExportedClassDeclarationsInfo exportClassDeclarations(IrClass klass, Iterable<? extends IrType> superTypes2, Function1<? super IrDeclarationWithName, ? extends ExportedDeclaration> specialProcessing) {
        List members = new ArrayList();
        List nestedClasses2 = new ArrayList();
        boolean isImplicitlyExportedClass = AnnotationUtilsKt.isJsImplicitExport((IrAnnotationContainer)klass);
        for (IrDeclaration declaration : klass.getDeclarations()) {
            IrDeclarationWithName candidate2;
            if (ExportModelGeneratorKt.access$getExportCandidate(declaration) == null || isImplicitlyExportedClass && !(candidate2 instanceof IrClass) || !ExportModelGeneratorKt.access$shouldDeclarationBeExportedImplicitlyOrExplicitly(candidate2, this.context)) continue;
            ExportedDeclaration processingResult = (ExportedDeclaration)specialProcessing.invoke((Object)candidate2);
            if (processingResult != null) {
                members.add(processingResult);
                continue;
            }
            IrDeclarationWithName irDeclarationWithName = candidate2;
            if (irDeclarationWithName instanceof IrSimpleFunction) {
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)members, (Object)this.exportFunction((IrSimpleFunction)candidate2));
                continue;
            }
            if (irDeclarationWithName instanceof IrConstructor) {
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)members, (Object)this.exportConstructor((IrConstructor)candidate2));
                continue;
            }
            if (irDeclarationWithName instanceof IrProperty) {
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)members, (Object)this.exportProperty((IrProperty)candidate2));
                continue;
            }
            if (irDeclarationWithName instanceof IrClass) {
                ExportedDeclaration ec = this.exportClass((IrClass)candidate2);
                if (ec instanceof ExportedClass) {
                    nestedClasses2.add(ec);
                    continue;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)members, (Object)ec);
                continue;
            }
            if (irDeclarationWithName instanceof IrField) {
                boolean bl;
                boolean bl2 = bl = Intrinsics.areEqual((Object)candidate2.getOrigin(), (Object)IrDeclarationOrigin.FIELD_FOR_OBJECT_INSTANCE.INSTANCE) || Intrinsics.areEqual((Object)candidate2.getOrigin(), (Object)IrDeclarationOrigin.FIELD_FOR_OUTER_THIS.INSTANCE) || ((IrField)candidate2).getCorrespondingPropertySymbol() != null;
                if (!_Assertions.ENABLED || bl) continue;
                boolean bl3 = false;
                String string2 = "Unexpected field without property " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)candidate2);
                throw new AssertionError((Object)string2);
            }
            throw new IllegalStateException(("Can't export member declaration " + declaration).toString());
        }
        if (this.shouldContainImplementationOfMagicProperty(klass, superTypes2)) {
            this.addMagicPropertyForInterfaceImplementation(members, klass, superTypes2);
        } else if (this.shouldNotBeImplemented(klass)) {
            this.addMagicInterfaceProperty(members, klass);
        }
        return new ExportedClassDeclarationsInfo(members, nestedClasses2);
    }

    static /* synthetic */ ExportedClassDeclarationsInfo exportClassDeclarations$default(ExportModelGenerator exportModelGenerator, IrClass irClass, Iterable iterable, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = exportClassDeclarations.1.INSTANCE;
        }
        return exportModelGenerator.exportClassDeclarations(irClass, iterable, (Function1<? super IrDeclarationWithName, ? extends ExportedDeclaration>)function1);
    }

    private final boolean shouldNotBeImplemented(IrClass $this$shouldNotBeImplemented) {
        return IrUtilsKt.isInterface((IrClass)$this$shouldNotBeImplemented) && !$this$shouldNotBeImplemented.isExternal() || AnnotationUtilsKt.isJsImplicitExport((IrAnnotationContainer)$this$shouldNotBeImplemented);
    }

    private final boolean shouldBeExported(IrValueParameter $this$shouldBeExported) {
        return !Intrinsics.areEqual((Object)$this$shouldBeExported.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.JS_SUPER_CONTEXT_PARAMETER.INSTANCE));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldContainImplementationOfMagicProperty(IrClass $this$shouldContainImplementationOfMagicProperty, Iterable<? extends IrType> superTypes2) {
        boolean bl;
        if ($this$shouldContainImplementationOfMagicProperty.isExternal()) return false;
        Iterable<? extends IrType> $this$any$iv = superTypes2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator<? extends IrType> iterator2 = $this$any$iv.iterator();
        do {
            IrType element$iv;
            if (!iterator2.hasNext()) return false;
            IrType it = element$iv = iterator2.next();
            boolean bl2 = false;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)it);
            if (irClassSymbol == null || (irClassSymbol = (IrClass)irClassSymbol.getOwner()) == null) {
                bl = false;
                continue;
            }
            IrClassSymbol superClass = irClassSymbol;
            if (IrUtilsKt.isInterface((IrClass)superClass)) {
                if (ExportModelGeneratorKt.isExported((IrDeclaration)superClass, this.context)) return true;
            }
            if (AnnotationUtilsKt.isJsImplicitExport((IrAnnotationContainer)superClass)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final void addMagicInterfaceProperty(List<ExportedDeclaration> $this$addMagicInterfaceProperty, IrClass klass) {
        $this$addMagicInterfaceProperty.add(new ExportedProperty("__doNotUseOrImplementIt", this.generateTagType(klass), false, true, false, false, false, true, null, null, false, 1904, null));
    }

    /*
     * WARNING - void declaration
     */
    private final void addMagicPropertyForInterfaceImplementation(List<ExportedDeclaration> $this$addMagicPropertyForInterfaceImplementation, IrClass klass, Iterable<? extends IrType> superTypes2) {
        void $this$reduce$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable<? extends IrType> $this$filter$iv = superTypes2;
        boolean $i$f$filter22 = false;
        Iterable<? extends IrType> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrType it = (IrType)element$iv$iv;
            boolean bl = false;
            if (!this.shouldAddMagicPropertyOfSuper(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allSuperTypesWithMagicProperty = (List)destination$iv$iv;
        if (allSuperTypesWithMagicProperty.isEmpty()) {
            return;
        }
        Iterable $i$f$filter22 = allSuperTypesWithMagicProperty;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrType bl = (IrType)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new ExportedType.PropertyType(ExportModelGenerator.exportType$default(this, (IrType)it, false, 2, null), new ExportedType.LiteralType.StringLiteralType("__doNotUseOrImplementIt")));
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            ExportedType $i$f$mapTo2 = (ExportedType)iterator$iv.next();
            ExportedType p0 = (ExportedType)accumulator$iv;
            boolean bl = false;
            accumulator$iv = new ExportedType.IntersectionType(p0, (ExportedType)p1);
        }
        ExportedType it = (ExportedType)accumulator$iv;
        boolean bl = false;
        ExportedType intersectionOfTypes = this.shouldNotBeImplemented(klass) ? (ExportedType)new ExportedType.IntersectionType(this.generateTagType(klass), it) : it;
        $this$addMagicPropertyForInterfaceImplementation.add(new ExportedProperty("__doNotUseOrImplementIt", intersectionOfTypes, false, true, false, false, false, true, null, null, false, 1904, null));
    }

    private final boolean shouldAddMagicPropertyOfSuper(IrType $this$shouldAddMagicPropertyOfSuper) {
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)$this$shouldAddMagicPropertyOfSuper);
        return irClassSymbol != null && (irClassSymbol = (IrClass)irClassSymbol.getOwner()) != null ? this.isOwnMagicPropertyAdded((IrClass)irClassSymbol) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isOwnMagicPropertyAdded(IrClass $this$isOwnMagicPropertyAdded) {
        boolean bl;
        if (AnnotationUtilsKt.isJsImplicitExport((IrAnnotationContainer)$this$isOwnMagicPropertyAdded)) {
            return true;
        }
        if (!ExportModelGeneratorKt.isExported((IrDeclaration)$this$isOwnMagicPropertyAdded, this.context)) {
            return false;
        }
        if (IrUtilsKt.isInterface((IrClass)$this$isOwnMagicPropertyAdded)) {
            if (!$this$isOwnMagicPropertyAdded.isExternal()) return true;
        }
        Iterable $this$any$iv = $this$isOwnMagicPropertyAdded.getSuperTypes();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            IrType it = (IrType)element$iv;
            boolean bl2 = false;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)it);
            if (irClassSymbol != null && (irClassSymbol = (IrClass)irClassSymbol.getOwner()) != null) {
                if (this.isOwnMagicPropertyAdded((IrClass)irClassSymbol)) {
                    return true;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final ExportedType generateTagType(IrClass $this$generateTagType) {
        String string2 = IrJsUtilsKt.getFqNameWithJsNameWhenAvailable((IrDeclarationWithName)$this$generateTagType, true).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFqNameWithJsNameWhenAvailable(true).asString()");
        return new ExportedType.InlineInterfaceType(CollectionsKt.listOf((Object)new ExportedProperty(string2, ExportedType.Primitive.UniqueSymbol.INSTANCE, false, true, false, false, false, true, null, null, false, 1904, null)));
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportClass(IrClass klass, Iterable<? extends IrType> superTypes2, List<? extends ExportedDeclaration> members, List<? extends ExportedClass> nestedClasses2) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv2;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Iterable $this$map$iv3 = klass.getTypeParameters();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void p0;
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.exportTypeParameter((IrTypeParameter)p0));
        }
        List typeParameters2 = (List)destination$iv$iv;
        Iterable<? extends IrType> $i$f$map22 = superTypes2;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            IrType it = (IrType)element$iv$iv;
            boolean bl = false;
            if (!(!ExportModelGeneratorKt.access$isInterface(IrTypesKt.getClassifierOrFail((IrType)it)) && this.canBeUsedAsSuperTypeOfExportedClasses(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            IrType it = (IrType)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(this.exportType(it, false));
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ExportedType it = (ExportedType)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof ExportedType.ErrorType))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List superClasses2 = (List)destination$iv$iv2;
        Iterable<? extends IrType> $i$f$filter2 = superTypes2;
        boolean $i$f$filter3 = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrType it = (IrType)element$iv$iv;
            boolean bl = false;
            if (!this.shouldPresentInsideImplementsClause(it)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        boolean $i$f$map3 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrType it = (IrType)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(this.exportType(it, false));
        }
        $this$map$iv = (List)destination$iv$iv3;
        $i$f$filter3 = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ExportedType it = (ExportedType)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof ExportedType.ErrorType))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List superInterfaces = (List)destination$iv$iv3;
        String name = this.getExportedIdentifier((IrDeclarationWithName)klass);
        if (klass.getKind() == ClassKind.OBJECT) {
            Object object = this.context.getMapping().getObjectToGetInstanceFunction().get((IrDeclaration)klass);
            Intrinsics.checkNotNull((Object)object);
            IrSimpleFunction irSimpleFunction = (IrSimpleFunction)object;
            return new ExportedObject(name, superClasses2, superInterfaces, members, nestedClasses2, klass, irSimpleFunction);
        }
        return new ExportedRegularClass(name, IrUtilsKt.isInterface((IrClass)klass), klass.getModality() == Modality.ABSTRACT || klass.getModality() == Modality.SEALED || IrUtilsKt.isEnumClass((IrClass)klass), superClasses2, superInterfaces, typeParameters2, members, nestedClasses2, klass);
    }

    private final Set<IrType> collectSuperTransitiveHierarchy(IrSimpleType $this$collectSuperTransitiveHierarchy) {
        return this.transitiveExportCollector.collectSuperTypesTransitiveHierarchyFor($this$collectSuperTransitiveHierarchy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldPresentInsideImplementsClause(IrType $this$shouldPresentInsideImplementsClause) {
        IrClassifierSymbol classifier = IrTypesKt.getClassifierOrFail((IrType)$this$shouldPresentInsideImplementsClause);
        if (ExportModelGeneratorKt.access$isInterface(classifier)) return true;
        IrSymbolOwner irSymbolOwner = classifier.getOwner();
        if (!(irSymbolOwner instanceof IrDeclaration)) return false;
        IrDeclaration irDeclaration2 = (IrDeclaration)irSymbolOwner;
        if (irDeclaration2 == null) return false;
        if (!AnnotationUtilsKt.isJsImplicitExport((IrAnnotationContainer)irDeclaration2)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportAsEnumMember(IrDeclarationWithName candidate2, Map<IrEnumEntry, Integer> enumEntriesToOrdinal2) {
        ExportedDeclaration exportedDeclaration;
        Set<IrEnumEntry> enumEntries2 = enumEntriesToOrdinal2.keySet();
        IrDeclarationWithName irDeclarationWithName = candidate2;
        if (irDeclarationWithName instanceof IrProperty) {
            if (ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration((IrOverridableDeclaration)candidate2, this.context)) {
                ExportedType exportedType;
                Object acc;
                Object accumulator$iv;
                Iterator iterator$iv;
                Map<IrEnumEntry, Integer> $this$reduce$iv;
                boolean $i$f$reduce;
                Collection collection;
                Object object;
                Iterable $this$mapTo$iv$iv;
                Collection destination$iv$iv;
                Iterable $this$map$iv;
                boolean $i$f$map;
                String string2 = this.getExportedIdentifier(candidate2);
                if (Intrinsics.areEqual((Object)string2, (Object)"name")) {
                    String it;
                    Iterable iterable = enumEntries2;
                    $i$f$map = false;
                    void var9_8 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        object = (IrEnumEntry)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(this.getExportedIdentifier((IrDeclarationWithName)it));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new ExportedType.LiteralType.StringLiteralType(it));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$reduce = false;
                    iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void s;
                        ExportedType $i$f$mapTo2 = (ExportedType)iterator$iv.next();
                        acc = (ExportedType)accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = new ExportedType.UnionType((ExportedType)acc, (ExportedType)s);
                    }
                    exportedType = (ExportedType)accumulator$iv;
                } else if (Intrinsics.areEqual((Object)string2, (Object)"ordinal")) {
                    $this$reduce$iv = enumEntriesToOrdinal2;
                    $i$f$map = false;
                    iterator$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList($this$map$iv.size());
                    boolean $i$f$mapTo3 = false;
                    for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                        object = item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        int ordinal = ((Number)object.getValue()).intValue();
                        collection.add(new ExportedType.LiteralType.NumberLiteralType(ordinal));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$reduce = false;
                    iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void s;
                        ExportedType $i$f$mapTo3 = (ExportedType)iterator$iv.next();
                        acc = (ExportedType)accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = new ExportedType.UnionType((ExportedType)acc, (ExportedType)s);
                    }
                    exportedType = (ExportedType)accumulator$iv;
                } else {
                    exportedType = null;
                }
                ExportedType type2 = exportedType;
                exportedDeclaration = this.exportPropertyUnsafely((IrProperty)candidate2, type2);
            } else {
                exportedDeclaration = null;
            }
        } else {
            exportedDeclaration = irDeclarationWithName instanceof IrField ? (ExportedDeclaration)(Intrinsics.areEqual((Object)candidate2.getOrigin(), (Object)IrDeclarationOrigin.FIELD_FOR_ENUM_ENTRY.INSTANCE) ? this.exportEnumEntry((IrField)candidate2, enumEntriesToOrdinal2) : null) : null;
        }
        return exportedDeclaration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canBeUsedAsSuperTypeOfExportedClasses(IrType $this$canBeUsedAsSuperTypeOfExportedClasses) {
        if (IrTypePredicatesKt.isAny((IrType)$this$canBeUsedAsSuperTypeOfExportedClasses)) return false;
        if (Intrinsics.areEqual((Object)IrTypesKt.getClassifierOrNull((IrType)$this$canBeUsedAsSuperTypeOfExportedClasses), (Object)this.context.getIrBuiltIns().getEnumClass())) return false;
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull((IrType)$this$canBeUsedAsSuperTypeOfExportedClasses);
        IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
        if (!(irSymbolOwner instanceof IrDeclaration)) return true;
        IrDeclaration irDeclaration2 = (IrDeclaration)irSymbolOwner;
        if (irDeclaration2 == null) return true;
        if (!AnnotationUtilsKt.isJsImplicitExport((IrAnnotationContainer)irDeclaration2)) return true;
        return false;
    }

    private final ExportedType exportTypeArgument(IrTypeArgument type2) {
        if (type2 instanceof IrTypeProjection) {
            return ExportModelGenerator.exportType$default(this, ((IrTypeProjection)type2).getType(), false, 2, null);
        }
        if (type2 instanceof IrType) {
            return ExportModelGenerator.exportType$default(this, (IrType)type2, false, 2, null);
        }
        return new ExportedType.ErrorType("UnknownType " + RenderIrElementKt.render((IrTypeArgument)type2));
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedType.TypeParameter exportTypeParameter(IrTypeParameter typeParameter) {
        ExportedType exportedType;
        void $this$exportTypeParameter_u24lambda_u2432;
        List constraint2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)typeParameter.getSuperTypes()), (Function1)((Function1)new Function1<IrType, Boolean>(this){
            final /* synthetic */ ExportModelGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IrType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !Intrinsics.areEqual((Object)it, (Object)this.this$0.getContext().getIrBuiltIns().getAnyNType());
            }
        })), (Function1)((Function1)new Function1<IrType, ExportedType>(this){
            final /* synthetic */ ExportModelGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ExportedType invoke(@NotNull IrType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ExportedType exportedType = ExportModelGenerator.exportType$default(this.this$0, it, false, 2, null);
                return exportedType instanceof ExportedType.ImplicitlyExportedType && Intrinsics.areEqual((Object)((ExportedType.ImplicitlyExportedType)exportedType).getExportedSupertype(), (Object)ExportedType.Primitive.Any.INSTANCE) ? (ExportedType)ExportedType.ImplicitlyExportedType.copy$default((ExportedType.ImplicitlyExportedType)exportedType, null, ExportedType.Primitive.Unknown.INSTANCE, 1, null) : exportedType;
            }
        })), (Function1)exportTypeParameter.constraint.3.INSTANCE));
        String string2 = typeParameter.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"typeParameter.name.identifier");
        List list2 = constraint2;
        String string3 = string2;
        boolean bl = false;
        switch ($this$exportTypeParameter_u24lambda_u2432.size()) {
            case 0: {
                exportedType = null;
                break;
            }
            case 1: {
                exportedType = (ExportedType)CollectionsKt.single((List)$this$exportTypeParameter_u24lambda_u2432);
                break;
            }
            default: {
                Iterable $this$reduce$iv = (Iterable)$this$exportTypeParameter_u24lambda_u2432;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void p1;
                    ExportedType exportedType2 = (ExportedType)iterator$iv.next();
                    ExportedType p0 = (ExportedType)accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = new ExportedType.IntersectionType(p0, (ExportedType)p1);
                }
                exportedType = (ExportedType)accumulator$iv;
            }
        }
        ExportedType exportedType3 = exportedType;
        String string4 = string3;
        return new ExportedType.TypeParameter(string4, exportedType3);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedType exportType(IrType type2, boolean shouldCalculateExportedSupertypeForImplicit) {
        Object object;
        ExportedType exportedType;
        if (type2 instanceof IrDynamicType) {
            return ExportedType.Primitive.Any.INSTANCE;
        }
        if (!(type2 instanceof IrSimpleType)) {
            return new ExportedType.ErrorType("NonSimpleType " + RenderIrElementKt.render((IrType)type2));
        }
        IrClassifierSymbol classifier = ((IrSimpleType)type2).getClassifier();
        boolean isMarkedNullable = IrTypePredicatesKt.isMarkedNullable((IrSimpleType)((IrSimpleType)type2));
        IrType irType = IrTypesKt.makeNotNull((IrType)type2);
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrSimpleType nonNullType = (IrSimpleType)irType;
        if (IrTypePredicatesKt.isBoolean((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.Boolean.INSTANCE;
        } else if (IrTypePredicatesKt.isPrimitiveType$default((IrType)((IrType)nonNullType), (boolean)false, (int)1, null) && !IrTypePredicatesKt.isLong((IrType)((IrType)nonNullType)) && !IrTypePredicatesKt.isChar((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.Number.INSTANCE;
        } else if (IrTypePredicatesKt.isByteArray((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.ByteArray.INSTANCE;
        } else if (IrTypePredicatesKt.isShortArray((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.ShortArray.INSTANCE;
        } else if (IrTypePredicatesKt.isIntArray((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.IntArray.INSTANCE;
        } else if (IrTypePredicatesKt.isFloatArray((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.FloatArray.INSTANCE;
        } else if (IrTypePredicatesKt.isDoubleArray((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.DoubleArray.INSTANCE;
        } else if (IrTypePredicatesKt.isBooleanArray((IrType)((IrType)nonNullType))) {
            exportedType = new ExportedType.ErrorType("BooleanArray");
        } else if (IrTypePredicatesKt.isLongArray((IrType)((IrType)nonNullType))) {
            exportedType = new ExportedType.ErrorType("LongArray");
        } else if (IrTypePredicatesKt.isCharArray((IrType)((IrType)nonNullType))) {
            exportedType = new ExportedType.ErrorType("CharArray");
        } else if (IrTypePredicatesKt.isString((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.String.INSTANCE;
        } else if (IrTypeUtilsKt.isThrowable((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.Throwable.INSTANCE;
        } else if (IrTypePredicatesKt.isAny((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.Any.INSTANCE;
        } else if (IrTypePredicatesKt.isUnit((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.Unit.INSTANCE;
        } else if (IrTypePredicatesKt.isNothing((IrType)((IrType)nonNullType))) {
            exportedType = ExportedType.Primitive.Nothing.INSTANCE;
        } else if (IrTypePredicatesKt.isArray((IrType)((IrType)nonNullType))) {
            exportedType = new ExportedType.Array(this.exportTypeArgument((IrTypeArgument)nonNullType.getArguments().get(0)));
        } else if (IrTypeUtilsKt.isSuspendFunction((IrType)((IrType)nonNullType))) {
            exportedType = new ExportedType.ErrorType("Suspend functions are not supported");
        } else if (IrTypeUtilsKt.isFunction((IrType)((IrType)nonNullType))) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.dropLast((List)nonNullType.getArguments(), (int)1);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(this.exportTypeArgument((IrTypeArgument)it));
            }
            ExportedType exportedType2 = this.exportTypeArgument((IrTypeArgument)CollectionsKt.last((List)nonNullType.getArguments()));
            List list2 = (List)destination$iv$iv;
            exportedType = new ExportedType.Function(list2, exportedType2);
        } else if (classifier instanceof IrTypeParameterSymbol) {
            String string2 = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classifier.owner.name.identifier");
            exportedType = new ExportedType.TypeParameter(string2, null, 2, null);
        } else if (classifier instanceof IrClassSymbol) {
            ExportedType exportedType3;
            ExportedType exportedType4;
            ExportedType exportedType5;
            Set<IrType> transitiveExportedType;
            IrClass klass = (IrClass)((IrClassSymbol)classifier).getOwner();
            boolean isExported = ExportModelGeneratorKt.isExportedImplicitlyOrExplicitly((IrDeclaration)klass, this.context);
            boolean isImplicitlyExported = !isExported && !klass.isExternal();
            boolean isNonExportedExternal = klass.isExternal() && !isExported;
            String string3 = IrJsUtilsKt.getFqNameWithJsNameWhenAvailable((IrDeclarationWithName)klass, !isNonExportedExternal && this.generateNamespacesForPackages).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"klass.getFqNameWithJsNam\u2026esForPackages).asString()");
            String name = string3;
            boolean condition$iv = shouldCalculateExportedSupertypeForImplicit && isImplicitlyExported;
            boolean $i$f$runIf2 = false;
            if (condition$iv) {
                boolean bl = false;
                transitiveExportedType = this.collectSuperTransitiveHierarchy(nonNullType);
                if (transitiveExportedType.isEmpty()) {
                    exportedType5 = null;
                } else {
                    void $this$reduce$iv;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = transitiveExportedType;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        IrType irType2 = (IrType)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(ExportModelGenerator.exportType$default(this, (IrType)p0, false, 2, null));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$reduce = false;
                    Iterator iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    Object accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void p1;
                        ExportedType $i$f$mapTo2 = (ExportedType)iterator$iv.next();
                        ExportedType p0 = (ExportedType)accumulator$iv;
                        boolean bl3 = false;
                        accumulator$iv = new ExportedType.IntersectionType(p0, (ExportedType)p1);
                    }
                    exportedType5 = (ExportedType)accumulator$iv;
                }
            } else {
                exportedType5 = exportedType4 = null;
            }
            if (exportedType5 == null) {
                exportedType4 = ExportedType.Primitive.Any.INSTANCE;
            }
            ExportedType exportedSupertype = exportedType4;
            switch (WhenMappings.$EnumSwitchMapping$0[klass.getKind().ordinal()]) {
                case 1: 
                case 6: {
                    exportedType3 = new ExportedType.ErrorType("Class " + name + " with kind: " + klass.getKind());
                    break;
                }
                case 2: {
                    exportedType3 = new ExportedType.TypeOf(name);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable $i$f$runIf2 = ((IrSimpleType)type2).getArguments();
                    object = name;
                    boolean $i$f$map = false;
                    transitiveExportedType = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        IrTypeArgument p1 = (IrTypeArgument)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(this.exportTypeArgument((IrTypeArgument)it));
                    }
                    IrClass irClass = klass;
                    List list3 = (List)destination$iv$iv;
                    Object object2 = object;
                    exportedType3 = new ExportedType.ClassType((String)object2, list3, irClass);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            exportedType = exportedType3.withImplicitlyExported(isImplicitlyExported, exportedSupertype);
        } else {
            throw new IllegalStateException(("Unexpected classifier " + classifier).toString());
        }
        ExportedType exportedType6 = exportedType;
        return exportedType6.withNullability(isMarkedNullable);
    }

    static /* synthetic */ ExportedType exportType$default(ExportModelGenerator exportModelGenerator, IrType irType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return exportModelGenerator.exportType(irType, bl);
    }

    private final String getExportedIdentifier(IrDeclarationWithName $this$getExportedIdentifier) {
        Name $this$getExportedIdentifier_u24lambda_u2437 = AnnotationUtilsKt.getJsNameOrKotlinName($this$getExportedIdentifier);
        boolean bl = false;
        if ($this$getExportedIdentifier_u24lambda_u2437.isSpecial()) {
            throw new IllegalStateException(("Cannot export special name: " + $this$getExportedIdentifier.getName().asString() + " for declaration " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)$this$getExportedIdentifier)).toString());
        }
        String string2 = $this$getExportedIdentifier_u24lambda_u2437.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"with(getJsNameOrKotlinNa\u2026else identifier\n        }");
        return string2;
    }

    private final Exportability functionExportability(IrSimpleFunction function2) {
        IrClass parentClass;
        if (function2.isInline()) {
            boolean bl;
            block16: {
                Iterable $this$any$iv = function2.getTypeParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrTypeParameter it = (IrTypeParameter)element$iv;
                        boolean bl2 = false;
                        if (!it.isReified()) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return new Exportability.Prohibited("Inline reified function");
            }
        }
        if (function2.isSuspend()) {
            return new Exportability.Prohibited("Suspend function");
        }
        if (function2.isFakeOverride() && !ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration((IrOverridableDeclaration)function2, this.context)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)function2.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.BRIDGE_WITHOUT_STABLE_NAME.INSTANCE)) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.BRIDGE_PROPERTY_ACCESSOR.INSTANCE)) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.BRIDGE_WITH_STABLE_NAME.INSTANCE)) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.OBJECT_GET_INSTANCE_FUNCTION.INSTANCE)) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.JS_SHADOWED_EXPORT.INSTANCE)) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.ENUM_GET_INSTANCE_FUNCTION.INSTANCE))) {
            return Exportability.NotNeeded.INSTANCE;
        }
        IrDeclarationParent $i$f$any = function2.getParent();
        IrClass irClass = parentClass = $i$f$any instanceof IrClass ? (IrClass)$i$f$any : null;
        if (parentClass != null && Intrinsics.areEqual((Object)this.context.getMapping().getEnumClassToInitEntryInstancesFun().get((IrDeclaration)parentClass), (Object)function2)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        String string2 = function2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"function.name.asString()");
        String nameString = string2;
        if (StringsKt.endsWith$default((String)nameString, (String)"-impl", (boolean)false, (int)2, null)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (StringsKt.endsWith$default((String)nameString, (String)"$", (boolean)false, (int)2, null)) {
            boolean bl;
            block17: {
                Iterable $this$any$iv = function2.getValueParameters();
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl3 = false;
                        String string3 = it.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name.asString()");
                        if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"$mask", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return Exportability.NotNeeded.INSTANCE;
            }
        }
        String name = this.getExportedIdentifier((IrDeclarationWithName)function2);
        if (parentClass == null && ExportModelGeneratorKt.access$getAllReservedWords$p().contains(name)) {
            return new Exportability.Prohibited("Name is a reserved word");
        }
        return Exportability.Allowed.INSTANCE;
    }

    private static final ExportedProperty exportEnumEntry$fakeProperty(String name, ExportedType type2) {
        return new ExportedProperty(name, type2, false, true, false, false, false, false, null, null, false, 2032, null);
    }

    public static final /* synthetic */ ExportedDeclaration access$exportAsEnumMember(ExportModelGenerator $this, IrDeclarationWithName candidate2, Map enumEntriesToOrdinal2) {
        return $this.exportAsEnumMember(candidate2, enumEntriesToOrdinal2);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

