/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataIntegerArray;", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataElement;", "name", "", "value", "", "", "integerSize", "", "(Ljava/lang/String;Ljava/util/List;I)V", "getName", "()Ljava/lang/String;", "sizeInBytes", "getSizeInBytes", "()I", "getValue", "()Ljava/util/List;", "dump", "indent", "startAddress", "toBytes", "", "backend.wasm"})
public final class ConstantDataIntegerArray
extends ConstantDataElement {
    @NotNull
    private final String name;
    @NotNull
    private final List<Long> value;
    private final int integerSize;
    private final int sizeInBytes;

    public ConstantDataIntegerArray(@NotNull String name, @NotNull List<Long> value2, int integerSize) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        super(null);
        this.name = name;
        this.value = value2;
        this.integerSize = integerSize;
        this.sizeInBytes = this.value.size() * this.integerSize;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<Long> getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public byte[] toBytes() {
        byte[] array = new byte[this.value.size() * this.integerSize];
        int n = this.value.size();
        int n2 = 0;
        while (n2 < n) {
            int i = n2++;
            boolean bl = false;
            ConstantDataKt.toLittleEndianBytesTo(((Number)this.value.get(i)).longValue(), array, i * this.integerSize, this.integerSize);
        }
        return array;
    }

    @Override
    @NotNull
    public String dump(@NotNull String indent, int startAddress) {
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        if (this.value.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder2 = new StringBuilder().append(ConstantDataKt.access$addressToString(startAddress)).append(": ").append(indent).append(" i").append(this.integerSize * 8).append("[] : ");
        String string2 = Arrays.toString(this.toBytes());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this)");
        return stringBuilder2.append(string2).append("   ;; ").append(this.name).append('\n').toString();
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }
}

