/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.Comment;
import com.google.gwt.dev.js.rhino.Context;
import com.google.gwt.dev.js.rhino.IRFactory;
import com.google.gwt.dev.js.rhino.JavaScriptException;
import com.google.gwt.dev.js.rhino.Node;
import com.google.gwt.dev.js.rhino.ParserListener;
import com.google.gwt.dev.js.rhino.TokenStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Parser {
    private List<ParserListener> listeners;
    private int lastExprEndLine;
    private final IRFactory nf;
    private boolean ok;
    private int sourceTop;
    private int functionNumber;
    private final boolean insideFunction;

    public Parser(IRFactory nf, boolean insideFunction) {
        this.nf = nf;
        this.insideFunction = insideFunction;
    }

    public void addListener(ParserListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ParserListener>();
        }
        this.listeners.add(listener);
    }

    private void mustMatchToken(TokenStream ts, int toMatch, String messageId) throws IOException, JavaScriptException {
        int tt = ts.getToken();
        if (tt != toMatch) {
            this.reportError(ts, messageId);
            ts.ungetToken(tt);
        }
    }

    private void reportError(TokenStream ts, String messageId) throws JavaScriptException {
        this.ok = false;
        ts.reportSyntaxError(messageId, null);
        throw new JavaScriptException((Object)messageId);
    }

    public Node parse(TokenStream ts) throws IOException {
        this.ok = true;
        this.sourceTop = 0;
        this.functionNumber = 0;
        Node tempBlock = this.nf.createLeaf(133, ts.tokenPosition);
        while (true) {
            ts.flags |= 0x10;
            int tt = ts.getToken();
            ts.flags &= 0xFFFFFFEF;
            if (tt <= 0) break;
            if (tt == 110) {
                try {
                    tempBlock.addChildToBack(this.function(ts, false));
                    continue;
                }
                catch (JavaScriptException e) {
                    this.ok = false;
                    break;
                }
            }
            ts.ungetToken(tt);
            tempBlock.addChildToBack(this.statement(ts));
        }
        if (!this.ok) {
            return null;
        }
        return this.nf.createScript(tempBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node parseFunctionBody(TokenStream ts) throws IOException {
        int oldflags = ts.flags;
        ts.flags &= 0xFFFFFFF3;
        ts.flags |= 2;
        Node pn = this.nf.createBlock(ts.tokenPosition);
        try {
            int tt;
            while ((tt = ts.peekToken()) > 0 && tt != 93) {
                if (tt == 110) {
                    ts.getToken();
                    pn.addChildToBack(this.function(ts, false));
                    continue;
                }
                pn.addChildToBack(this.statement(ts));
            }
        }
        catch (JavaScriptException e) {
            this.ok = false;
        }
        finally {
            ts.flags = oldflags;
        }
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node function(TokenStream ts, boolean isExpr) throws IOException, JavaScriptException {
        Node body2;
        Node args;
        Node nameNode;
        if (this.listeners != null) {
            for (ParserListener listener : this.listeners) {
                listener.functionStarted();
            }
        }
        CodePosition basePosition = ts.tokenPosition;
        Node memberExprNode = null;
        if (ts.matchToken(44)) {
            nameNode = this.nf.createName(ts.getString(), basePosition);
            if (!ts.matchToken(94)) {
                if (Context.getContext().hasFeature(2)) {
                    Node memberExprHead = nameNode;
                    nameNode = null;
                    memberExprNode = this.memberExprTail(ts, false, memberExprHead);
                }
                this.mustMatchToken(ts, 94, "msg.no.paren.parms");
            }
        } else if (ts.matchToken(94)) {
            nameNode = null;
        } else {
            if (Context.getContext().hasFeature(2)) {
                memberExprNode = this.memberExpr(ts, false);
            }
            this.mustMatchToken(ts, 94, "msg.no.paren.parms");
            nameNode = null;
        }
        ++this.functionNumber;
        int savedSourceTop = this.sourceTop;
        int savedFunctionNumber = this.functionNumber;
        try {
            this.functionNumber = 0;
            args = this.nf.createLeaf(94, ts.tokenPosition);
            if (!ts.matchToken(95)) {
                do {
                    this.mustMatchToken(ts, 44, "msg.no.parm");
                    String s = ts.getString();
                    args.addChildToBack(this.nf.createName(s, ts.tokenPosition));
                } while (ts.matchToken(96));
                this.mustMatchToken(ts, 95, "msg.no.paren.after.parms");
            }
            this.mustMatchToken(ts, 92, "msg.no.brace.body");
            body2 = this.parseFunctionBody(ts);
            body2.setPosition(ts.tokenPosition);
            this.mustMatchToken(ts, 93, "msg.no.brace.after.body");
        }
        finally {
            this.sourceTop = savedSourceTop;
            this.functionNumber = savedFunctionNumber;
        }
        Node pn = this.nf.createFunction(nameNode, args, body2, basePosition);
        if (memberExprNode != null) {
            pn = this.nf.createBinary(97, 128, memberExprNode, pn, basePosition);
        }
        if (!isExpr) {
            this.wellTerminated(ts, 110);
        }
        if (this.listeners != null) {
            for (ParserListener listener : this.listeners) {
                listener.functionEnded(ts);
            }
        }
        return pn;
    }

    private Node statements(TokenStream ts) throws IOException {
        int tt;
        Node pn = this.nf.createBlock(ts.tokenPosition);
        while ((tt = ts.peekToken()) > 0 && tt != 93) {
            pn.addChildToBack(this.statement(ts));
        }
        return pn;
    }

    private Node condition(TokenStream ts) throws IOException, JavaScriptException {
        this.mustMatchToken(ts, 94, "msg.no.paren.cond");
        Node pn = this.expr(ts, false);
        this.mustMatchToken(ts, 95, "msg.no.paren.after.cond");
        return pn;
    }

    private void wellTerminated(TokenStream ts, int lastExprType) throws IOException, JavaScriptException {
        int tt = ts.peekTokenSameLine();
        if (tt == -1) {
            return;
        }
        if (tt != 0 && tt != 1 && tt != 89 && tt != 93) {
            int version = Context.getContext().getLanguageVersion();
            if (tt != 110 && lastExprType != 110 || version >= 120) {
                this.reportError(ts, "msg.no.semi.stmt");
            }
        }
    }

    private Node matchLabel(TokenStream ts) throws IOException, JavaScriptException {
        CodePosition position = ts.tokenPosition;
        int lineno = ts.getLineno();
        String label = null;
        int tt = ts.peekTokenSameLine();
        if (tt == 44) {
            ts.getToken();
            label = ts.getString();
        }
        if (lineno == ts.getLineno()) {
            this.wellTerminated(ts, -1);
        }
        return label != null ? this.nf.createString(label, position) : null;
    }

    private Node statement(TokenStream ts) throws IOException {
        CodePosition position = ts.lastPosition;
        try {
            Comment commentsBefore = this.getComments(ts);
            ts.collectCommentsAfter();
            Node result2 = this.statementHelper(ts);
            result2.setCommentsBeforeNode(commentsBefore);
            ts.collectCommentsAfter();
            result2.setCommentsAfterNode(this.getComments(ts));
            return result2;
        }
        catch (JavaScriptException e) {
            int t;
            while ((t = ts.getToken()) != 89 && t != 1 && t != 0 && t != -1) {
            }
            return this.nf.createExprStatement(this.nf.createName("error", position), position);
        }
    }

    private Node statementHelper(TokenStream ts) throws IOException, JavaScriptException {
        Node pn;
        int tt = ts.getToken();
        CodePosition position = ts.tokenPosition;
        switch (tt) {
            case 113: {
                Node cond = this.condition(ts);
                Node ifTrue = this.statement(ts);
                Node ifFalse = null;
                if (ts.matchToken(114)) {
                    ifFalse = this.statement(ts);
                }
                pn = this.nf.createIf(cond, ifTrue, ifFalse, position);
                break;
            }
            case 115: {
                pn = this.nf.createSwitch(position);
                Node curCase = null;
                this.mustMatchToken(ts, 94, "msg.no.paren.switch");
                pn.addChildToBack(this.expr(ts, false));
                this.mustMatchToken(ts, 95, "msg.no.paren.after.switch");
                this.mustMatchToken(ts, 92, "msg.no.brace.switch");
                while ((tt = ts.getToken()) != 93 && tt != 0) {
                    switch (tt) {
                        case 116: {
                            curCase = this.nf.createUnary(116, this.expr(ts, false), ts.tokenPosition);
                            break;
                        }
                        case 117: {
                            curCase = this.nf.createLeaf(117, ts.tokenPosition);
                            break;
                        }
                        default: {
                            this.reportError(ts, "msg.bad.switch");
                        }
                    }
                    this.mustMatchToken(ts, 99, "msg.no.colon.case");
                    Node caseStatements = this.nf.createLeaf(133, null);
                    while ((tt = ts.peekToken()) != 93 && tt != 116 && tt != 117 && tt != 0) {
                        caseStatements.addChildToBack(this.statement(ts));
                    }
                    if (curCase != null) {
                        curCase.addChildToBack(caseStatements);
                    }
                    pn.addChildToBack(curCase);
                }
                break;
            }
            case 118: {
                Node cond = this.condition(ts);
                Node body2 = this.statement(ts);
                pn = this.nf.createWhile(cond, body2, position);
                break;
            }
            case 119: {
                Node body3 = this.statement(ts);
                this.mustMatchToken(ts, 118, "msg.no.while.do");
                Node cond = this.condition(ts);
                pn = this.nf.createDoWhile(body3, cond, position);
                break;
            }
            case 120: {
                Node cond;
                Node init;
                Node incr = null;
                this.mustMatchToken(ts, 94, "msg.no.paren.for");
                tt = ts.peekToken();
                if (tt == 89) {
                    init = this.nf.createLeaf(132, null);
                } else if (tt == 123) {
                    ts.getToken();
                    init = this.variables(ts, true, ts.tokenPosition);
                } else {
                    init = this.expr(ts, true);
                }
                tt = ts.peekToken();
                if (tt == 103 && ts.getOp() == 63) {
                    ts.matchToken(103);
                    cond = this.expr(ts, false);
                } else {
                    this.mustMatchToken(ts, 89, "msg.no.semi.for");
                    cond = ts.peekToken() == 89 ? this.nf.createLeaf(132, null) : this.expr(ts, false);
                    this.mustMatchToken(ts, 89, "msg.no.semi.for.cond");
                    incr = ts.peekToken() == 95 ? this.nf.createLeaf(132, null) : this.expr(ts, false);
                }
                this.mustMatchToken(ts, 95, "msg.no.paren.for.ctrl");
                Node body4 = this.statement(ts);
                if (incr == null) {
                    pn = this.nf.createForIn(init, cond, body4, position);
                    break;
                }
                pn = this.nf.createFor(init, cond, incr, body4, position);
                break;
            }
            case 75: {
                Node finallyblock = null;
                Node tryblock = this.statement(ts);
                Node catchblocks = this.nf.createLeaf(133, null);
                boolean sawDefaultCatch = false;
                int peek = ts.peekToken();
                if (peek == 125) {
                    while (ts.matchToken(125)) {
                        if (sawDefaultCatch) {
                            this.reportError(ts, "msg.catch.unreachable");
                        }
                        CodePosition catchPosition = ts.tokenPosition;
                        this.mustMatchToken(ts, 94, "msg.no.paren.catch");
                        this.mustMatchToken(ts, 44, "msg.bad.catchcond");
                        Node varName = this.nf.createName(ts.getString(), ts.tokenPosition);
                        Node catchCond = null;
                        if (ts.matchToken(113)) {
                            catchCond = this.expr(ts, false);
                        } else {
                            sawDefaultCatch = true;
                        }
                        this.mustMatchToken(ts, 95, "msg.bad.catchcond");
                        this.mustMatchToken(ts, 92, "msg.no.brace.catchblock");
                        catchblocks.addChildToBack(this.nf.createCatch(varName, catchCond, this.statements(ts), catchPosition));
                        this.mustMatchToken(ts, 93, "msg.no.brace.after.body");
                    }
                } else if (peek != 126) {
                    this.mustMatchToken(ts, 126, "msg.try.no.catchfinally");
                }
                if (ts.matchToken(126)) {
                    finallyblock = this.statement(ts);
                }
                pn = this.nf.createTryCatchFinally(tryblock, catchblocks, finallyblock, position);
                break;
            }
            case 62: {
                int lineno = ts.getLineno();
                pn = this.nf.createThrow(this.expr(ts, false), position);
                if (lineno != ts.getLineno()) break;
                this.wellTerminated(ts, -1);
                break;
            }
            case 121: {
                Node label = this.matchLabel(ts);
                pn = this.nf.createBreak(label, position);
                break;
            }
            case 122: {
                Node label = this.matchLabel(ts);
                pn = this.nf.createContinue(label, position);
                break;
            }
            case 146: {
                pn = this.nf.createDebugger(position);
                break;
            }
            case 124: {
                this.reportError(ts, "msg.jsni.unsupported.with");
                this.mustMatchToken(ts, 94, "msg.no.paren.with");
                Node obj = this.expr(ts, false);
                this.mustMatchToken(ts, 95, "msg.no.paren.after.with");
                Node body5 = this.statement(ts);
                pn = this.nf.createWith(obj, body5, position);
                break;
            }
            case 123: {
                int lineno = ts.getLineno();
                pn = this.variables(ts, false, position);
                if (ts.getLineno() != lineno) break;
                this.wellTerminated(ts, -1);
                break;
            }
            case 5: {
                Node retExpr = null;
                if (!this.insideFunction && (ts.flags & 2) == 0) {
                    this.reportError(ts, "msg.bad.return");
                }
                ts.flags |= 0x10;
                tt = ts.peekTokenSameLine();
                ts.flags &= 0xFFFFFFEF;
                if (tt != 0 && tt != 1 && tt != 89 && tt != 93) {
                    int lineno = ts.getLineno();
                    retExpr = this.expr(ts, false);
                    if (ts.getLineno() == lineno) {
                        this.wellTerminated(ts, -1);
                    }
                    ts.flags |= 4;
                } else {
                    ts.flags |= 8;
                }
                pn = this.nf.createReturn(retExpr, position);
                break;
            }
            case 92: {
                pn = this.statements(ts);
                this.mustMatchToken(ts, 93, "msg.no.brace.block");
                break;
            }
            case -1: 
            case 1: 
            case 89: {
                pn = this.nf.createLeaf(132, ts.tokenPosition);
                break;
            }
            default: {
                int lastExprType = tt;
                int tokenno = ts.getTokenno();
                ts.ungetToken(tt);
                int lineno = ts.getLineno();
                pn = this.expr(ts, false);
                if (ts.peekToken() == 99) {
                    if (lastExprType != 44 || ts.getTokenno() != tokenno) {
                        this.reportError(ts, "msg.bad.label");
                    }
                    ts.getToken();
                    String name = ts.getString();
                    pn = this.nf.createLabel(this.nf.createString(name, position), position);
                    pn.addChildToBack(this.statement(ts));
                    return pn;
                }
                if (lastExprType == 110 && this.nf.getLeafType(pn) != 110) {
                    this.reportError(ts, "msg.syntax");
                }
                pn = this.nf.createExprStatement(pn, position);
                if (ts.getLineno() != lineno && (lastExprType != 110 || ts.getLineno() != this.lastExprEndLine)) break;
                this.wellTerminated(ts, lastExprType);
                break;
            }
        }
        ts.matchToken(89);
        return pn;
    }

    private Node variables(TokenStream ts, boolean inForInit, CodePosition position) throws IOException, JavaScriptException {
        Node pn = this.nf.createVariables(position);
        do {
            this.mustMatchToken(ts, 44, "msg.bad.var");
            String s = ts.getString();
            Node name = this.nf.createName(s, ts.tokenPosition);
            if (ts.matchToken(97)) {
                if (ts.getOp() != 128) {
                    this.reportError(ts, "msg.bad.var.init");
                }
                Node init = this.assignExpr(ts, inForInit);
                name.addChildToBack(init);
            }
            pn.addChildToBack(name);
        } while (ts.matchToken(96));
        return pn;
    }

    public Node expr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Node pn = this.assignExpr(ts, inForInit);
        while (ts.matchToken(96)) {
            CodePosition position = ts.tokenPosition;
            pn = this.nf.createBinary(96, pn, this.assignExpr(ts, inForInit), position);
        }
        return pn;
    }

    private Node assignExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Comment commentBeforeNode = this.getComments(ts);
        Node pn = this.condExpr(ts, inForInit);
        pn.setCommentsBeforeNode(commentBeforeNode);
        if (ts.matchToken(97)) {
            CodePosition position = ts.tokenPosition;
            pn = this.nf.createBinary(97, ts.getOp(), pn, this.assignExpr(ts, inForInit), position);
        }
        ts.collectCommentsAfter();
        pn.setCommentsAfterNode(this.getComments(ts));
        return pn;
    }

    private Node condExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Node pn = this.orExpr(ts, inForInit);
        if (ts.matchToken(98)) {
            CodePosition position = ts.tokenPosition;
            Node ifTrue = this.assignExpr(ts, false);
            this.mustMatchToken(ts, 99, "msg.no.colon.cond");
            Node ifFalse = this.assignExpr(ts, inForInit);
            return this.nf.createTernary(pn, ifTrue, ifFalse, position);
        }
        return pn;
    }

    private Node orExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Node pn = this.andExpr(ts, inForInit);
        while (ts.matchToken(100)) {
            CodePosition position = ts.tokenPosition;
            pn = this.nf.createBinary(100, pn, this.andExpr(ts, inForInit), position);
        }
        return pn;
    }

    private Node andExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Node pn = this.bitOrExpr(ts, inForInit);
        while (ts.matchToken(101)) {
            CodePosition position = ts.tokenPosition;
            pn = this.nf.createBinary(101, pn, this.bitOrExpr(ts, inForInit), position);
        }
        return pn;
    }

    private Node bitOrExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Node pn = this.bitXorExpr(ts, inForInit);
        while (ts.matchToken(11)) {
            CodePosition position = ts.tokenPosition;
            pn = this.nf.createBinary(11, pn, this.bitXorExpr(ts, inForInit), position);
        }
        return pn;
    }

    private Node bitXorExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Node pn = this.bitAndExpr(ts, inForInit);
        while (ts.matchToken(12)) {
            CodePosition position = ts.tokenPosition;
            pn = this.nf.createBinary(12, pn, this.bitAndExpr(ts, inForInit), position);
        }
        return pn;
    }

    private Node bitAndExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Node pn = this.eqExpr(ts, inForInit);
        while (ts.matchToken(13)) {
            CodePosition position = ts.tokenPosition;
            pn = this.nf.createBinary(13, pn, this.eqExpr(ts, inForInit), position);
        }
        return pn;
    }

    private Node eqExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Node pn = this.relExpr(ts, inForInit);
        while (ts.matchToken(102)) {
            CodePosition position = ts.tokenPosition;
            pn = this.nf.createBinary(102, ts.getOp(), pn, this.relExpr(ts, inForInit), position);
        }
        return pn;
    }

    private Node relExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Node pn = this.shiftExpr(ts);
        CodePosition position = ts.tokenPosition;
        while (ts.matchToken(103)) {
            int op = ts.getOp();
            if (inForInit && op == 63) {
                ts.ungetToken(103);
                break;
            }
            pn = this.nf.createBinary(103, op, pn, this.shiftExpr(ts), position);
            position = ts.tokenPosition;
        }
        return pn;
    }

    private Node shiftExpr(TokenStream ts) throws IOException, JavaScriptException {
        Node pn = this.addExpr(ts);
        while (ts.matchToken(104)) {
            CodePosition position = ts.tokenPosition;
            pn = this.nf.createBinary(104, ts.getOp(), pn, this.addExpr(ts), position);
        }
        return pn;
    }

    private Node addExpr(TokenStream ts) throws IOException, JavaScriptException {
        int tt;
        Node pn = this.mulExpr(ts);
        while ((tt = ts.getToken()) == 23 || tt == 24) {
            CodePosition position = ts.tokenPosition;
            pn = this.nf.createBinary(tt, pn, this.mulExpr(ts), position);
        }
        ts.ungetToken(tt);
        return pn;
    }

    private Node mulExpr(TokenStream ts) throws IOException, JavaScriptException {
        int tt;
        Node pn = this.unaryExpr(ts);
        while ((tt = ts.peekToken()) == 25 || tt == 26 || tt == 27) {
            tt = ts.getToken();
            CodePosition position = ts.tokenPosition;
            pn = this.nf.createBinary(tt, pn, this.unaryExpr(ts), position);
        }
        return pn;
    }

    private Node unaryExpr(TokenStream ts) throws IOException, JavaScriptException {
        ts.flags |= 0x10;
        int tt = ts.getToken();
        ts.flags &= 0xFFFFFFEF;
        CodePosition position = ts.tokenPosition;
        switch (tt) {
            case 105: {
                return this.nf.createUnary(105, ts.getOp(), this.unaryExpr(ts), position);
            }
            case 23: 
            case 24: {
                return this.nf.createUnary(105, tt, this.unaryExpr(ts), position);
            }
            case 106: 
            case 107: {
                return this.nf.createUnary(tt, 130, this.memberExpr(ts, true), position);
            }
            case 31: {
                Node argument2 = this.unaryExpr(ts);
                if (!Parser.isValidDeleteArgument(argument2)) {
                    Context.reportError("msg.wrong.delete argument", argument2.getPosition(), ts.lastPosition);
                }
                return this.nf.createUnary(31, argument2, position);
            }
            case -1: {
                break;
            }
            default: {
                ts.ungetToken(tt);
                int lineno = ts.getLineno();
                Node pn = this.memberExpr(ts, true);
                int peeked = ts.peekToken();
                if ((peeked == 106 || peeked == 107) && ts.getLineno() == lineno) {
                    int pf = ts.getToken();
                    position = ts.tokenPosition;
                    return this.nf.createUnary(pf, 131, pn, position);
                }
                return pn;
            }
        }
        return this.nf.createName("err", position);
    }

    private static boolean isValidDeleteArgument(@NotNull Node node) {
        if (node == null) {
            Parser.$$$reportNull$$$0(0);
        }
        return node.type == 39 || node.type == 41;
    }

    private Node argumentList(TokenStream ts, Node listNode) throws IOException, JavaScriptException {
        ts.flags |= 0x10;
        boolean matched = ts.matchToken(95);
        ts.flags &= 0xFFFFFFEF;
        if (!matched) {
            do {
                listNode.addChildToBack(this.assignExpr(ts, false));
            } while (ts.matchToken(96));
            this.mustMatchToken(ts, 95, "msg.no.paren.arg");
        }
        return listNode;
    }

    private Node memberExpr(TokenStream ts, boolean allowCallSyntax) throws IOException, JavaScriptException {
        Node pn;
        CodePosition position = ts.tokenPosition;
        ts.flags |= 0x10;
        int tt = ts.peekToken();
        ts.flags &= 0xFFFFFFEF;
        if (tt == 30) {
            ts.getToken();
            pn = this.nf.createLeaf(30, position);
            pn.addChildToBack(this.memberExpr(ts, false));
            if (ts.matchToken(94)) {
                pn = this.argumentList(ts, pn);
            }
            if ((tt = ts.peekToken()) == 92) {
                pn.addChildToBack(this.primaryExpr(ts));
            }
        } else {
            pn = this.primaryExpr(ts);
        }
        return this.memberExprTail(ts, allowCallSyntax, pn);
    }

    private Node memberExprTail(TokenStream ts, boolean allowCallSyntax, Node pn) throws IOException, JavaScriptException {
        int tt;
        this.lastExprEndLine = ts.getLineno();
        while ((tt = ts.getToken()) > 0) {
            CodePosition position = ts.tokenPosition;
            if (tt == 108) {
                ts.treatKeywordAsIdentifier = true;
                this.mustMatchToken(ts, 44, "msg.no.name.after.dot");
                ts.treatKeywordAsIdentifier = false;
                pn = this.nf.createBinary(108, pn, this.nf.createName(ts.getString(), ts.tokenPosition), position);
                this.lastExprEndLine = ts.getLineno();
                continue;
            }
            if (tt == 90) {
                pn = this.nf.createBinary(90, pn, this.expr(ts, false), position);
                this.mustMatchToken(ts, 91, "msg.no.bracket.index");
                this.lastExprEndLine = ts.getLineno();
                continue;
            }
            if (allowCallSyntax && tt == 94) {
                pn = this.nf.createUnary(43, pn, position);
                pn = this.argumentList(ts, pn);
                this.lastExprEndLine = ts.getLineno();
                continue;
            }
            ts.ungetToken(tt);
            break;
        }
        return pn;
    }

    public Node primaryExpr(TokenStream ts) throws IOException, JavaScriptException {
        Comment commentsBeforeNode = this.getComments(ts);
        Node node = this.primaryExprHelper(ts);
        node.setCommentsBeforeNode(commentsBeforeNode);
        ts.collectCommentsAfter();
        node.setCommentsAfterNode(this.getComments(ts));
        return node;
    }

    private Node primaryExprHelper(TokenStream ts) throws IOException, JavaScriptException {
        ts.flags |= 0x10;
        int tt = ts.getToken();
        CodePosition position = ts.tokenPosition;
        ts.flags &= 0xFFFFFFEF;
        switch (tt) {
            case 110: {
                return this.function(ts, true);
            }
            case 90: {
                Node pn = this.nf.createLeaf(134, position);
                ts.flags |= 0x10;
                boolean matched = ts.matchToken(91);
                ts.flags &= 0xFFFFFFEF;
                if (!matched) {
                    do {
                        ts.flags |= 0x10;
                        tt = ts.peekToken();
                        ts.flags &= 0xFFFFFFEF;
                        if (tt == 91) break;
                        if (tt == 96) {
                            pn.addChildToBack(this.nf.createLeaf(109, 74, position));
                            continue;
                        }
                        pn.addChildToBack(this.assignExpr(ts, false));
                    } while (ts.matchToken(96));
                    this.mustMatchToken(ts, 91, "msg.no.bracket.arg");
                }
                return this.nf.createArrayLiteral(pn);
            }
            case 92: {
                Node pn = this.nf.createLeaf(135, position);
                if (!ts.matchToken(93)) {
                    block21: do {
                        Node property;
                        tt = ts.getToken();
                        switch (tt) {
                            case 44: 
                            case 46: {
                                property = this.nf.createString(ts.getString(), ts.tokenPosition);
                                break;
                            }
                            case 148: {
                                property = this.nf.createIntNumber(ts.getNumber(), ts.tokenPosition);
                                break;
                            }
                            case 45: {
                                double d = ts.getNumber();
                                property = this.nf.createNumber(d, ts.tokenPosition);
                                break;
                            }
                            case 93: {
                                ts.ungetToken(tt);
                                break block21;
                            }
                            default: {
                                this.reportError(ts, "msg.bad.prop");
                                break block21;
                            }
                        }
                        this.mustMatchToken(ts, 99, "msg.no.colon.prop");
                        pn.addChildToBack(property);
                        pn.addChildToBack(this.assignExpr(ts, false));
                    } while (ts.matchToken(96));
                    this.mustMatchToken(ts, 93, "msg.no.brace.prop");
                }
                return this.nf.createObjectLiteral(pn);
            }
            case 94: {
                Node pn = this.expr(ts, false);
                this.mustMatchToken(ts, 95, "msg.no.paren");
                return pn;
            }
            case 112: {
                if (ts.peekToken() != 94 && ts.peekToken() != 108) {
                    this.reportError(ts, "msg.syntax");
                }
                return this.nf.createName(TokenStream.tokenToName(112), position);
            }
            case 44: {
                String name = ts.getString();
                return this.nf.createName(name, position);
            }
            case 148: {
                return this.nf.createIntNumber(ts.getNumber(), position);
            }
            case 45: {
                double d = ts.getNumber();
                return this.nf.createNumber(d, position);
            }
            case 46: {
                String s = ts.getString();
                return this.nf.createString(s, position);
            }
            case 56: {
                String flags = ts.regExpFlags;
                ts.regExpFlags = null;
                String re = ts.getString();
                return this.nf.createRegExp(re, flags, position);
            }
            case 109: {
                return this.nf.createLeaf(109, ts.getOp(), position);
            }
            case -1: {
                break;
            }
            default: {
                this.reportError(ts, "msg.syntax");
            }
        }
        return null;
    }

    private Comment getComments(TokenStream ts) {
        Comment comment = ts.getHeadComment();
        if (comment != null) {
            ts.releaseComments();
        }
        return comment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/google/gwt/dev/js/rhino/Parser", "isValidDeleteArgument"));
    }
}

