/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.inspectors.common.ui.dataviewer;

import com.android.tools.adtui.stdui.ResizableImage;
import com.android.tools.inspectors.common.ui.dataviewer.ImageDataViewer;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijImageDataViewer
implements ImageDataViewer {
    @NotNull
    private final BufferedImage myImage;
    @NotNull
    private final JComponent myComponent;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static IntellijImageDataViewer createImageViewer(@NotNull byte[] content) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(content);){
            BufferedImage image = ImageIO.read(inputStream);
            if (image == null) {
                IntellijImageDataViewer intellijImageDataViewer = null;
                return intellijImageDataViewer;
            }
            IntellijImageDataViewer intellijImageDataViewer = new IntellijImageDataViewer(image);
            return intellijImageDataViewer;
        }
        catch (IOException e) {
            return null;
        }
    }

    private IntellijImageDataViewer(@NotNull BufferedImage image) {
        this.myImage = image;
        this.myComponent = new ResizableImage(image);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.myComponent;
    }

    @Override
    @NotNull
    public BufferedImage getImage() {
        return this.myImage;
    }
}

