/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator.tree;

import com.android.uiautomator.tree.AttributePair;
import com.android.uiautomator.tree.BasicTreeNode;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UiNode
extends BasicTreeNode {
    private static final Pattern BOUNDS_PATTERN = Pattern.compile("\\[-?(\\d+),-?(\\d+)\\]\\[-?(\\d+),-?(\\d+)\\]");
    private final Map<String, String> mAttributes = new LinkedHashMap<String, String>();
    private String mDisplayName = "ShouldNotSeeMe";
    private Object[] mCachedAttributesArray;

    public void addAtrribute(String key, String value) {
        this.mAttributes.put(key, value);
        this.updateDisplayName();
        if ("bounds".equals(key)) {
            this.updateBounds(value);
        }
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.mAttributes);
    }

    private void updateDisplayName() {
        String className = this.mAttributes.get("class");
        if (className == null) {
            return;
        }
        String text = this.mAttributes.get("text");
        if (text == null) {
            return;
        }
        String contentDescription = this.mAttributes.get("content-desc");
        if (contentDescription == null) {
            return;
        }
        String index = this.mAttributes.get("index");
        if (index == null) {
            return;
        }
        String bounds = this.mAttributes.get("bounds");
        if (bounds == null) {
            return;
        }
        className = className.replace("android.widget.", "");
        className = className.replace("android.view.", "");
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        builder.append(index);
        builder.append(") ");
        builder.append(className);
        if (!text.isEmpty()) {
            builder.append(':');
            builder.append(text);
        }
        if (!contentDescription.isEmpty()) {
            builder.append(" {");
            builder.append(contentDescription);
            builder.append('}');
        }
        builder.append(' ');
        builder.append(bounds);
        this.mDisplayName = builder.toString();
    }

    private void updateBounds(String bounds) {
        Matcher m = BOUNDS_PATTERN.matcher(bounds);
        if (!m.matches()) {
            throw new RuntimeException("Invalid bounds: " + bounds);
        }
        this.x = Integer.parseInt(m.group(1));
        this.y = Integer.parseInt(m.group(2));
        this.width = Integer.parseInt(m.group(3)) - this.x;
        this.height = Integer.parseInt(m.group(4)) - this.y;
        this.mHasBounds = true;
    }

    public String toString() {
        return this.mDisplayName;
    }

    public String getAttribute(String key) {
        return this.mAttributes.get(key);
    }

    @Override
    public Object[] getAttributesArray() {
        if (this.mCachedAttributesArray == null) {
            this.mCachedAttributesArray = new Object[this.mAttributes.size()];
            int i = 0;
            for (String attr : this.mAttributes.keySet()) {
                this.mCachedAttributesArray[i++] = new AttributePair(attr, this.mAttributes.get(attr));
            }
        }
        return this.mCachedAttributesArray;
    }
}

