/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview.classloading;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AndroidManifestPackageNameUtils;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.projectmodel.ExternalAndroidLibrary;
import com.android.resources.aar.AarResourceRepository;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.projectsystem.DependencyScopeType;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.idea.util.VirtualFileSystemOpener;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.ThrowableComputable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u00020\fH\u0002\u001a$\u0010\r\u001a\u00020\b*\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"RESOURCE_CLASS_NAME", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "isResourceClassName", "", "className", "", "registerResources", "", "module", "Lcom/intellij/openapi/module/Module;", "getResolvedPackageName", "Lcom/android/projectmodel/ExternalAndroidLibrary;", "registerLibraryResources", "repositoryManager", "Lcom/android/tools/idea/res/ResourceRepositoryManager;", "classRegistry", "Lcom/android/tools/idea/res/ResourceClassRegistry;", "idManager", "Lcom/android/tools/idea/res/ResourceIdManager;", "intellij.android.core"})
public final class LibraryResourceClassLoaderKt {
    private static final Pattern RESOURCE_CLASS_NAME = Pattern.compile(".+\\.R(\\$[^.]+)?$");

    private static final String getResolvedPackageName(ExternalAndroidLibrary $this$getResolvedPackageName) {
        if ($this$getResolvedPackageName.getPackageName() != null) {
            return $this$getResolvedPackageName.getPackageName();
        }
        PathString pathString = $this$getResolvedPackageName.getManifestFile();
        if (pathString != null) {
            String string;
            PathString it = pathString;
            boolean bl = false;
            try {
                string = AndroidManifestPackageNameUtils.getPackageNameFromManifestFile((PathString)it);
            }
            catch (IOException ignore) {
                if (VirtualFileSystemOpener.INSTANCE.recognizes(it)) {
                    FileExtensions.toVirtualFile($this$getResolvedPackageName.getManifestFile(), true);
                    try {
                        return AndroidManifestPackageNameUtils.getPackageNameFromManifestFile((PathString)it);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                string = null;
            }
            return string;
        }
        return null;
    }

    private static final void registerLibraryResources(ExternalAndroidLibrary $this$registerLibraryResources, ResourceRepositoryManager repositoryManager, ResourceClassRegistry classRegistry, ResourceIdManager idManager) {
        LocalResourceRepository localResourceRepository = repositoryManager.getAppResources();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)localResourceRepository), (String)"repositoryManager.appResources");
        LocalResourceRepository appResources = localResourceRepository;
        ResourceRepository rClassContents = null;
        ResourceNamespace resourcesNamespace = null;
        String packageName2 = null;
        if (repositoryManager.getNamespacing() == Namespacing.DISABLED) {
            String string = LibraryResourceClassLoaderKt.getResolvedPackageName($this$registerLibraryResources);
            if (string == null) {
                return;
            }
            packageName2 = string;
            rClassContents = (ResourceRepository)appResources;
            ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
            Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"RES_AUTO");
            resourcesNamespace = resourceNamespace;
        } else {
            AarResourceRepository aarResourceRepository = repositoryManager.findLibraryResources($this$registerLibraryResources);
            if (aarResourceRepository == null) {
                return;
            }
            AarResourceRepository aarResources = aarResourceRepository;
            rClassContents = (ResourceRepository)aarResources;
            ResourceNamespace resourceNamespace = aarResources.getNamespace();
            Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"aarResources.namespace");
            resourcesNamespace = resourceNamespace;
            packageName2 = aarResources.getPackageName();
        }
        classRegistry.addLibrary(rClassContents, idManager, packageName2, resourcesNamespace);
    }

    /*
     * WARNING - void declaration
     */
    private static final void registerResources(Module module2) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable $this$forEach$iv;
        boolean $i$f$forEach;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet androidFacet2 = androidFacet;
        ResourceRepositoryManager resourceRepositoryManager = ResourceRepositoryManager.getInstance(androidFacet2);
        Intrinsics.checkNotNullExpressionValue((Object)resourceRepositoryManager, (String)"getInstance(androidFacet)");
        ResourceRepositoryManager repositoryManager = resourceRepositoryManager;
        ResourceIdManager idManager = ResourceIdManager.Companion.get(module2);
        ResourceClassRegistry resourceClassRegistry = ResourceClassRegistry.get(module2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)resourceClassRegistry, (String)"get(module.project)");
        ResourceClassRegistry classRegistry = resourceClassRegistry;
        if (!idManager.getFinalIdsUsed()) {
            classRegistry.addLibrary((ResourceRepository)repositoryManager.getAppResources(), idManager, (String)ReadAction.compute((ThrowableComputable)new ThrowableComputable(androidFacet2){
                final /* synthetic */ AndroidFacet $androidFacet;
                {
                    this.$androidFacet = $androidFacet;
                }

                public final String compute() {
                    return ProjectSystemUtil.getModuleSystem(this.$androidFacet).getPackageName();
                }
            }), repositoryManager.getNamespace());
            List<AndroidFacet> list2 = AndroidDependenciesCache.getAllAndroidDependencies(module2, false);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllAndroidDependencies(module, false)");
            Iterable iterable = CollectionsKt.distinct((Iterable)list2);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AndroidFacet facet2 = (AndroidFacet)element$iv;
                boolean bl = false;
                classRegistry.addLibrary((ResourceRepository)repositoryManager.getAppResources(), idManager, (String)ReadAction.compute((ThrowableComputable)new ThrowableComputable(facet2){
                    final /* synthetic */ AndroidFacet $facet;
                    {
                        this.$facet = $facet;
                    }

                    public final String compute() {
                        AndroidFacet androidFacet = this.$facet;
                        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"facet");
                        return ProjectSystemUtil.getModuleSystem(androidFacet).getPackageName();
                    }
                }), repositoryManager.getNamespace());
            }
        }
        $this$forEach$iv = ProjectSystemUtil.getModuleSystem(module2).getAndroidLibraryDependencies(DependencyScopeType.MAIN);
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ExternalAndroidLibrary it = (ExternalAndroidLibrary)element$iv$iv;
            boolean bl = false;
            if (!it.getHasResources()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExternalAndroidLibrary it = (ExternalAndroidLibrary)element$iv;
            boolean bl = false;
            LibraryResourceClassLoaderKt.registerLibraryResources(it, repositoryManager, classRegistry, idManager);
        }
    }

    private static final boolean isResourceClassName(String className) {
        return RESOURCE_CLASS_NAME.matcher(className).matches();
    }

    public static final /* synthetic */ void access$registerResources(Module module2) {
        LibraryResourceClassLoaderKt.registerResources(module2);
    }

    public static final /* synthetic */ boolean access$isResourceClassName(String className) {
        return LibraryResourceClassLoaderKt.isResourceClassName(className);
    }
}

