/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview.classloading;

import com.android.tools.idea.projectsystem.ProjectSystemBuildManager;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.classloading.LibraryResourceClassLoaderKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0014\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u001f\u0010\u0006\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00040\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/android/uipreview/classloading/LibraryResourceClassLoader;", "Ljava/lang/ClassLoader;", "parent", "module", "Lcom/intellij/openapi/module/Module;", "(Ljava/lang/ClassLoader;Lcom/intellij/openapi/module/Module;)V", "moduleRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "getModuleRef", "()Ljava/lang/ref/WeakReference;", "findClass", "Ljava/lang/Class;", "name", "", "findResourceClass", "intellij.android.core"})
public final class LibraryResourceClassLoader
extends ClassLoader {
    @NotNull
    private final WeakReference<Module> moduleRef;

    public LibraryResourceClassLoader(@Nullable ClassLoader parent2, @NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        super(parent2);
        this.moduleRef = new WeakReference<Module>(module2);
        LibraryResourceClassLoaderKt.access$registerResources(module2);
    }

    @NotNull
    public final WeakReference<Module> getModuleRef() {
        return this.moduleRef;
    }

    private final Class<?> findResourceClass(String name) {
        Module module2 = (Module)this.moduleRef.get();
        if (module2 == null) {
            throw new ClassNotFoundException(name);
        }
        Module module3 = module2;
        if (!LibraryResourceClassLoaderKt.access$isResourceClassName(name)) {
            throw new ClassNotFoundException(name);
        }
        if (ResourceIdManager.Companion.get(module3).getFinalIdsUsed()) {
            Project project = module3.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            ProjectSystemBuildManager.BuildResult lastBuild = ProjectSystemService.Companion.getInstance(project).getProjectSystem().getBuildManager().getLastBuildResult();
            if (lastBuild.getMode() != ProjectSystemBuildManager.BuildMode.CLEAN && lastBuild.getStatus() == ProjectSystemBuildManager.BuildStatus.SUCCESS) {
                throw new ClassNotFoundException(name);
            }
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module3);
        if (androidFacet == null) {
            throw new ClassNotFoundException(name);
        }
        AndroidFacet facet2 = androidFacet;
        ResourceRepositoryManager resourceRepositoryManager = ResourceRepositoryManager.getInstance(facet2);
        Intrinsics.checkNotNullExpressionValue((Object)resourceRepositoryManager, (String)"getInstance(facet)");
        ResourceRepositoryManager repositoryManager = resourceRepositoryManager;
        byte[] byArray = ResourceClassRegistry.get(module3.getProject()).findClassDefinition(name, repositoryManager);
        if (byArray == null) {
            throw new ClassNotFoundException(name);
        }
        byte[] data2 = byArray;
        Logger.getInstance(LibraryResourceClassLoader.class).debug("  Defining class from AAR registry");
        Class<?> clazz = this.defineClass(name, data2, 0, data2.length);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"defineClass(name, data, 0, data.size)");
        return clazz;
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            Class<?> clazz2 = super.findClass(name);
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"{\n      super.findClass(name)\n    }");
            clazz = clazz2;
        }
        catch (ClassNotFoundException e) {
            clazz = this.findResourceClass(name);
        }
        return clazz;
    }
}

