/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.io.IAbstractFile;
import com.android.io.IAbstractFolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.uipreview.VirtualFileWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFolderWrapper
implements IAbstractFolder {
    private final Project myProject;
    private final VirtualFile myFolder;

    public VirtualFolderWrapper(@NotNull Project project, @NotNull VirtualFile folder) {
        this.myProject = project;
        this.myFolder = folder;
    }

    @Nullable
    public IAbstractFile getFile(String name) {
        VirtualFile child = this.myFolder.findChild(name);
        return child != null && !child.isDirectory() ? new VirtualFileWrapper(this.myProject, child) : null;
    }

    public String getOsLocation() {
        return FileUtil.toSystemDependentName((String)this.myFolder.getPath());
    }

    public boolean exists() {
        return this.myFolder.exists();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualFolderWrapper wrapper = (VirtualFolderWrapper)o;
        if (!this.myFolder.equals(wrapper.myFolder)) {
            return false;
        }
        return this.myProject.equals(wrapper.myProject);
    }

    public int hashCode() {
        int result2 = this.myProject.hashCode();
        result2 = 31 * result2 + this.myFolder.hashCode();
        return result2;
    }
}

