/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.tools.idea.rendering.classloading.ClassTransform;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.uipreview.ClassLoaderPreloaderKt;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.uipreview.ModuleClassLoaderManagerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0003R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00030\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/android/uipreview/Preloader;", "", "moduleClassLoader", "Lorg/jetbrains/android/uipreview/ModuleClassLoader;", "classesToPreload", "", "", "(Lorg/jetbrains/android/uipreview/ModuleClassLoader;Ljava/util/Collection;)V", "classLoader", "Ljava/lang/ref/SoftReference;", "kotlin.jvm.PlatformType", "isActive", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cancel", "", "getClassLoader", "getLoadedCount", "", "isForCompatible", "", "parent", "Ljava/lang/ClassLoader;", "projectTransformations", "Lcom/android/tools/idea/rendering/classloading/ClassTransform;", "nonProjectTransformations", "isLoadingFor", "cl", "intellij.android.core"})
public final class Preloader {
    @NotNull
    private final SoftReference<ModuleClassLoader> classLoader;
    @NotNull
    private AtomicBoolean isActive;

    public Preloader(@NotNull ModuleClassLoader moduleClassLoader, @NotNull Collection<String> classesToPreload) {
        Intrinsics.checkNotNullParameter((Object)moduleClassLoader, (String)"moduleClassLoader");
        Intrinsics.checkNotNullParameter(classesToPreload, (String)"classesToPreload");
        this.classLoader = new SoftReference<ModuleClassLoader>(moduleClassLoader);
        this.isActive = new AtomicBoolean(true);
        if (!classesToPreload.isEmpty()) {
            ClassLoader classLoader = moduleClassLoader;
            Function0 function0 = (Function0)new Function0<Boolean>(){

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke() {
                    boolean bl;
                    if (isActive.get()) {
                        ModuleClassLoader moduleClassLoader = (ModuleClassLoader)classLoader.get();
                        if (moduleClassLoader == null) {
                            return false;
                        }
                        if (Disposer.isDisposed((Disposable)moduleClassLoader)) {
                            bl = true;
                            return bl;
                        }
                    }
                    bl = false;
                    return bl;
                }
            };
            ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService()");
            ClassLoaderPreloaderKt.preload(classLoader, (Function0<Boolean>)function0, classesToPreload, executorService);
        }
    }

    public /* synthetic */ Preloader(ModuleClassLoader moduleClassLoader, Collection collection2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            collection2 = CollectionsKt.emptyList();
        }
        this(moduleClassLoader, collection2);
    }

    public final void cancel() {
        this.isActive.set(false);
    }

    @Nullable
    public final ModuleClassLoader getClassLoader() {
        this.cancel();
        return this.classLoader.get();
    }

    public final boolean isLoadingFor(@NotNull ModuleClassLoader cl) {
        Intrinsics.checkNotNullParameter((Object)cl, (String)"cl");
        return Intrinsics.areEqual((Object)this.classLoader.get(), (Object)cl);
    }

    public final boolean isForCompatible(@Nullable ClassLoader parent2, @NotNull ClassTransform projectTransformations, @NotNull ClassTransform nonProjectTransformations) {
        Intrinsics.checkNotNullParameter((Object)projectTransformations, (String)"projectTransformations");
        Intrinsics.checkNotNullParameter((Object)nonProjectTransformations, (String)"nonProjectTransformations");
        ModuleClassLoader moduleClassLoader = this.classLoader.get();
        return moduleClassLoader != null ? ModuleClassLoaderManagerKt.isCompatible(moduleClassLoader, parent2, projectTransformations, nonProjectTransformations) : false;
    }

    public final int getLoadedCount() {
        int n;
        ModuleClassLoader moduleClassLoader = this.classLoader.get();
        if (moduleClassLoader != null) {
            ModuleClassLoader it = moduleClassLoader;
            boolean bl = false;
            n = it.getNonProjectLoadedClasses().size() + it.getProjectLoadedClasses().size();
        } else {
            n = 0;
        }
        return n;
    }
}

