/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.android.uipreview.ClassLoadingUtilsKt;
import org.jetbrains.android.uipreview.ClassModificationTimestamp;
import org.jetbrains.android.uipreview.ModuleClassLoaderImpl;
import org.jetbrains.android.uipreview.ModuleClassLoaderUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u000fH\u0007\u001a\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u001c\u001a\u00020\u000f*\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0018\u0010\u0013\u001a\u00020\u000f*\u00020\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u001f"}, d2={"INTERNAL_PACKAGE", "", "additionalLibraries", "", "Ljava/nio/file/Path;", "getAdditionalLibraries", "()Ljava/util/List;", "ourLoaderCachePool", "Lcom/intellij/util/lang/UrlClassLoader$CachePool;", "Lorg/jetbrains/annotations/NotNull;", "externalLibraries", "Lcom/intellij/openapi/module/Module;", "getExternalLibraries", "(Lcom/intellij/openapi/module/Module;)Ljava/util/List;", "hasLoadedAnyUserCode", "", "Lorg/jetbrains/android/uipreview/ModuleClassLoaderImpl;", "getHasLoadedAnyUserCode", "(Lorg/jetbrains/android/uipreview/ModuleClassLoaderImpl;)Z", "isUserCodeUpToDate", "createUrlClassLoader", "Lcom/intellij/util/lang/UrlClassLoader;", "paths", "allowLock", "isResourceClassName", "fqcn", "onDiskClassNameLookup", "name", "isSourceModified", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.android.core"})
@JvmName(name="ModuleClassLoaderUtil")
public final class ModuleClassLoaderUtil {
    @NotNull
    private static final UrlClassLoader.CachePool ourLoaderCachePool;
    @NotNull
    public static final String INTERNAL_PACKAGE = "_layoutlib_._internal_.";

    @JvmOverloads
    @VisibleForTesting
    @NotNull
    public static final UrlClassLoader createUrlClassLoader(@NotNull List<? extends Path> paths, boolean allowLock) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        UrlClassLoader urlClassLoader = UrlClassLoader.build().files(paths).useCache(ourLoaderCachePool, (Predicate)createUrlClassLoader.1.INSTANCE).allowLock(allowLock).get();
        Intrinsics.checkNotNullExpressionValue((Object)urlClassLoader, (String)"build()\n    .files(paths\u2026ock(allowLock)\n    .get()");
        return urlClassLoader;
    }

    public static /* synthetic */ UrlClassLoader createUrlClassLoader$default(List list2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = !SystemInfo.isWindows;
        }
        return ModuleClassLoaderUtil.createUrlClassLoader(list2, bl);
    }

    private static final List<Path> getAdditionalLibraries() {
        String string = StudioEmbeddedRenderTarget.getEmbeddedLayoutLibPath();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String layoutlibDistributionPath = string;
        String string2 = FileUtil.toSystemIndependentName((String)"data/layoutlib-extensions.jar");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(\u2026ayoutlib-extensions.jar\")");
        String relativeCoroutineLibPath = string2;
        Object[] objectArray = new Path[]{new File(layoutlibDistributionPath, relativeCoroutineLibPath).toPath()};
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    @NotNull
    public static final List<Path> getExternalLibraries(@NotNull Module $this$externalLibraries) {
        Intrinsics.checkNotNullParameter((Object)$this$externalLibraries, (String)"<this>");
        return CollectionsKt.plus((Collection)ModuleClassLoaderUtil.getAdditionalLibraries(), (Iterable)ClassLoadingUtilsKt.getLibraryDependenciesJars($this$externalLibraries));
    }

    private static final String onDiskClassNameLookup(String name) {
        String string = StringUtil.trimStart((String)name, (String)INTERNAL_PACKAGE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimStart(name, INTERNAL_PACKAGE)");
        return string;
    }

    public static final boolean isResourceClassName(@NotNull String fqcn) {
        Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
        String it = StringsKt.substringAfterLast$default((String)fqcn, (String)".", null, (int)2, null);
        boolean bl = false;
        return Intrinsics.areEqual((Object)it, (Object)"R") || StringsKt.startsWith$default((String)it, (String)"R$", (boolean)false, (int)2, null);
    }

    public static final boolean isSourceModified(@Nullable Module $this$isSourceModified, @NotNull String fqcn, @NotNull VirtualFile classFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Module module2 = $this$isSourceModified;
        if (module2 != null) {
            Module it = module2;
            boolean bl2 = false;
            Project project = it.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"it.project");
            bl = ProjectSystemUtil.getProjectSystem(project).getClassJarProvider().isClassFileOutOfDate(it, fqcn, classFile);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean getHasLoadedAnyUserCode(ModuleClassLoaderImpl $this$hasLoadedAnyUserCode) {
        return !((Collection)$this$hasLoadedAnyUserCode.getProjectLoadedClassNames()).isEmpty() || !((Collection)$this$hasLoadedAnyUserCode.getProjectOverlayLoadedClassNames$intellij_android_core()).isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isUserCodeUpToDate(@NotNull ModuleClassLoaderImpl $this$isUserCodeUpToDate) {
        Intrinsics.checkNotNullParameter((Object)$this$isUserCodeUpToDate, (String)"<this>");
        if (!ModuleClassLoaderUtil.getHasLoadedAnyUserCode($this$isUserCodeUpToDate)) return true;
        Sequence<Triple<String, VirtualFile, ClassModificationTimestamp>> $this$all$iv = $this$isUserCodeUpToDate.getProjectLoadedClassVirtualFiles();
        boolean $i$f$all = false;
        for (Object element$iv : $this$all$iv) {
            Triple triple = (Triple)element$iv;
            boolean bl = false;
            VirtualFile virtualFile = (VirtualFile)triple.component2();
            ClassModificationTimestamp modificationTimestamp = (ClassModificationTimestamp)triple.component3();
            if (!virtualFile.isValid()) return false;
            if (!modificationTimestamp.isUpToDate(virtualFile)) return false;
            boolean bl2 = true;
            if (bl2) continue;
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        if (!$this$isUserCodeUpToDate.isOverlayUpToDate$intellij_android_core()) return false;
        return true;
    }

    @JvmOverloads
    @VisibleForTesting
    @NotNull
    public static final UrlClassLoader createUrlClassLoader(@NotNull List<? extends Path> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        return ModuleClassLoaderUtil.createUrlClassLoader$default(paths, false, 2, null);
    }

    public static final /* synthetic */ boolean access$getHasLoadedAnyUserCode(ModuleClassLoaderImpl $receiver) {
        return ModuleClassLoaderUtil.getHasLoadedAnyUserCode($receiver);
    }

    public static final /* synthetic */ String access$onDiskClassNameLookup(String name) {
        return ModuleClassLoaderUtil.onDiskClassNameLookup(name);
    }

    static {
        UrlClassLoader.CachePool cachePool = UrlClassLoader.createCachePool();
        Intrinsics.checkNotNullExpressionValue((Object)cachePool, (String)"createCachePool()");
        ourLoaderCachePool = cachePool;
    }
}

