/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/android/uipreview/HierarchicalTimeCounter;", "", "()V", "childrenTime", "", "counterStack", "Ljava/util/Stack;", "Lkotlin/Pair;", "", "end", "key", "totalTime", "start", "", "intellij.android.core"})
public final class HierarchicalTimeCounter {
    private long childrenTime;
    @NotNull
    private final Stack<Pair<String, Long>> counterStack = new Stack();

    public final synchronized void start(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.counterStack.push((Pair<String, Long>)TuplesKt.to((Object)key, (Object)this.childrenTime));
        this.childrenTime = 0L;
    }

    public final synchronized long end(@NotNull String key, long totalTime) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Pair<String, Long> pair = this.counterStack.pop();
        String poppedKey = (String)pair.component1();
        long siblingsTotalTime = ((Number)pair.component2()).longValue();
        if (!Intrinsics.areEqual((Object)key, (Object)poppedKey)) {
            Logger.getInstance(HierarchicalTimeCounter.class).warn("Unbalanced start/end calls. Received " + key + " (expected " + poppedKey + ")");
            throw new IllegalStateException();
        }
        long selfTime = totalTime - this.childrenTime;
        this.childrenTime = totalTime + siblingsTotalTime;
        return selfTime;
    }
}

