/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.impl.ProjectViewSelectInPaneTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/android/uipreview/EditorUtil;", "", "()V", "openEditor", "", "project", "Lcom/intellij/openapi/project/Project;", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "selectEditor", "file", "intellij.android.core"})
public final class EditorUtil {
    @NotNull
    public static final EditorUtil INSTANCE = new EditorUtil();

    private EditorUtil() {
    }

    @JvmStatic
    public static final void openEditor(@NotNull Project project, @NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        OpenFileDescriptor descriptor2 = vFile.getFileType() == XmlFileType.INSTANCE && AndroidEditorSettings.getInstance().getGlobalState().isPreferXmlEditor() ? new OpenFileDescriptor(project, vFile, 0) : new OpenFileDescriptor(project, vFile);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor2, true);
    }

    @JvmStatic
    public static final void selectEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        AbstractProjectViewPane abstractProjectViewPane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane();
        if (abstractProjectViewPane == null) {
            return;
        }
        AbstractProjectViewPane currentPane = abstractProjectViewPane;
        new ProjectViewSelectInPaneTarget(project, currentPane, true).select((PsiElement)psiFile2, false);
    }
}

