/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.uipreview.ClassModificationTimestamp;
import org.jetbrains.android.uipreview.ClassModificationTimestampKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/android/uipreview/ClassModificationTimestamp;", "", "vFileTimestamp", "", "vFileLength", "fileTimestamp", "diskTimeStampProvider", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "(JJJLkotlin/jvm/functions/Function1;)V", "isUpToDate", "", "vFile", "Companion", "intellij.android.core"})
@VisibleForTesting
public final class ClassModificationTimestamp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long vFileTimestamp;
    private final long vFileLength;
    private final long fileTimestamp;
    @NotNull
    private final Function1<VirtualFile, Long> diskTimeStampProvider;

    public ClassModificationTimestamp(long vFileTimestamp, long vFileLength, long fileTimestamp, @NotNull Function1<? super VirtualFile, Long> diskTimeStampProvider) {
        Intrinsics.checkNotNullParameter(diskTimeStampProvider, (String)"diskTimeStampProvider");
        this.vFileTimestamp = vFileTimestamp;
        this.vFileLength = vFileLength;
        this.fileTimestamp = fileTimestamp;
        this.diskTimeStampProvider = diskTimeStampProvider;
    }

    public final boolean isUpToDate(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        return vFile.isValid() && vFile.getTimeStamp() == this.vFileTimestamp && vFile.getLength() == this.vFileLength && this.fileTimestamp != -1L && ((Number)this.diskTimeStampProvider.invoke((Object)vFile)).longValue() == this.fileTimestamp;
    }

    @JvmStatic
    @TestOnly
    @NotNull
    public static final ClassModificationTimestamp fromVirtualFileForTest(@NotNull VirtualFile vFile, @NotNull Function1<? super VirtualFile, Long> diskTimeStampProvider) {
        return Companion.fromVirtualFileForTest(vFile, diskTimeStampProvider);
    }

    @JvmStatic
    @NotNull
    public static final ClassModificationTimestamp fromVirtualFile(@NotNull VirtualFile vFile) {
        return Companion.fromVirtualFile(vFile);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J$\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/android/uipreview/ClassModificationTimestamp$Companion;", "", "()V", "fromVirtualFile", "Lorg/jetbrains/android/uipreview/ClassModificationTimestamp;", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fromVirtualFileForTest", "diskTimeStampProvider", "Lkotlin/Function1;", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @TestOnly
        @NotNull
        public final ClassModificationTimestamp fromVirtualFileForTest(@NotNull VirtualFile vFile, @NotNull Function1<? super VirtualFile, Long> diskTimeStampProvider) {
            Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
            Intrinsics.checkNotNullParameter(diskTimeStampProvider, (String)"diskTimeStampProvider");
            return new ClassModificationTimestamp(vFile.getTimeStamp(), vFile.getLength(), ((Number)diskTimeStampProvider.invoke((Object)vFile)).longValue(), diskTimeStampProvider);
        }

        @JvmStatic
        @NotNull
        public final ClassModificationTimestamp fromVirtualFile(@NotNull VirtualFile vFile) {
            Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
            return new ClassModificationTimestamp(vFile.getTimeStamp(), vFile.getLength(), ClassModificationTimestampKt.access$lastModifiedTimeFromDisk(vFile), (Function1<? super VirtualFile, Long>)((Function1)fromVirtualFile.1.INSTANCE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

