/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemWithVisibility;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.LayoutLibraryLoader;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.res.FrameworkResourceRepositoryManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl;
import org.jetbrains.android.resourceManagers.FilteredAttributeDefinitions;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.CompatibilityRenderTarget;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTargetData {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.sdk.AndroidTargetData");
    @NotNull
    private final List<String> myPublicFileNames = ImmutableList.of((Object)"public.xml", (Object)"public-final.xml", (Object)"public-staging.xml");
    private final AndroidSdkData mySdkData;
    private final IAndroidTarget myTarget;
    private final Object myAttrDefsLock = new Object();
    private AttributeDefinitions myAttrDefs;
    private LayoutLibrary myLayoutLibrary;
    private final Object myPublicResourceIdMapLock = new Object();
    private TIntObjectHashMap<String> myPublicResourceIdMap;
    private volatile MyStaticConstantsData myStaticConstantsData;

    public AndroidTargetData(@NotNull AndroidSdkData sdkData, @NotNull IAndroidTarget target2) {
        this.mySdkData = sdkData;
        this.myTarget = target2;
    }

    @NotNull
    public AttributeDefinitions getPublicAttrDefs(@NotNull Project project) {
        AttributeDefinitions attrDefs = this.getAllAttrDefs(project);
        return new PublicAttributeDefinitions(attrDefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AttributeDefinitions getAllAttrDefs(@NotNull Project project) {
        Object object = this.myAttrDefsLock;
        synchronized (object) {
            if (this.myAttrDefs == null) {
                String attrsPath = FileUtil.toSystemIndependentName((String)this.myTarget.getPath(8).toString());
                String attrsManifestPath = FileUtil.toSystemIndependentName((String)this.myTarget.getPath(9).toString());
                this.myAttrDefs = AttributeDefinitionsImpl.parseFrameworkFiles(new File(attrsPath), new File(attrsManifestPath));
            }
            return this.myAttrDefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TIntObjectHashMap<String> getPublicIdMap() {
        Object object = this.myPublicResourceIdMapLock;
        synchronized (object) {
            if (this.myPublicResourceIdMap == null) {
                this.buildPublicResourceIdMap();
            }
            return this.myPublicResourceIdMap;
        }
    }

    public boolean isResourcePublic(@NotNull ResourceType type, @NotNull String name) {
        ResourceRepository frameworkResources = this.getFrameworkResources(Collections.emptySet());
        if (frameworkResources == null) {
            return false;
        }
        List resources2 = frameworkResources.getResources(ResourceNamespace.ANDROID, type, name);
        return !resources2.isEmpty() && ((ResourceItemWithVisibility)resources2.get(0)).getVisibility() == ResourceVisibility.PUBLIC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildPublicResourceIdMap() {
        Path resDirPath = this.myTarget.getPath(11);
        TIntObjectHashMap resourceIdMap = new TIntObjectHashMap();
        for (String fileName : this.myPublicFileNames) {
            Path publicXmlPath = resDirPath.resolve("values").resolve(fileName);
            VirtualFile publicXml = LocalFileSystem.getInstance().findFileByNioFile(publicXmlPath);
            if (publicXml == null) continue;
            try {
                MyPublicResourceIdMapBuilder builder2 = new MyPublicResourceIdMapBuilder();
                NanoXmlUtil.parse((InputStream)publicXml.getInputStream(), (IXMLBuilder)builder2);
                builder2.getIdMap().forEachEntry((key, value2) -> {
                    resourceIdMap.put(key, value2);
                    return true;
                });
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        Object object = this.myPublicResourceIdMapLock;
        synchronized (object) {
            this.myPublicResourceIdMap = resourceIdMap;
        }
    }

    @Slow
    @NotNull
    public LayoutLibrary getLayoutLibrary(@NotNull Project project) throws RenderingException {
        if (this.myLayoutLibrary == null || this.myLayoutLibrary.isDisposed()) {
            IAndroidTarget target2;
            AndroidTargetData targetData;
            if (this.myTarget instanceof CompatibilityRenderTarget && (targetData = this.mySdkData.getTargetData(target2 = ((CompatibilityRenderTarget)this.myTarget).getRenderTarget())) != this) {
                this.myLayoutLibrary = targetData.getLayoutLibrary(project);
                return this.myLayoutLibrary;
            }
            if (!(this.myTarget instanceof StudioEmbeddedRenderTarget)) {
                LOG.warn("Rendering will not use the StudioEmbeddedRenderTarget");
            }
            this.myLayoutLibrary = LayoutLibraryLoader.load((IAndroidTarget)this.myTarget, this.getFrameworkEnumValues());
            Disposer.register((Disposable)((ProjectEx)project).getEarlyDisposable(), (Disposable)this.myLayoutLibrary);
        }
        return this.myLayoutLibrary;
    }

    @Slow
    @NotNull
    private Map<String, Map<String, Integer>> getFrameworkEnumValues() {
        ResourceRepository resources2 = this.getFrameworkResources((Set<String>)ImmutableSet.of());
        if (resources2 == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Integer>> result2 = new HashMap<String, Map<String, Integer>>();
        Collection items2 = resources2.getResources(ResourceNamespace.ANDROID, ResourceType.ATTR).values();
        for (ResourceItem item2 : items2) {
            Map valueMap;
            ResourceValue attr = item2.getResourceValue();
            if (!(attr instanceof AttrResourceValue) || (valueMap = ((AttrResourceValue)attr).getAttributeValues()).isEmpty()) continue;
            result2.put(attr.getName(), valueMap);
        }
        items2 = resources2.getResources(ResourceNamespace.ANDROID, ResourceType.STYLEABLE).values();
        for (ResourceItem item2 : items2) {
            ResourceValue styleable = item2.getResourceValue();
            if (!(styleable instanceof StyleableResourceValue)) continue;
            List attrs = ((StyleableResourceValue)styleable).getAllAttributes();
            for (AttrResourceValue attr : attrs) {
                Map valueMap = attr.getAttributeValues();
                if (valueMap.isEmpty()) continue;
                result2.put(attr.getName(), valueMap);
            }
        }
        return result2;
    }

    public void clearLayoutBitmapCache(Module module2) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearResourceCaches((Object)module2);
        }
    }

    public void clearFontCache(String path2) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearFontCache(path2);
        }
    }

    public void clearAllCaches(Module module2) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearAllCaches((Object)module2);
        }
    }

    @NotNull
    public IAndroidTarget getTarget() {
        return this.myTarget;
    }

    @NotNull
    public synchronized MyStaticConstantsData getStaticConstantsData() {
        if (this.myStaticConstantsData == null) {
            this.myStaticConstantsData = new MyStaticConstantsData();
        }
        return this.myStaticConstantsData;
    }

    @Slow
    @Nullable
    public synchronized ResourceRepository getFrameworkResources(@NotNull Set<String> languages2) {
        Path resFolderOrJar = this.myTarget.getPath(11);
        if (!Files.exists(resFolderOrJar, new LinkOption[0])) {
            LOG.error(String.format("\"%s\" directory or file cannot be found", resFolderOrJar));
            return null;
        }
        return FrameworkResourceRepositoryManager.getInstance().getFrameworkResources(resFolderOrJar, this.myTarget instanceof CompatibilityRenderTarget, languages2);
    }

    @Slow
    @Nullable
    public synchronized ResourceRepository getCachedFrameworkResources(@NotNull Set<String> languages2) {
        Path resFolderOrJar = this.myTarget.getPath(11);
        if (!Files.exists(resFolderOrJar, new LinkOption[0])) {
            LOG.error(String.format("\"%s\" directory or file cannot be found", resFolderOrJar));
            return null;
        }
        return FrameworkResourceRepositoryManager.getInstance().getCachedFrameworkResources(resFolderOrJar, this.myTarget instanceof CompatibilityRenderTarget, languages2);
    }

    @Nullable
    public static AndroidTargetData getTargetData(@NotNull IAndroidTarget target2, @NotNull Module module2) {
        AndroidPlatform platform = AndroidPlatform.getInstance(module2);
        return platform != null ? platform.getSdkData().getTargetData(target2) : null;
    }

    public class MyStaticConstantsData {
        private final Set<String> myActivityActions = this.collectValues(14);
        private final Set<String> myServiceActions = this.collectValues(16);
        private final Set<String> myReceiverActions = this.collectValues(15);
        private final Set<String> myCategories = this.collectValues(17);

        private MyStaticConstantsData() {
        }

        @Nullable
        public Set<String> getActivityActions() {
            return this.myActivityActions;
        }

        @Nullable
        public Set<String> getServiceActions() {
            return this.myServiceActions;
        }

        @Nullable
        public Set<String> getReceiverActions() {
            return this.myReceiverActions;
        }

        @Nullable
        public Set<String> getCategories() {
            return this.myCategories;
        }

        @Nullable
        private Set<String> collectValues(int pathId) {
            HashSet<String> hashSet;
            block9: {
                BufferedReader reader2 = Files.newBufferedReader(AndroidTargetData.this.myTarget.getPath(pathId));
                try {
                    String line2;
                    HashSet<String> result2 = new HashSet<String>();
                    while ((line2 = reader2.readLine()) != null) {
                        if ((line2 = line2.trim()).isEmpty() || line2.startsWith("#")) continue;
                        result2.add(line2);
                    }
                    hashSet = result2;
                    if (reader2 == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader2 != null) {
                            try {
                                reader2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                reader2.close();
            }
            return hashSet;
        }
    }

    @VisibleForTesting
    static class MyPublicResourceIdMapBuilder
    implements NanoXmlBuilder {
        private final TIntObjectHashMap<String> myIdMap = new TIntObjectHashMap(3000);
        private String myName;
        private String myType;
        private int myId;
        private boolean inGroup;

        MyPublicResourceIdMapBuilder() {
        }

        public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) {
            if ("public".equals(name) && this.myName != null && this.myType != null && this.myId != 0) {
                this.myIdMap.put(this.myId, (Object)("@android:" + this.myType + "/" + this.myName));
                if (this.inGroup) {
                    ++this.myId;
                }
            }
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value2, String type) {
            switch (key) {
                case "name": {
                    this.myName = value2;
                    break;
                }
                case "type": {
                    this.myType = value2;
                    break;
                }
                case "first-id": 
                case "id": {
                    try {
                        this.myId = Integer.decode(value2);
                        break;
                    }
                    catch (NumberFormatException e) {
                        this.myId = 0;
                    }
                }
            }
        }

        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) {
            if (!this.inGroup) {
                this.myType = null;
                this.myId = 0;
            }
            if ("public-group".equals(name)) {
                this.inGroup = true;
            }
            this.myName = null;
        }

        public void endElement(String name, String nsPrefix, String nsURI) {
            if ("public-group".equals(name)) {
                this.inGroup = false;
            }
        }

        public TIntObjectHashMap<String> getIdMap() {
            return this.myIdMap;
        }
    }

    private class PublicAttributeDefinitions
    extends FilteredAttributeDefinitions {
        protected PublicAttributeDefinitions(AttributeDefinitions wrappee) {
            super(wrappee);
        }

        @Override
        protected boolean isAttributeAcceptable(@NotNull ResourceReference attr) {
            return attr.getNamespace().equals((Object)ResourceNamespace.ANDROID) && !attr.getName().startsWith("__removed") && AndroidTargetData.this.isResourcePublic(ResourceType.ATTR, attr.getName());
        }
    }
}

