/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.SdkConstants;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.CommonBundle;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSdkUtils {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.sdk.AndroidSdkUtils");
    public static final String DEFAULT_JDK_NAME = "JDK";
    public static final String ADB_PATH_PROPERTY = "android.adb.path";

    private AndroidSdkUtils() {
    }

    @Nullable
    public static Sdk createNewAndroidPlatform(@Nullable String sdkPath, boolean promptUser) {
        Sdk sdk;
        IAndroidTarget target2;
        Sdk jdk = IdeSdks.getInstance().getJdk();
        if (sdkPath != null && jdk != null && (target2 = AndroidSdkUtils.findBestTarget(sdkPath = FileUtil.toSystemIndependentName((String)sdkPath))) != null && (sdk = AndroidSdks.getInstance().create(target2, new File(sdkPath), AndroidSdks.getInstance().chooseNameForNewLibrary(target2), jdk, true)) != null) {
            return sdk;
        }
        String jdkPath = jdk == null ? null : jdk.getHomePath();
        return promptUser ? AndroidSdkUtils.promptUserForSdkCreation(null, sdkPath, jdkPath) : null;
    }

    @Nullable
    private static IAndroidTarget findBestTarget(@NotNull String sdkPath) {
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdkPath);
        if (sdkData != null) {
            IAndroidTarget[] targets = sdkData.getTargets();
            if (targets.length == 1) {
                return targets[0];
            }
            return AndroidSdkUtils.findBestTarget(targets);
        }
        return null;
    }

    @Nullable
    private static IAndroidTarget findBestTarget(@NotNull IAndroidTarget[] targets) {
        int androidPlatformToAutocreate = (Integer)StudioFlags.ANDROID_PLATFORM_TO_AUTOCREATE.get();
        IAndroidTarget bestTarget = null;
        int maxApiLevel = -1;
        for (IAndroidTarget target2 : targets) {
            AndroidVersion version2 = target2.getVersion();
            if (!target2.isPlatform() || version2.isPreview() || version2.getApiLevel() <= maxApiLevel) continue;
            bestTarget = target2;
            maxApiLevel = version2.getApiLevel();
            if (maxApiLevel == androidPlatformToAutocreate) break;
        }
        return bestTarget;
    }

    public static String getTargetPresentableName(@NotNull IAndroidTarget target2) {
        return target2.isPlatform() ? target2.getName() : target2.getName() + " (" + target2.getVersionName() + ")";
    }

    public static boolean targetHasId(@NotNull IAndroidTarget target2, @NotNull String id2) {
        return id2.equals(target2.getVersion().getApiString()) || id2.equals(target2.getVersionName());
    }

    public static void updateSdkSourceRoot(@NotNull Sdk sdk) {
        AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
        if (platform != null) {
            IAndroidTarget target2 = platform.getTarget();
            SdkModificator sdkModificator = sdk.getSdkModificator();
            sdkModificator.removeRoots(OrderRootType.SOURCES);
            AndroidSdks.getInstance().findAndSetPlatformSources(target2, sdkModificator);
            sdkModificator.commitChanges();
        }
    }

    @Nullable
    private static Sdk promptUserForSdkCreation(@Nullable IAndroidTarget target2, @Nullable String androidSdkPath, @Nullable String jdkPath) {
        Ref sdkRef = new Ref();
        Runnable task2 = () -> {
            SelectSdkDialog dlg = new SelectSdkDialog(jdkPath, androidSdkPath);
            dlg.setModal(true);
            if (dlg.showAndGet()) {
                Sdk sdk = AndroidSdkUtils.createNewAndroidPlatform(target2, dlg.getAndroidHome(), dlg.getJdkHome());
                sdkRef.set((Object)sdk);
                if (sdk != null) {
                    IdeSdks.updateWelcomeRunAndroidSdkAction();
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            task2.run();
            return (Sdk)sdkRef.get();
        }
        application.invokeAndWait(task2, ModalityState.any());
        return (Sdk)sdkRef.get();
    }

    @Nullable
    private static Sdk createNewAndroidPlatform(@Nullable IAndroidTarget target2, @NotNull String androidSdkPath, @NotNull String jdkPath) {
        if (StringUtil.isNotEmpty((String)jdkPath)) {
            jdkPath = FileUtil.toSystemIndependentName((String)jdkPath);
            Sdk jdk = Jdks.getInstance().createJdk(jdkPath);
            if (jdk != null) {
                androidSdkPath = FileUtil.toSystemIndependentName((String)androidSdkPath);
                if (target2 == null) {
                    target2 = AndroidSdkUtils.findBestTarget(androidSdkPath);
                }
                if (target2 != null) {
                    return AndroidSdks.getInstance().create(target2, new File(androidSdkPath), AndroidSdks.getInstance().chooseNameForNewLibrary(target2), jdk, true);
                }
            }
        }
        return null;
    }

    public static void openModuleDependenciesConfigurable(@NotNull Module module2) {
        ProjectSettingsService.getInstance((Project)module2.getProject()).openModuleDependenciesSettings(module2, null);
    }

    @Deprecated
    @Nullable
    public static File getAdb(@Nullable Project project) {
        return AndroidSdkUtils.findAdb((Project)project).adbPath;
    }

    @NotNull
    public static AdbSearchResult findAdb(@Nullable Project project) {
        String pathProperty;
        File sdkPath;
        Path adb;
        ArrayList<String> searchedPaths = new ArrayList<String>(3);
        String path2 = System.getProperty(ADB_PATH_PROPERTY);
        searchedPaths.add(String.format("ADB_PATH_PROPERTY (%s): '%s'", ADB_PATH_PROPERTY, Strings.isNullOrEmpty((String)path2) ? "<not set>" : path2));
        if (path2 != null && Files.exists(adb = Paths.get(path2, new String[0]), new LinkOption[0])) {
            return new AdbSearchResult(adb, searchedPaths);
        }
        if (project != null) {
            Path adb2;
            AndroidSdkData data2 = AndroidSdkUtils.getProjectSdkData(project);
            if (data2 == null) {
                data2 = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
                searchedPaths.add(String.format("Android SDK location from first Android Module in Project: %s", data2 == null ? "<not present>" : String.format("'%s'", data2.getLocation())));
            } else {
                searchedPaths.add(String.format("Android SDK location from Project: '%s'", data2.getLocation()));
            }
            if (data2 != null && Files.exists(adb2 = data2.getLocation().resolve(AndroidBuildCommonUtils.platformToolPath((String)SdkConstants.FN_ADB)), new LinkOption[0])) {
                return new AdbSearchResult(adb2, searchedPaths);
            }
        }
        if ((sdkPath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
            Path dir = sdkPath.toPath();
            searchedPaths.add(String.format("Android SDK location from global settings: '%s'", dir));
            Path adb3 = dir.resolve(AndroidBuildCommonUtils.platformToolPath((String)SdkConstants.FN_ADB));
            if (Files.exists(adb3, new LinkOption[0])) {
                return new AdbSearchResult(adb3, searchedPaths);
            }
        }
        if ((pathProperty = EnvironmentUtil.getValue((String)"PATH")) != null) {
            for (String dir : pathProperty.split(System.getProperty("path.separator"))) {
                searchedPaths.add(String.format("From the PATH environment variable: '%s'", dir));
                Path adb4 = Paths.get(dir, SdkConstants.FN_ADB);
                if (!Files.exists(adb4, new LinkOption[0])) continue;
                return new AdbSearchResult(adb4, searchedPaths);
            }
        }
        return new AdbSearchResult(null, searchedPaths);
    }

    @Nullable
    public static AndroidSdkData getFirstAndroidModuleSdkData(Project project) {
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        for (AndroidFacet facet2 : facets) {
            AndroidPlatform androidPlatform = AndroidPlatform.getInstance(facet2.getModule());
            if (androidPlatform == null) continue;
            return androidPlatform.getSdkData();
        }
        return null;
    }

    @Nullable
    public static AndroidSdkData getProjectSdkData(Project project) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectSdk != null) {
            AndroidPlatform platform = AndroidPlatform.getInstance(projectSdk);
            return platform != null ? platform.getSdkData() : null;
        }
        return null;
    }

    public static boolean isAndroidSdkAvailable() {
        return AndroidSdks.getInstance().tryToChooseAndroidSdk() != null;
    }

    @NotNull
    public static String getTargetLabel(@NotNull IAndroidTarget target2) {
        if (!target2.isPlatform()) {
            return String.format("%1$s (API %2$s)", target2.getFullName(), target2.getVersion().getApiString());
        }
        AndroidVersion version2 = target2.getVersion();
        if (version2.isPreview()) {
            return String.format(Locale.US, "API %d+: %s", target2.getVersion().getApiLevel(), target2.getName());
        }
        String name = SdkVersionInfo.getAndroidName((int)target2.getVersion().getApiLevel());
        if (StringUtil.isNotEmpty((String)name)) {
            return name;
        }
        String release = target2.getProperty("ro.build.version.release");
        if (release != null) {
            return String.format(Locale.US, "API %1$d: Android %2$s", version2.getApiLevel(), release);
        }
        return String.format(Locale.US, "API %1$d", version2.getApiLevel());
    }

    @Nullable
    public static AndroidDebugBridge getDebugBridge(@NotNull Project project) {
        boolean retry2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        AndroidSdkData data2 = AndroidSdkUtils.getProjectSdkData(project);
        if (data2 == null) {
            data2 = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
        }
        if (data2 == null) {
            LOG.warn("Fail to find project SDK data.");
        }
        AndroidDebugBridge bridge = null;
        do {
            AdbSearchResult searchResult = AndroidSdkUtils.findAdb(project);
            if (searchResult.adbPath == null) {
                NotificationGroup.balloonGroup((String)"Android Debug Bridge (adb)").createNotification("Unable to locate adb in project/module settings. Locations searched:<br>" + String.join((CharSequence)"<br>", searchResult.searchedPaths), NotificationType.ERROR).setImportant(true).notify(project);
                LOG.warn("Unable to locate adb.");
                return null;
            }
            ListenableFuture<AndroidDebugBridge> future2 = AdbService.getInstance().getDebugBridge(searchResult.adbPath);
            MyMonitorBridgeConnectionTask task2 = new MyMonitorBridgeConnectionTask(project, (Future<AndroidDebugBridge>)future2);
            ProgressManager.getInstance().run((Task)task2);
            if (task2.wasCanceled()) {
                return null;
            }
            retry2 = false;
            try {
                bridge = (AndroidDebugBridge)future2.get();
            }
            catch (InterruptedException e) {
                break;
            }
            catch (ExecutionException e) {
                String message2 = "ADB not responding. If you'd like to retry, then please manually kill \"" + SdkConstants.FN_ADB + "\" and click 'Restart'";
                boolean bl = retry2 = Messages.showYesNoDialog((Project)project, (String)message2, (String)CommonBundle.getErrorTitle(), (String)"&Restart", (String)"&Cancel", (Icon)Messages.getErrorIcon()) == 0;
            }
        } while (retry2);
        return bridge;
    }

    public static boolean isAndroidSdkManagerEnabled() {
        boolean sdkManagerDisabled = SystemProperties.getBooleanProperty((String)"android.studio.sdk.manager.disabled", (boolean)false);
        return !sdkManagerDisabled;
    }

    private static class MyMonitorBridgeConnectionTask
    extends Task.Modal {
        private final Future<AndroidDebugBridge> myFuture;
        private boolean myCancelled;

        public MyMonitorBridgeConnectionTask(@Nullable Project project, Future<AndroidDebugBridge> future2) {
            super(project, "Waiting for adb", true);
            this.myFuture = future2;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            indicator.setIndeterminate(true);
            while (!this.myFuture.isDone()) {
                try {
                    this.myFuture.get(200L, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!indicator.isCanceled()) continue;
                return;
            }
        }

        public void onCancel() {
            this.myCancelled = true;
        }

        public boolean wasCanceled() {
            return this.myCancelled;
        }
    }

    public static class AdbSearchResult {
        @Nullable
        public final File adbPath;
        @NotNull
        public final List<String> searchedPaths;

        public AdbSearchResult(@Nullable Path adbPath, @NotNull List<String> searchedPaths) {
            this.adbPath = adbPath == null ? null : adbPath.toFile();
            this.searchedPaths = searchedPaths;
        }
    }
}

