/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkNotConfiguredNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.sdk.not.configured.notification");
    private final Project myProject;
    private final EditorNotifications myNotifications;

    public AndroidSdkNotConfiguredNotificationProvider(Project project) {
        this.myProject = project;
        this.myNotifications = EditorNotifications.getInstance((Project)project);
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        AndroidPlatform platform;
        AndroidFacet facet2;
        if (!FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)XmlFileType.INSTANCE)) {
            return null;
        }
        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.myProject);
        AndroidFacet androidFacet = facet2 = module2 != null ? AndroidFacet.getInstance((Module)module2) : null;
        if (facet2 == null) {
            return null;
        }
        if (!AndroidModel.isRequired(facet2) && (IdeResourcesUtil.isResourceFile(file2, facet2) || file2.equals(AndroidRootUtil.getPrimaryManifestFile(facet2))) && (platform = AndroidPlatform.getInstance(module2)) == null) {
            return new MySdkNotConfiguredNotificationPanel(fileEditor, module2);
        }
        return null;
    }

    private class MySdkNotConfiguredNotificationPanel
    extends EditorNotificationPanel {
        MySdkNotConfiguredNotificationPanel(@NotNull FileEditor fileEditor, final Module module2) {
            super(fileEditor);
            this.setText("Android SDK is not configured for module '" + module2.getName() + "' or corrupted");
            this.createActionLabel("Open Project Structure", new Runnable(){

                @Override
                public void run() {
                    ModulesConfigurator.showDialog((Project)module2.getProject(), (String)module2.getName(), (String)ClasspathEditor.getName());
                    AndroidSdkNotConfiguredNotificationProvider.this.myNotifications.updateAllNotifications();
                }
            });
        }
    }
}

