/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPlatform {
    @NotNull
    private final AndroidSdkData mySdkData;
    @NotNull
    private final IAndroidTarget myTarget;

    public AndroidPlatform(@NotNull AndroidSdkData sdkData, @NotNull IAndroidTarget target2) {
        this.mySdkData = sdkData;
        this.myTarget = target2;
    }

    @Nullable
    public static AndroidPlatform getInstance(@NotNull Module module2) {
        if (module2.isDisposed()) {
            return null;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
        return sdk != null ? AndroidPlatform.getInstance(sdk) : null;
    }

    @Nullable
    public static AndroidPlatform getInstance(@NotNull Sdk sdk) {
        AndroidSdkAdditionalData data2 = AndroidSdks.getInstance().getAndroidSdkAdditionalData(sdk);
        return data2 != null ? data2.getAndroidPlatform() : null;
    }

    @NotNull
    public AndroidSdkData getSdkData() {
        return this.mySdkData;
    }

    @NotNull
    public IAndroidTarget getTarget() {
        return this.myTarget;
    }

    @Nullable
    public static AndroidPlatform parse(@NotNull Sdk sdk) {
        IAndroidTarget target2;
        SdkAdditionalData data2;
        if (!AndroidSdks.getInstance().isAndroidSdk(sdk)) {
            return null;
        }
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
        if (sdkData != null && (data2 = sdk.getSdkAdditionalData()) instanceof AndroidSdkAdditionalData && (target2 = ((AndroidSdkAdditionalData)data2).getBuildTarget(sdkData)) != null) {
            return new AndroidPlatform(sdkData, target2);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static AndroidPlatform parse(@NotNull Library library, @Nullable Library.ModifiableModel model2, @Nullable Map<String, AndroidSdkData> parsedSdks) {
        VirtualFile sdkDir;
        VirtualFile[] files2 = model2 != null ? model2.getFiles(OrderRootType.CLASSES) : library.getFiles(OrderRootType.CLASSES);
        HashSet jarPaths = Sets.newHashSet();
        VirtualFile frameworkLibrary = null;
        for (VirtualFile file2 : files2) {
            VirtualFile vFile = JarFileSystem.getInstance().getVirtualFileForJar(file2);
            if (vFile == null) continue;
            if (vFile.getName().equals("android.jar")) {
                frameworkLibrary = vFile;
            }
            jarPaths.add(vFile.getPath());
        }
        if (frameworkLibrary != null && (sdkDir = frameworkLibrary.getParent()) != null) {
            AndroidSdkData sdkData;
            VirtualFile platformsDir = sdkDir.getParent();
            if (platformsDir != null && platformsDir.getName().equals("platforms") && (sdkDir = platformsDir.getParent()) == null) {
                return null;
            }
            String sdkPath = sdkDir.getPath();
            AndroidSdkData androidSdkData = sdkData = parsedSdks != null ? parsedSdks.get(sdkPath) : null;
            if (sdkData == null) {
                sdkData = AndroidSdkData.getSdkData(sdkPath);
                if (sdkData == null) {
                    return null;
                }
                if (parsedSdks != null) {
                    parsedSdks.put(sdkPath, sdkData);
                }
            }
            IAndroidTarget resultTarget = null;
            for (IAndroidTarget target2 : sdkData.getTargets()) {
                String targetsFrameworkLibPath = target2.getPath(1).normalize().toString();
                if (!frameworkLibrary.getPath().equals(targetsFrameworkLibPath)) continue;
                if (target2.isPlatform()) {
                    if (resultTarget != null) continue;
                    resultTarget = target2;
                    continue;
                }
                boolean ok = true;
                List libraries2 = target2.getAdditionalLibraries();
                if (libraries2.isEmpty()) {
                    ok = false;
                } else {
                    for (OptionalLibrary optionalLibrary : libraries2) {
                        if (jarPaths.contains(PathUtil.getCanonicalPath((String)optionalLibrary.getJar().toAbsolutePath().toString()))) continue;
                        ok = false;
                    }
                }
                if (!ok) continue;
                resultTarget = target2;
            }
            if (resultTarget != null) {
                return new AndroidPlatform(sdkData, resultTarget);
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidPlatform platform = (AndroidPlatform)o;
        if (!this.mySdkData.equals(platform.mySdkData)) {
            return false;
        }
        return this.myTarget.equals(platform.myTarget);
    }

    public int hashCode() {
        int result2 = this.mySdkData.hashCode();
        result2 = 31 * result2 + this.myTarget.hashCode();
        return result2;
    }

    public boolean needToAddAnnotationsJarToClasspath() {
        return AndroidSdks.getInstance().needsAnnotationsJarInClasspath(this.myTarget);
    }

    public int getApiLevel() {
        return this.myTarget.getVersion().getApiLevel();
    }

    @NotNull
    public AndroidVersion getApiVersion() {
        return this.myTarget.getVersion();
    }
}

