/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceFolderType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceManager {
    protected final Project myProject;

    protected ResourceManager(@NotNull Project project) {
        this.myProject = project;
    }

    public abstract boolean isResourceDir(@NotNull VirtualFile var1);

    @Nullable
    public abstract AttributeDefinitions getAttributeDefinitions();

    @Nullable
    public ResourceFolderType getFileResourceFolderType(@NotNull PsiFile file2) {
        return (ResourceFolderType)ApplicationManager.getApplication().runReadAction(() -> {
            PsiDirectory dir = file2.getContainingDirectory();
            if (dir == null) {
                return null;
            }
            PsiDirectory possibleResDir = dir.getParentDirectory();
            if (possibleResDir == null || !this.isResourceDir(possibleResDir.getVirtualFile())) {
                return null;
            }
            return ResourceFolderType.getFolderType((String)dir.getName());
        });
    }

    @Nullable
    public String getFileResourceType(@NotNull PsiFile file2) {
        ResourceFolderType folderType = this.getFileResourceFolderType(file2);
        return folderType == null ? null : folderType.getName();
    }

    @NotNull
    protected abstract Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories();
}

