/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalResourceManager
extends ResourceManager {
    private final AndroidFacet myFacet;
    private final Object myAttrDefsLock = new Object();
    private AttributeDefinitions myAttrDefs;

    @Nullable
    public static LocalResourceManager getInstance(@NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        return facet2 != null ? ModuleResourceManagers.getInstance(facet2).getLocalResourceManager() : null;
    }

    @Nullable
    public static LocalResourceManager getInstance(@NotNull PsiElement element2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)element2);
        return facet2 != null ? ModuleResourceManagers.getInstance(facet2).getLocalResourceManager() : null;
    }

    public LocalResourceManager(@NotNull AndroidFacet facet2) {
        super(facet2.getModule().getProject());
        this.myFacet = facet2;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        for (VirtualFile resDir : ResourceFolderManager.getInstance(this.myFacet).getFolders()) {
            if (!dir.equals(resDir)) continue;
            return true;
        }
        for (VirtualFile resDir : AndroidRootUtil.getResourceOverlayDirs(this.myFacet)) {
            if (!dir.equals(resDir)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public AttributeDefinitions getAttributeDefinitions() {
        Object object = this.myAttrDefsLock;
        synchronized (object) {
            if (this.myAttrDefs == null) {
                FrameworkResourceManager frameworkResourceManager = ModuleResourceManagers.getInstance(this.myFacet).getFrameworkResourceManager();
                AttributeDefinitions frameworkAttributes = frameworkResourceManager == null ? null : ((ResourceManager)frameworkResourceManager).getAttributeDefinitions();
                this.myAttrDefs = AttributeDefinitionsImpl.create(frameworkAttributes, this.getResourceRepository());
            }
            return this.myAttrDefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAttributeDefinitions() {
        Object object = this.myAttrDefsLock;
        synchronized (object) {
            this.myAttrDefs = null;
        }
    }

    @NotNull
    public Collection<PsiFile> findResourceFiles(@NotNull ResourceNamespace namespace, @NotNull ResourceFolderType resourceFolderType) {
        return this.findResourceFiles(namespace, resourceFolderType, null, true, true);
    }

    @NotNull
    public Collection<PsiFile> findResourceFiles(@NotNull ResourceNamespace namespace, @NotNull ResourceFolderType resourceFolderType, @Nullable String nameToLookFor, boolean distinguishDelimitersInName, boolean withDependencies) {
        LinkedHashSet<PsiFile> result2 = new LinkedHashSet<PsiFile>();
        LocalResourceRepository repository2 = withDependencies ? ResourceRepositoryManager.getAppResources(this.myFacet) : ResourceRepositoryManager.getModuleResources(this.myFacet);
        Collection repositories = repository2.getLeafResourceRepositories();
        if (resourceFolderType == ResourceFolderType.VALUES) {
            for (ResourceType resourceType : FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)resourceFolderType)) {
                this.findResourceFiles(repositories, namespace, resourceType, resourceFolderType, nameToLookFor, distinguishDelimitersInName, result2);
            }
        } else {
            ResourceType resourceType = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)resourceFolderType);
            this.findResourceFiles(repositories, namespace, resourceType, resourceFolderType, nameToLookFor, distinguishDelimitersInName, result2);
        }
        return result2;
    }

    private void findResourceFiles(@NotNull Collection<SingleNamespaceResourceRepository> repositories, @NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull ResourceFolderType resourceFolderType, @Nullable String nameToLookFor, boolean distinguishDelimitersInName, @NotNull Set<PsiFile> result2) {
        for (ResourceRepository resourceRepository : repositories) {
            List items2;
            if (nameToLookFor == null) {
                Collection items22 = resourceRepository.getResources(namespace, resourceType).values();
            } else {
                items2 = distinguishDelimitersInName ? resourceRepository.getResources(namespace, resourceType, nameToLookFor) : resourceRepository.getResources(namespace, resourceType, item2 -> AndroidUtils.equal(nameToLookFor, item2.getName(), false));
            }
            for (ResourceItem item3 : items2) {
                PsiFile file2;
                VirtualFile resFile = IdeResourcesUtil.getSourceAsVirtualFile(item3);
                if (resFile == null || ResourceFolderType.getFolderType((String)resFile.getParent().getName()) != resourceFolderType || (file2 = AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, (VirtualFile)resFile)) == null) continue;
                result2.add(file2);
            }
        }
    }

    @Override
    @NotNull
    protected Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
        return this.getResourceRepository().getLeafResourceRepositories();
    }

    @NotNull
    private ResourceRepository getResourceRepository() {
        return ResourceRepositoryManager.getAppResources(this.myFacet);
    }
}

