/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring.namespaces;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.namespaces.MigrateToResourceNamespacesHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\b\u0010\u000b\u001a\u00020\bH\u0014J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u001b\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u0015\u001a\u00020\bH\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/android/refactoring/namespaces/MigrateToResourceNamespacesAction;", "Lcom/intellij/refactoring/actions/BaseRefactoringAction;", "()V", "getHandler", "Lorg/jetbrains/android/refactoring/namespaces/MigrateToResourceNamespacesHandler;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isAvailableForLanguage", "", "language", "Lcom/intellij/lang/Language;", "isAvailableInEditorOnly", "isEnabledOnDataContext", "isEnabledOnElements", "elements", "", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/psi/PsiElement;)Z", "isEnabledOnModule", "module", "Lcom/intellij/openapi/module/Module;", "isHidden", "intellij.android.projectSystem.gradle"})
public final class MigrateToResourceNamespacesAction
extends BaseRefactoringAction {
    @NotNull
    protected MigrateToResourceNamespacesHandler getHandler(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return new MigrateToResourceNamespacesHandler();
    }

    protected boolean isHidden() {
        return (Boolean)StudioFlags.MIGRATE_TO_RESOURCE_NAMESPACES_REFACTORING_ENABLED.get() == false;
    }

    protected boolean isAvailableInEditorOnly() {
        return false;
    }

    protected boolean isAvailableForLanguage(@Nullable Language language) {
        return true;
    }

    protected boolean isEnabledOnDataContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.isEnabledOnModule(AndroidRefactoringUtil.getModule(dataContext));
    }

    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        return this.isEnabledOnModule(ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)ArraysKt.first((Object[])elements))));
    }

    private final boolean isEnabledOnModule(Module module2) {
        Module module3 = module2;
        if (module3 == null) {
            return false;
        }
        ResourceRepositoryManager resourceRepositoryManager = ResourceRepositoryManager.getInstance(module3);
        return (resourceRepositoryManager != null ? resourceRepositoryManager.getNamespacing() : null) == Namespacing.DISABLED;
    }
}

