/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring.namespaces;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvokerKt;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.google.wireless.android.sdk.stats.NonTransitiveRClassMigrationEvent;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.UsageView;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.AndroidRefactoringUtilKt;
import org.jetbrains.android.refactoring.namespaces.CodeUsageInfo;
import org.jetbrains.android.refactoring.namespaces.MigrateToNonTransitiveRClassesKt;
import org.jetbrains.android.refactoring.namespaces.MigrateToNonTransitiveRClassesProcessor;
import org.jetbrains.android.refactoring.namespaces.NamespacesRefactoringsUtilKt;
import org.jetbrains.android.refactoring.namespaces.PropertiesUsageInfo;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0001*B-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\bH\u0002J\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\rH\u0014J\u001d\u0010\"\u001a\u00020\u001a2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013H\u0014\u00a2\u0006\u0002\u0010#J\u001d\u0010$\u001a\u00020\u001a2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013H\u0014\u00a2\u0006\u0002\u0010#J!\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010(H\u0002\u00a2\u0006\u0002\u0010)R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006+"}, d2={"Lorg/jetbrains/android/refactoring/namespaces/MigrateToNonTransitiveRClassesProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "facetsToMigrate", "", "Lorg/jetbrains/android/facet/AndroidFacet;", "updateTopLevelGradleProperties", "", "agpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;ZLcom/android/ide/common/repository/AgpVersion;)V", "uuid", "", "getUuid", "()Ljava/lang/String;", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "createWarningLabel", "Lcom/intellij/ui/components/JBLabel;", "message", "customizeUsagesView", "", "viewDescriptor", "usageView", "Lcom/intellij/usages/UsageView;", "doesProjectHaveUncommittedChanges", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "getCommandName", "performRefactoring", "([Lcom/intellij/usageView/UsageInfo;)V", "previewRefactoring", "trackProcessorUsage", "kind", "Lcom/google/wireless/android/sdk/stats/NonTransitiveRClassMigrationEvent$NonTransitiveRClassMigrationEventKind;", "", "(Lcom/google/wireless/android/sdk/stats/NonTransitiveRClassMigrationEvent$NonTransitiveRClassMigrationEventKind;Ljava/lang/Integer;)V", "Companion", "intellij.android.projectSystem.gradle"})
public final class MigrateToNonTransitiveRClassesProcessor
extends BaseRefactoringProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<AndroidFacet> facetsToMigrate;
    private final boolean updateTopLevelGradleProperties;
    @NotNull
    private final AgpVersion agpVersion;
    @NotNull
    private final String uuid;
    @NotNull
    private static final AgpVersion AGP_NON_TRANSITIVE_ENABLED_BY_DEFAULT = AgpVersion.Companion.parse("8.0.0-alpha08");
    @NotNull
    private static final AgpVersion AGP_NON_TRANSITIVE_V2 = AgpVersion.Companion.parse("7.0.0-alpha01");
    @NotNull
    private static final AgpVersion AGP_NON_TRANSITIVE_V1 = AgpVersion.Companion.parse("4.2.0-alpha01");
    @NotNull
    private static final Logger LOG;

    private MigrateToNonTransitiveRClassesProcessor(Project project, Collection<? extends AndroidFacet> facetsToMigrate, boolean updateTopLevelGradleProperties, AgpVersion agpVersion) {
        super(project);
        this.facetsToMigrate = facetsToMigrate;
        this.updateTopLevelGradleProperties = updateTopLevelGradleProperties;
        this.agpVersion = agpVersion;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.uuid = string;
    }

    @NotNull
    public final String getUuid() {
        return this.uuid;
    }

    @NotNull
    protected String getCommandName() {
        String string = AndroidBundle.message("android.refactoring.migrateto.nontransitiverclass.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.refacto\u2026ntransitiverclass.title\")");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public UsageInfo[] findUsages() {
        void $this$flatMapTo$iv$iv;
        ProgressIndicator progressIndicator;
        ProgressIndicator progressIndicator2 = progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator2 != null) {
            progressIndicator2.setIndeterminate(true);
        }
        ProgressIndicator progressIndicator3 = progressIndicator;
        if (progressIndicator3 != null) {
            progressIndicator3.setText(AndroidBundle.message("android.refactoring.migrateto.nontransitiverclass.progress.findusages", new Object[0]));
        }
        Iterable $this$flatMap$iv = this.facetsToMigrate;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            AndroidFacet p0 = (AndroidFacet)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = NamespacesRefactoringsUtilKt.findUsagesOfRClassesFromModule(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List usages = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        ProgressIndicator progressIndicator4 = progressIndicator;
        if (progressIndicator4 != null) {
            progressIndicator4.setText(AndroidBundle.message("android.refactoring.migrateto.nontransitiverclass.progress.inferring", new Object[0]));
        }
        NamespacesRefactoringsUtilKt.inferPackageNames(usages, progressIndicator);
        ProgressIndicator progressIndicator5 = progressIndicator;
        if (progressIndicator5 != null) {
            progressIndicator5.setText(null);
        }
        this.trackProcessorUsage(NonTransitiveRClassMigrationEvent.NonTransitiveRClassMigrationEventKind.FIND_USAGES, usages.size());
        if (this.updateTopLevelGradleProperties) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            PropertiesFile propertiesFile = AndroidRefactoringUtil.getProjectProperties(project, false);
            if (propertiesFile != null) {
                Collection $this$toTypedArray$iv = usages;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Object[] objectArray = thisCollection$iv.toArray(new UsageInfo[0]);
                if (objectArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                PsiFile psiFile = propertiesFile.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"propertiesFile.containingFile");
                return (UsageInfo[])ArraysKt.plus((Object[])objectArray, (Object)((Object)new PropertiesUsageInfo("android.nonTransitiveRClass", (PsiElement)psiFile)));
            }
        }
        Collection $this$toTypedArray$iv = usages;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        UsageInfo[] usageInfoArray = thisCollection$iv.toArray(new UsageInfo[0]);
        if (usageInfoArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return usageInfoArray;
    }

    protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
        Intrinsics.checkNotNullParameter((Object)viewDescriptor, (String)"viewDescriptor");
        Intrinsics.checkNotNullParameter((Object)usageView, (String)"usageView");
        boolean shouldRecommendPluginUpgrade = this.agpVersion.compareTo(AGP_NON_TRANSITIVE_V1) >= 0 && this.agpVersion.compareTo(AGP_NON_TRANSITIVE_V2) < 0;
        boolean hasUncommittedChanges = this.doesProjectHaveUncommittedChanges();
        if (hasUncommittedChanges || shouldRecommendPluginUpgrade) {
            JBPanel panel2 = new JBPanel((LayoutManager)new VerticalLayout(5));
            panel2.setBorder(JBUI.Borders.empty((int)5));
            if (shouldRecommendPluginUpgrade) {
                String string = AndroidBundle.message("android.refactoring.migrateto.nontransitiverclass.warning.recommend.upgrade", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.refacto\u2026rning.recommend.upgrade\")");
                panel2.add((Component)this.createWarningLabel(string));
            }
            if (hasUncommittedChanges) {
                String string = AndroidBundle.message("android.refactoring.migrateto.nontransitiverclass.warning.uncommitted.changes", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.refacto\u2026ing.uncommitted.changes\")");
                panel2.add((Component)this.createWarningLabel(string));
            }
            usageView.setAdditionalComponent((JComponent)panel2);
        }
        super.customizeUsagesView(viewDescriptor, usageView);
    }

    private final JBLabel createWarningLabel(String message2) {
        JBLabel jBLabel;
        JBLabel $this$createWarningLabel_u24lambda_u2d0 = jBLabel = new JBLabel();
        boolean bl = false;
        $this$createWarningLabel_u24lambda_u2d0.setIcon(StudioIcons.Common.WARNING);
        $this$createWarningLabel_u24lambda_u2d0.setText(message2);
        return jBLabel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean doesProjectHaveUncommittedChanges() {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(myProject)");
        ChangeListManager changeListManager2 = changeListManager;
        if (!changeListManager2.areChangeListsEnabled()) return false;
        Collection collection2 = changeListManager2.getAllChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"changeListManager.allChanges");
        if (collection2.isEmpty()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        this.trackProcessorUsage(NonTransitiveRClassMigrationEvent.NonTransitiveRClassMigrationEventKind.EXECUTE, usages.length);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        progressIndicator.setIndeterminate(false);
        progressIndicator.setFraction(0.0);
        progressIndicator.setText(AndroidBundle.message("android.refactoring.migrateto.nontransitiverclass.progress.rewriting", new Object[0]));
        double totalUsages = usages.length;
        PsiMigration psiMigration = PsiMigrationManager.getInstance((Project)this.myProject).startMigration();
        Intrinsics.checkNotNullExpressionValue((Object)psiMigration, (String)"getInstance(myProject).startMigration()");
        PsiMigration psiMigration2 = psiMigration;
        try {
            UsageInfo[] $this$forEachIndexed$iv = usages;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (UsageInfo item$iv : $this$forEachIndexed$iv) {
                void usageInfo;
                int n = index$iv++;
                UsageInfo usageInfo2 = item$iv;
                int index2 = n;
                boolean bl = false;
                if (usageInfo instanceof CodeUsageInfo) {
                    ((CodeUsageInfo)usageInfo).updateClassReference(psiMigration2);
                }
                progressIndicator.setFraction((double)(index2 + 1) / totalUsages);
            }
        }
        finally {
            psiMigration2.finish();
        }
        if (this.updateTopLevelGradleProperties) {
            boolean onByDefault = this.agpVersion.compareTo(AGP_NON_TRANSITIVE_ENABLED_BY_DEFAULT) >= 0;
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            PropertiesFile propertiesFile = AndroidRefactoringUtil.getProjectProperties(project, !onByDefault);
            if (propertiesFile != null) {
                if (onByDefault) {
                    IProperty iProperty = propertiesFile.findPropertyByKey("android.nonTransitiveRClass");
                    if (iProperty != null) {
                        iProperty.setValue("true");
                    }
                } else if (this.agpVersion.compareTo(AGP_NON_TRANSITIVE_V2) >= 0) {
                    Unit unit;
                    IProperty iProperty = propertiesFile.findPropertyByKey("android.nonTransitiveRClass");
                    if (iProperty != null) {
                        iProperty.setValue("true");
                        unit = Unit.INSTANCE;
                    } else {
                        IProperty iProperty2 = propertiesFile.addProperty("android.nonTransitiveRClass", "true");
                        unit = iProperty2;
                        Intrinsics.checkNotNullExpressionValue((Object)iProperty2, (String)"propertiesFile.addProper\u2026CLASSES_PROPERTY, \"true\")");
                    }
                } else if (this.agpVersion.compareTo(AGP_NON_TRANSITIVE_V1) >= 0) {
                    Unit unit;
                    Unit unit2;
                    IProperty iProperty = propertiesFile.findPropertyByKey("android.nonTransitiveRClass");
                    if (iProperty != null) {
                        iProperty.setValue("true");
                        unit2 = Unit.INSTANCE;
                    } else {
                        IProperty iProperty3 = propertiesFile.addProperty("android.nonTransitiveRClass", "true");
                        unit2 = iProperty3;
                        Intrinsics.checkNotNullExpressionValue((Object)iProperty3, (String)"propertiesFile.addProper\u2026CLASSES_PROPERTY, \"true\")");
                    }
                    IProperty iProperty4 = propertiesFile.findPropertyByKey("android.experimental.nonTransitiveAppRClass");
                    if (iProperty4 != null) {
                        iProperty4.setValue("true");
                        unit = Unit.INSTANCE;
                    } else {
                        IProperty iProperty5 = propertiesFile.addProperty("android.experimental.nonTransitiveAppRClass", "true");
                        unit = iProperty5;
                        Intrinsics.checkNotNullExpressionValue((Object)iProperty5, (String)"propertiesFile.addProper\u2026CLASSES_PROPERTY, \"true\")");
                    }
                } else {
                    LOG.error("AGP version too low for MigrateToNonTransitiveRClasses: " + this.agpVersion);
                }
            }
            GradleSyncListener listener2 = new GradleSyncListener(this){
                final /* synthetic */ MigrateToNonTransitiveRClassesProcessor this$0;
                {
                    this.this$0 = $receiver;
                }

                public void syncSkipped(@NotNull Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    MigrateToNonTransitiveRClassesProcessor.trackProcessorUsage$default(this.this$0, NonTransitiveRClassMigrationEvent.NonTransitiveRClassMigrationEventKind.SYNC_SKIPPED, null, 2, null);
                }

                public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                    MigrateToNonTransitiveRClassesProcessor.trackProcessorUsage$default(this.this$0, NonTransitiveRClassMigrationEvent.NonTransitiveRClassMigrationEventKind.SYNC_FAILED, null, 2, null);
                }

                public void syncSucceeded(@NotNull Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    MigrateToNonTransitiveRClassesProcessor.trackProcessorUsage$default(this.this$0, NonTransitiveRClassMigrationEvent.NonTransitiveRClassMigrationEventKind.SYNC_SUCCEEDED, null, 2, null);
                }
            };
            Project project2 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
            AndroidRefactoringUtilKt.syncBeforeFinishingRefactoring(project2, GradleSyncStats.Trigger.TRIGGER_REFACTOR_MIGRATE_TO_RESOURCE_NAMESPACES, listener2);
            UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)new BasicUndoableAction(this, listener2){
                final /* synthetic */ MigrateToNonTransitiveRClassesProcessor this$0;
                final /* synthetic */ performRefactoring.listener.1 $listener;
                {
                    this.this$0 = $receiver;
                    this.$listener = $listener;
                }

                public void undo() {
                    GradleSyncInvoker gradleSyncInvoker = GradleSyncInvoker.Companion.getInstance();
                    Project project = MigrateToNonTransitiveRClassesProcessor.access$getMyProject$p$s-254338062(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                    GradleSyncInvokerKt.requestProjectSync(gradleSyncInvoker, project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_UNDONE, this.$listener);
                }

                public void redo() {
                    GradleSyncInvoker gradleSyncInvoker = GradleSyncInvoker.Companion.getInstance();
                    Project project = MigrateToNonTransitiveRClassesProcessor.access$getMyProject$p$s-254338062(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                    GradleSyncInvokerKt.requestProjectSync(gradleSyncInvoker, project, GradleSyncStats.Trigger.TRIGGER_MODIFIER_ACTION_REDONE, this.$listener);
                }
            });
        }
    }

    protected void previewRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        this.trackProcessorUsage(NonTransitiveRClassMigrationEvent.NonTransitiveRClassMigrationEventKind.PREVIEW_REFACTORING, usages.length);
        super.previewRefactoring(usages);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return (UsageViewDescriptor)new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return AndroidBundle.message("android.refactoring.migrateto.resourceview.header", new Object[0]);
            }
        };
    }

    private final void trackProcessorUsage(NonTransitiveRClassMigrationEvent.NonTransitiveRClassMigrationEventKind kind, Integer usages) {
        NonTransitiveRClassMigrationEvent.Builder builder2;
        NonTransitiveRClassMigrationEvent.Builder $this$trackProcessorUsage_u24lambda_u2d3 = builder2 = NonTransitiveRClassMigrationEvent.newBuilder().setMigrationUuid(this.uuid).setKind(kind);
        boolean bl = false;
        Integer n = usages;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$trackProcessorUsage_u24lambda_u2d3.setUsages(it);
        }
        NonTransitiveRClassMigrationEvent.Builder processorEvent = builder2;
        AndroidStudioEvent.Builder builder3 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.MIGRATE_TO_NON_TRANSITIVE_R_CLASS);
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"newBuilder()\n      .setK\u2026O_NON_TRANSITIVE_R_CLASS)");
        AndroidStudioEvent.Builder studioEvent = UsageTrackerUtils.withProjectId(builder3, this.myProject).setNonTransitiveRClassMigrationEvent(processorEvent.build());
        Intrinsics.checkNotNullExpressionValue((Object)studioEvent, (String)"studioEvent");
        UsageTracker.log((AndroidStudioEvent.Builder)studioEvent);
    }

    static /* synthetic */ void trackProcessorUsage$default(MigrateToNonTransitiveRClassesProcessor migrateToNonTransitiveRClassesProcessor, NonTransitiveRClassMigrationEvent.NonTransitiveRClassMigrationEventKind nonTransitiveRClassMigrationEventKind, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        migrateToNonTransitiveRClassesProcessor.trackProcessorUsage(nonTransitiveRClassMigrationEventKind, n);
    }

    public /* synthetic */ MigrateToNonTransitiveRClassesProcessor(Project project, Collection facetsToMigrate, boolean updateTopLevelGradleProperties, AgpVersion agpVersion, DefaultConstructorMarker $constructor_marker) {
        this(project, facetsToMigrate, updateTopLevelGradleProperties, agpVersion);
    }

    public static final /* synthetic */ Project access$getMyProject$p$s-254338062(MigrateToNonTransitiveRClassesProcessor $this) {
        return $this.myProject;
    }

    static {
        Logger logger2 = Logger.getInstance(BaseRefactoringProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(BaseRefactoringProcessor::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/android/refactoring/namespaces/MigrateToNonTransitiveRClassesProcessor$Companion;", "", "()V", "AGP_NON_TRANSITIVE_ENABLED_BY_DEFAULT", "Lcom/android/ide/common/repository/AgpVersion;", "AGP_NON_TRANSITIVE_V1", "AGP_NON_TRANSITIVE_V2", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "forEntireProject", "Lorg/jetbrains/android/refactoring/namespaces/MigrateToNonTransitiveRClassesProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "agpVersion", "forSingleModule", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MigrateToNonTransitiveRClassesProcessor forSingleModule(@NotNull AndroidFacet facet2, @NotNull AgpVersion agpVersion) {
            Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
            Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
            Project project = facet2.getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"facet.module.project");
            return new MigrateToNonTransitiveRClassesProcessor(project, SetsKt.setOf((Object)facet2), false, agpVersion, null);
        }

        @NotNull
        public final MigrateToNonTransitiveRClassesProcessor forEntireProject(@NotNull Project project, @NotNull AgpVersion agpVersion) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
            return new MigrateToNonTransitiveRClassesProcessor(project, MigrateToNonTransitiveRClassesKt.access$findFacetsToMigrate(project), true, agpVersion, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

