/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring.namespaces;

import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.namespaces.ResourceUsageInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.codeInsight.KotlinOptimizeImportsRefactoringHelper;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/android/refactoring/namespaces/CodeUsageInfo;", "Lorg/jetbrains/android/refactoring/namespaces/ResourceUsageInfo;", "fieldReferenceExpression", "Lcom/intellij/psi/PsiElement;", "classReference", "Lcom/intellij/psi/PsiReference;", "resourceType", "Lcom/android/resources/ResourceType;", "name", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiReference;Lcom/android/resources/ResourceType;Ljava/lang/String;)V", "getClassReference", "()Lcom/intellij/psi/PsiReference;", "getName", "()Ljava/lang/String;", "getResourceType", "()Lcom/android/resources/ResourceType;", "getFile", "Lcom/intellij/psi/PsiFile;", "isKotlinOptimizerCall", "", "updateClassReference", "", "psiMigration", "Lcom/intellij/psi/PsiMigration;", "intellij.android.projectSystem.gradle"})
public final class CodeUsageInfo
extends ResourceUsageInfo {
    @NotNull
    private final PsiReference classReference;
    @NotNull
    private final ResourceType resourceType;
    @NotNull
    private final String name;

    public CodeUsageInfo(@NotNull PsiElement fieldReferenceExpression, @NotNull PsiReference classReference, @NotNull ResourceType resourceType, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)fieldReferenceExpression, (String)"fieldReferenceExpression");
        Intrinsics.checkNotNullParameter((Object)classReference, (String)"classReference");
        Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(fieldReferenceExpression);
        this.classReference = classReference;
        this.resourceType = resourceType;
        this.name = name;
    }

    @NotNull
    public final PsiReference getClassReference() {
        return this.classReference;
    }

    @Override
    @NotNull
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public final void updateClassReference(@NotNull PsiMigration psiMigration) {
        Intrinsics.checkNotNullParameter((Object)psiMigration, (String)"psiMigration");
        PsiReference reference = this.classReference;
        Project project = this.classReference.getElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"classReference.element.project");
        String string = this.getInferredPackage();
        if (string == null) {
            return;
        }
        String string2 = IdeResourcesUtil.packageToRClass(string);
        GlobalSearchScope globalSearchScope = reference.getElement().getResolveScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"reference.element.resolveScope");
        PsiClass newRClass = AndroidRefactoringUtil.findOrCreateClass(project, psiMigration, string2, globalSearchScope);
        if (reference instanceof KtSimpleNameReference) {
            ((KtSimpleNameReference)reference).bindToElement((PsiElement)newRClass, KtSimpleNameReference.ShorteningMode.NO_SHORTENING);
        } else {
            reference.bindToElement((PsiElement)newRClass);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isKotlinOptimizerCall() {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"currentThread().stackTrace");
            Iterable $this$map$iv = ArraysKt.take((Object[])stackTraceElementArray, (int)5);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(it.getClassName());
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(KotlinOptimizeImportsRefactoringHelper.class).getQualifiedName(), (Object)it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public PsiFile getFile() {
        return this.classReference.getElement().getLanguage() instanceof KotlinLanguage && this.isKotlinOptimizerCall() ? (PsiFile)null : super.getFile();
    }
}

