/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleModelProvider;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.android.FlavorTypeModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.lint.common.LintBatchResult;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeRequest;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.refactoring.UnusedResourcesUsageViewDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class UnusedResourcesProcessor
extends BaseRefactoringProcessor {
    private final String myFilter;
    private final Module[] myModules;
    private PsiElement[] myElements = PsiElement.EMPTY_ARRAY;
    private boolean myIncludeIds;
    private String myCachedCommandName = null;
    private final Map<PsiElement, GradleBuildModel> myBuildModelMap;

    public UnusedResourcesProcessor(@NotNull Project project, @NotNull Module[] modules2, @Nullable String filter2) {
        super(project, null);
        this.myModules = modules2;
        this.myFilter = filter2;
        this.myBuildModelMap = new HashMap<PsiElement, GradleBuildModel>();
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull @NotNull UsageInfo @NotNull [] usages) {
        return new UnusedResourcesUsageViewDescriptor(this.myElements);
    }

    @NotNull
    protected @NotNull UsageInfo @NotNull [] findUsages() {
        Map<Issue, Map<File, List<LintProblemData>>> map2 = this.computeUnusedMap();
        List<PsiElement> elements = this.computeUnusedDeclarationElements(map2);
        this.myElements = elements.toArray(PsiElement.EMPTY_ARRAY);
        UsageInfo[] result2 = new UsageInfo[this.myElements.length];
        int n = this.myElements.length;
        for (int i = 0; i < n; ++i) {
            result2[i] = new UsageInfo(this.myElements[i]);
        }
        return UsageViewUtil.removeDuplicatedUsages((UsageInfo[])result2);
    }

    @NotNull
    private List<PsiElement> computeUnusedDeclarationElements(Map<Issue, Map<File, List<LintProblemData>>> map2) {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (Issue issue2 : Lists.newArrayList(map2.keySet())) {
            if (issue2 == UnusedResourceDetector.ISSUE || issue2 == UnusedResourceDetector.ISSUE_IDS) continue;
            map2.remove(issue2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        HashMap files2 = Maps.newHashMap();
        HashSet<PsiFile> excludedFiles = new HashSet<PsiFile>();
        for (Map.Entry<Issue, Map<File, List<LintProblemData>>> entry : map2.entrySet()) {
            for (File file2 : entry.getValue().keySet()) {
                PsiFile psiFile;
                Object virtualFile;
                if (files2.containsKey(file2) || (virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file2)) == null || virtualFile.isDirectory() || (psiFile = manager.findFile((VirtualFile)virtualFile)) == null) continue;
                files2.put(file2, psiFile);
                Module module2 = ModuleUtilCore.findModuleForFile((PsiFile)psiFile);
                if (module2 == null || ArrayUtil.find((Object[])this.myModules, (Object)module2) != -1) continue;
                excludedFiles.add(psiFile);
            }
        }
        HashSet<String> excludedResources = new HashSet<String>();
        if (!excludedFiles.isEmpty()) {
            for (Map.Entry<Issue, Map<File, List<LintProblemData>>> entry : map2.entrySet()) {
                Map<File, List<LintProblemData>> fileMap = entry.getValue();
                for (File file3 : fileMap.keySet()) {
                    List<LintProblemData> list2;
                    PsiFile psiFile = (PsiFile)files2.get(file3);
                    if (!excludedFiles.contains(psiFile) || (list2 = fileMap.get(file3)) == null) continue;
                    for (LintProblemData problem : list2) {
                        String resource = UnusedResourcesProcessor.getResource(problem);
                        if (resource == null) continue;
                        excludedResources.add(resource);
                    }
                }
            }
        }
        for (Issue issue3 : new Issue[]{UnusedResourceDetector.ISSUE, UnusedResourceDetector.ISSUE_IDS}) {
            Map<File, List<LintProblemData>> fileListMap = map2.get(issue3);
            if (fileListMap == null || fileListMap.isEmpty() || files2.isEmpty()) continue;
            for (File file4 : files2.keySet()) {
                List<LintProblemData> problems;
                PsiFile psiFile = (PsiFile)files2.get(file4);
                if (psiFile == null || excludedFiles.contains(psiFile) || !CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)psiFile) || (problems = fileListMap.get(file4)) == null) continue;
                if (psiFile.getFileType().isBinary()) {
                    if (!this.matchesFilter(fileListMap, file4)) continue;
                    elements.add((PsiElement)psiFile);
                    continue;
                }
                ResourceFolderType folderType = IdeResourcesUtil.getFolderType(psiFile);
                if (folderType == null) {
                    if (!(psiFile instanceof GroovyFile) && !(psiFile instanceof KtFile) || !psiFile.getName().endsWith("gradle") && !psiFile.getName().endsWith("gradle.kts")) continue;
                    GradleBuildModel gradleBuildModel = GradleModelProvider.getInstance().parseBuildFile(psiFile.getVirtualFile(), this.myProject);
                    AndroidModel androidElement = gradleBuildModel.android();
                    List<FlavorTypeModel.ResValue> resValues = androidElement.defaultConfig().resValues();
                    resValues.addAll(androidElement.productFlavors().stream().flatMap(e -> e.resValues().stream()).collect(Collectors.toList()));
                    resValues.addAll(androidElement.buildTypes().stream().flatMap(e -> e.resValues().stream()).collect(Collectors.toList()));
                    for (FlavorTypeModel.ResValue resValue : resValues) {
                        ResolvedPropertyModel typeString = resValue.type();
                        ResolvedPropertyModel nameString = resValue.name();
                        List<LintProblemData> lintProblems = fileListMap.get(VfsUtilCore.virtualToIoFile((VirtualFile)psiFile.getVirtualFile()));
                        if (problems == null) continue;
                        for (LintProblemData problem : lintProblems) {
                            String unusedResource = UnusedResourcesProcessor.getResource(problem);
                            if (unusedResource == null || !unusedResource.equals("R." + typeString + "." + nameString) || resValue.getModel().getPsiElement() == null) continue;
                            elements.add(resValue.getModel().getPsiElement());
                            this.myBuildModelMap.put(resValue.getModel().getPsiElement(), gradleBuildModel);
                            resValue.remove();
                        }
                    }
                    continue;
                }
                if (folderType != ResourceFolderType.VALUES) {
                    if (issue3 == UnusedResourceDetector.ISSUE_IDS) {
                        Map<File, List<LintProblemData>> m = map2.get(UnusedResourceDetector.ISSUE);
                        if (m != null && m.containsKey(file4)) continue;
                        this.addElementsInFile(elements, psiFile, problems, excludedResources);
                        continue;
                    }
                    if (!this.matchesFilter(fileListMap, file4)) continue;
                    elements.add((PsiElement)psiFile);
                    continue;
                }
                this.addElementsInFile(elements, psiFile, problems, excludedResources);
            }
        }
        return elements;
    }

    private static String getResource(LintProblemData problem) {
        return LintFix.getString((LintFix)problem.getQuickfixData(), (String)"field", null);
    }

    private void addElementsInFile(List<PsiElement> elements, PsiFile psiFile, List<LintProblemData> problems, Set<String> excludedResources) {
        if (psiFile instanceof XmlFile) {
            ArrayList starts = Lists.newArrayListWithCapacity((int)problems.size());
            for (LintProblemData problem : problems) {
                if (excludedResources.contains(UnusedResourcesProcessor.getResource(problem)) || !this.matchesFilter(problem)) continue;
                starts.add(problem.getTextRange().getStartOffset());
            }
            starts.sort(Collections.reverseOrder());
            for (Integer offset : starts) {
                XmlAttribute attribute;
                if (!psiFile.isValid()) continue;
                XmlAttribute remove2 = attribute = (XmlAttribute)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, XmlAttribute.class, (boolean)false);
                if (attribute == null) {
                    remove2 = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, XmlTag.class, (boolean)false);
                } else if (!"id".equals(attribute.getLocalName())) {
                    remove2 = PsiTreeUtil.getParentOfType((PsiElement)attribute, XmlTag.class);
                }
                if (remove2 == null) continue;
                elements.add((PsiElement)remove2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<Issue, Map<File, List<LintProblemData>>> computeUnusedMap() {
        HashMap map2 = Maps.newHashMap();
        ImmutableSet issues = this.myIncludeIds ? ImmutableSet.of((Object)UnusedResourceDetector.ISSUE, (Object)UnusedResourceDetector.ISSUE_IDS) : ImmutableSet.of((Object)UnusedResourceDetector.ISSUE);
        AnalysisScope scope2 = new AnalysisScope(this.myProject);
        boolean unusedWasEnabled = UnusedResourceDetector.ISSUE.isEnabledByDefault();
        boolean unusedIdsWasEnabled = UnusedResourceDetector.ISSUE_IDS.isEnabledByDefault();
        UnusedResourceDetector.ISSUE.setEnabledByDefault(true);
        UnusedResourceDetector.ISSUE_IDS.setEnabledByDefault(this.myIncludeIds);
        try {
            LintBatchResult lintResult = new LintBatchResult(this.myProject, (Map)map2, scope2, (Set)issues);
            LintIdeClient client2 = LintIdeSupport.get().createBatchClient(lintResult);
            List<Module> modules2 = Arrays.asList(ModuleManager.getInstance((Project)this.myProject).getModules());
            LintIdeRequest request2 = new LintIdeRequest(client2, this.myProject, null, modules2, false);
            request2.setScope(Scope.ALL);
            LintDriver lint = client2.createDriver((LintRequest)request2, LintIdeSupport.get().getIssueRegistry());
            lint.setCheckTestSources(true);
            lint.analyze();
        }
        finally {
            UnusedResourceDetector.ISSUE.setEnabledByDefault(unusedWasEnabled);
            UnusedResourceDetector.ISSUE_IDS.setEnabledByDefault(unusedIdsWasEnabled);
        }
        return map2;
    }

    private boolean matchesFilter(@NotNull Map<File, List<LintProblemData>> fileListMap, @NotNull File file2) {
        if (this.myFilter != null) {
            List<LintProblemData> problems = fileListMap.get(file2);
            for (LintProblemData problem : problems) {
                if (!this.myFilter.equals(UnusedResourcesProcessor.getResource(problem))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean matchesFilter(@NotNull LintProblemData problem) {
        return this.myFilter == null || this.myFilter.equals(UnusedResourcesProcessor.getResource(problem));
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        return true;
    }

    public PsiElement[] getElements() {
        return this.myElements;
    }

    protected void refreshElements(@NotNull @NotNull PsiElement @NotNull [] elements) {
        System.arraycopy(elements, 0, this.myElements, 0, elements.length);
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData beforeData = new RefactoringEventData();
        beforeData.addElements(this.myElements);
        return beforeData;
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.unused.resources";
    }

    protected void performRefactoring(@NotNull @NotNull UsageInfo @NotNull [] usages) {
        try {
            for (UsageInfo usage : usages) {
                PsiElement element2 = usage.getElement();
                if (element2 == null || !element2.isValid()) continue;
                if (this.myBuildModelMap.get(element2) != null && this.myBuildModelMap.get(element2).isModified()) {
                    WriteCommandAction.runWriteCommandAction((Project)this.myProject, this.myBuildModelMap.get(element2)::applyChanges);
                    continue;
                }
                element2.delete();
            }
        }
        catch (IncorrectOperationException e) {
            RefactoringUIUtil.processIncorrectOperation((Project)this.myProject, (IncorrectOperationException)e);
        }
    }

    private String calcCommandName() {
        return "Deleting " + RefactoringUIUtil.calculatePsiElementDescriptionList((PsiElement[])this.myElements);
    }

    @NotNull
    protected String getCommandName() {
        if (this.myCachedCommandName == null) {
            this.myCachedCommandName = this.calcCommandName();
        }
        return this.myCachedCommandName;
    }

    protected boolean skipNonCodeUsages() {
        return true;
    }

    public void setIncludeIds(boolean includeIds) {
        this.myIncludeIds = includeIds;
    }

    protected boolean isToBeChanged(@NotNull UsageInfo usageInfo) {
        PsiElement element2;
        if (ApplicationManager.getApplication().isUnitTestMode() && (element2 = usageInfo.getElement()) != null && element2.getText().contains("AUTO-EXCLUDE")) {
            return false;
        }
        return super.isToBeChanged(usageInfo);
    }
}

