/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.annotations.concurrency.UiThread;
import com.google.common.collect.Sets;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.UnusedResourcesDialog;
import org.jetbrains.android.refactoring.UnusedResourcesProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedResourcesHandler
implements RefactoringActionHandler {
    public static void invoke(Project project, @Nullable Module[] modules2, @Nullable String filter2, boolean skipDialog, boolean skipIds) {
        if (modules2 == null || modules2.length == 0) {
            modules2 = ModuleManager.getInstance((Project)project).getModules();
        }
        UnusedResourcesProcessor processor = new UnusedResourcesProcessor(project, modules2, filter2);
        if (skipIds) {
            processor.setIncludeIds(true);
        }
        if (skipDialog || ApplicationManager.getApplication().isUnitTestMode()) {
            processor.run();
        } else {
            UnusedResourcesDialog dialog2 = new UnusedResourcesDialog(project, processor);
            dialog2.show();
        }
    }

    @UiThread
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        this.invoke(project, new PsiElement[]{file2}, dataContext);
    }

    @UiThread
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        HashSet moduleSet = Sets.newHashSet();
        Module[] modules2 = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modules2 != null) {
            Collections.addAll(moduleSet, modules2);
        } else {
            Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
            if (module2 != null) {
                moduleSet.add(module2);
            }
        }
        for (PsiElement element2 : elements) {
            Module module3 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element2);
            if (module3 == null) continue;
            moduleSet.add(module3);
        }
        if (moduleSet.size() == 1 && AndroidFacet.getInstance((Module)((Module)moduleSet.iterator().next())) == null) {
            moduleSet.clear();
        }
        UnusedResourcesHandler.invoke(project, moduleSet.toArray(Module.EMPTY_ARRAY), null, false, false);
    }
}

