/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.usageView.UsageInfo;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.AppCompatMigrationEntry;
import org.jetbrains.android.refactoring.MigrateToAppCompatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

abstract class MigrateToAppCompatUsageInfo
extends UsageInfo {
    public MigrateToAppCompatUsageInfo(@NotNull PsiReference reference) {
        super(reference);
    }

    public MigrateToAppCompatUsageInfo(@NotNull PsiElement element2) {
        super(element2);
    }

    @Nullable
    public abstract PsiElement applyChange(@NotNull PsiMigration var1);

    private static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }

    static class AddGoogleRepositoryUsageInfo
    extends GradleUsageInfo {
        private final RepositoriesModel myRepositoriesModel;
        private final ProjectBuildModel myProjectBuildModel;

        public AddGoogleRepositoryUsageInfo(@NotNull ProjectBuildModel projectBuildModel2, @NotNull RepositoriesModel repositoriesModel, @NotNull PsiElement repositoriesModelPsiElement) {
            super(repositoriesModelPsiElement);
            this.myProjectBuildModel = projectBuildModel2;
            this.myRepositoriesModel = repositoriesModel;
        }

        @Override
        @Nullable
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            this.myRepositoriesModel.addGoogleMavenRepository();
            this.myProjectBuildModel.applyChanges();
            return this.getElement();
        }
    }

    static class GradleStringUsageInfo
    extends GradleUsageInfo {
        @NotNull
        private final String myNewValue;
        private final GradleBuildModel myBuildModel;

        public GradleStringUsageInfo(@NotNull PsiElement element2, @NotNull String newValue, @NotNull GradleBuildModel buildModel) {
            super(element2);
            this.myNewValue = newValue;
            this.myBuildModel = buildModel;
        }

        @Override
        @Nullable
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            if (this.myBuildModel.isModified()) {
                this.myBuildModel.applyChanges();
                return this.getElement();
            }
            PsiElement element2 = this.getElement();
            if (element2 == null) {
                return null;
            }
            PsiReference reference = element2.getReference();
            if (reference != null) {
                reference.handleElementRename(this.myNewValue);
            }
            return element2;
        }
    }

    static class GradleDependencyUsageInfo
    extends GradleUsageInfo {
        @NotNull
        private final TriFunction<String, String, String, String> myGetLibraryRevisionFunction;
        private final AppCompatMigrationEntry.GradleMigrationEntry mapEntry;
        private final ArtifactDependencyModel myModel;
        private final ProjectBuildModel myBuildModel;

        public GradleDependencyUsageInfo(@NotNull PsiElement element2, @NotNull ProjectBuildModel buildModel, @NotNull ArtifactDependencyModel model2, AppCompatMigrationEntry.GradleMigrationEntry entry, @NotNull TriFunction<String, String, String, String> versionProvider2) {
            super(element2);
            this.mapEntry = entry;
            this.myGetLibraryRevisionFunction = versionProvider2;
            this.myModel = model2;
            this.myBuildModel = buildModel;
        }

        @Override
        @Nullable
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element2 = this.getElement();
            if (element2 == null || !element2.isValid() || !element2.isWritable()) {
                return null;
            }
            if (this.myModel != null && this.myBuildModel != null) {
                PsiElement modelPsi = this.myModel.getPsiElement();
                if (modelPsi != null && modelPsi.isValid()) {
                    this.myModel.enableSetThrough();
                    if (this.mapEntry instanceof AppCompatMigrationEntry.GradleDependencyMigrationEntry) {
                        AppCompatMigrationEntry.GradleDependencyMigrationEntry depEntry = (AppCompatMigrationEntry.GradleDependencyMigrationEntry)this.mapEntry;
                        String group2 = this.myModel.group().toString();
                        String name = this.myModel.name().toString();
                        if (group2 != null && group2.equals(depEntry.getOldGroupName())) {
                            this.myModel.group().getResultModel().setValue(depEntry.getNewGroupName());
                        }
                        if (name != null && name.equals(depEntry.getOldArtifactName())) {
                            this.myModel.name().getResultModel().setValue(depEntry.getNewArtifactName());
                        }
                    }
                    String version2 = this.myModel.version().toString();
                    String newVersion = this.mapEntry instanceof AppCompatMigrationEntry.UpdateGradleDependencyVersionMigrationEntry ? GradleDependencyUsageInfo.getHighestVersion(version2, this.mapEntry.getNewBaseVersion()) : this.mapEntry.getNewBaseVersion();
                    if (newVersion != null) {
                        this.myModel.version().getResultModel().setValue(newVersion);
                    }
                }
                ApplicationManager.getApplication().runReadAction(this.myBuildModel::applyChanges);
                return null;
            }
            if (element2 instanceof GrArgumentList) {
                GrArgumentList list2 = (GrArgumentList)element2;
                GroovyPsiElement[] expressions = list2.getAllArguments();
                PsiElement group3 = null;
                PsiElement name = null;
                PsiElement version3 = null;
                block10: for (GroovyPsiElement expression2 : expressions) {
                    GrNamedArgument namedArgument;
                    String labelName;
                    if (!(expression2 instanceof GrNamedArgument) || (labelName = (namedArgument = (GrNamedArgument)expression2).getLabelName()) == null) continue;
                    PsiElement val = PsiTreeUtil.findChildOfType((PsiElement)namedArgument, GrLiteral.class);
                    switch (labelName) {
                        case "group": {
                            group3 = val;
                            continue block10;
                        }
                        case "name": {
                            name = val;
                            continue block10;
                        }
                        case "version": {
                            version3 = val;
                        }
                    }
                }
                if (group3 == null || name == null || version3 == null) {
                    return null;
                }
                if (this.mapEntry instanceof AppCompatMigrationEntry.GradleDependencyMigrationEntry) {
                    AppCompatMigrationEntry.GradleDependencyMigrationEntry depEntry = (AppCompatMigrationEntry.GradleDependencyMigrationEntry)this.mapEntry;
                    GradleDependencyUsageInfo.renameElement(group3, depEntry.getOldGroupName(), depEntry.getNewGroupName());
                    GradleDependencyUsageInfo.renameElement(name, depEntry.getOldArtifactName(), depEntry.getNewArtifactName());
                }
                if (version3.getReference() != null) {
                    String newVersion;
                    if (this.mapEntry instanceof AppCompatMigrationEntry.UpdateGradleDependencyVersionMigrationEntry) {
                        newVersion = GradleDependencyUsageInfo.getHighestVersion(version3.getText(), this.mapEntry.getNewBaseVersion());
                        if (newVersion == null) {
                            return null;
                        }
                    } else {
                        newVersion = this.mapEntry.getNewBaseVersion();
                    }
                    version3.getReference().handleElementRename(this.myGetLibraryRevisionFunction.apply(this.mapEntry.getNewGroupName(), this.mapEntry.getNewArtifactName(), newVersion));
                }
            } else if (element2.getReference() != null) {
                String newVersion;
                if (this.mapEntry instanceof AppCompatMigrationEntry.UpdateGradleDependencyVersionMigrationEntry) {
                    GradleCoordinate existingCoordinate = GradleCoordinate.parseCoordinateString((String)element2.getReference().getCanonicalText());
                    newVersion = GradleDependencyUsageInfo.getHighestVersion(existingCoordinate, this.mapEntry.getNewBaseVersion());
                    if (newVersion == null) {
                        return null;
                    }
                } else {
                    newVersion = this.mapEntry.getNewBaseVersion();
                }
                PsiElement parent2 = element2.getParent();
                if (element2 instanceof GrReferenceExpression && parent2 != null) {
                    GrLiteral newLiteral = GroovyPsiElementFactory.getInstance((Project)this.getProject()).createLiteralFromValue((Object)this.mapEntry.toCompactNotation(this.myGetLibraryRevisionFunction.apply(this.mapEntry.getNewGroupName(), this.mapEntry.getNewArtifactName(), newVersion)));
                    parent2.replace((PsiElement)newLiteral);
                } else {
                    element2.getReference().handleElementRename(this.mapEntry.toCompactNotation(this.myGetLibraryRevisionFunction.apply(this.mapEntry.getNewGroupName(), this.mapEntry.getNewArtifactName(), newVersion)));
                }
            } else if (element2 instanceof GrString) {
                String newVersion;
                if (this.mapEntry instanceof AppCompatMigrationEntry.UpdateGradleDependencyVersionMigrationEntry) {
                    GradleCoordinate existingCoordinate = GradleCoordinate.parseCoordinateString((String)GrStringUtil.removeQuotes((String)element2.getText()));
                    newVersion = GradleDependencyUsageInfo.getHighestVersion(existingCoordinate, this.mapEntry.getNewBaseVersion());
                    if (newVersion == null) {
                        return null;
                    }
                } else {
                    newVersion = this.mapEntry.getNewBaseVersion();
                }
                GrLiteral newLiteral = GroovyPsiElementFactory.getInstance((Project)this.getProject()).createLiteralFromValue((Object)this.mapEntry.toCompactNotation(this.myGetLibraryRevisionFunction.apply(this.mapEntry.getNewGroupName(), this.mapEntry.getNewArtifactName(), newVersion)));
                element2.replace((PsiElement)newLiteral);
            }
            return null;
        }

        @VisibleForTesting
        @Nullable
        static String getHighestVersion(@Nullable String a, @NotNull String defaultVersion) {
            GradleCoordinate versionB;
            if (a == null) {
                return defaultVersion;
            }
            if (a.startsWith("$")) {
                return null;
            }
            GradleCoordinate versionA = GradleCoordinate.parseVersionOnly((String)a);
            if (GradleCoordinate.COMPARE_PLUS_HIGHER.compare(versionA, versionB = GradleCoordinate.parseVersionOnly((String)defaultVersion)) >= 0) {
                return a;
            }
            return defaultVersion;
        }

        @VisibleForTesting
        @Nullable
        static String getHighestVersion(@Nullable GradleCoordinate coordinate, @NotNull String defaultVersion) {
            if (coordinate == null) {
                return defaultVersion;
            }
            return coordinate.getVersion() != null ? GradleDependencyUsageInfo.getHighestVersion(coordinate.getVersion().toString(), defaultVersion) : defaultVersion;
        }

        private static void renameElement(PsiElement current, String oldName, String newName2) {
            String elementText = StringUtil.trimStart((String)current.getText(), (String)"'");
            elementText = StringUtil.trimEnd((String)elementText, (String)"'");
            elementText = StringUtil.trimStart((String)elementText, (String)"\"");
            if ((elementText = StringUtil.trimEnd((String)elementText, (String)"\"")).equals(oldName) && current.getReference() != null) {
                current.getReference().handleElementRename(newName2);
            }
        }
    }

    static abstract class GradleUsageInfo
    extends MigrateToAppCompatUsageInfo {
        public GradleUsageInfo(@NotNull PsiElement element2) {
            super(element2);
        }
    }

    static class ChangeXmlAttrValueUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final AppCompatMigrationEntry.AttributeValueMigrationEntry myEntry;

        public ChangeXmlAttrValueUsageInfo(@NotNull PsiElement element2, @NotNull AppCompatMigrationEntry.AttributeValueMigrationEntry entry) {
            super(element2);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element2 = this.getElement();
            XmlAttribute currentAttr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlAttribute.class, (boolean)false);
            if (currentAttr == null) {
                return null;
            }
            PsiFile file2 = element2.getContainingFile();
            assert (file2 instanceof XmlFile);
            currentAttr.setValue(this.myEntry.myNewAttrValue);
            return null;
        }
    }

    static class ChangeXmlAttrUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final AppCompatMigrationEntry.AttributeMigrationEntry myEntry;

        public ChangeXmlAttrUsageInfo(@NotNull PsiElement element2, @NotNull AppCompatMigrationEntry.AttributeMigrationEntry entry) {
            super(element2);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element2 = this.getElement();
            XmlAttribute currentAttr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlAttribute.class, (boolean)false);
            if (currentAttr == null || !currentAttr.getLocalName().equals(this.myEntry.myOldAttributeName)) {
                return element2;
            }
            PsiFile file2 = element2.getContainingFile();
            assert (file2 instanceof XmlFile);
            if (StringUtil.isEmpty((String)this.myEntry.myNewNamespace)) {
                currentAttr.setName(this.myEntry.myNewAttributeName);
            } else {
                String prefixUsed = IdeResourcesUtil.ensureNamespaceImported((XmlFile)file2, this.myEntry.myNewNamespace, null);
                currentAttr.setName(prefixUsed + ":" + this.myEntry.myNewAttributeName);
            }
            return null;
        }
    }

    static class ChangeXmlTagUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final AppCompatMigrationEntry.XmlTagMigrationEntry myEntry;

        public ChangeXmlTagUsageInfo(@NotNull PsiElement element2, @NotNull AppCompatMigrationEntry.XmlTagMigrationEntry entry) {
            super(element2);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element2 = this.getElement();
            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class, (boolean)false);
            if (xmlTag == null || !xmlTag.getLocalName().equals(this.myEntry.myOldTagName)) {
                return element2;
            }
            PsiFile file2 = element2.getContainingFile();
            assert (file2 instanceof XmlFile);
            if (!StringUtil.isEmpty((String)this.myEntry.myNewNamespace)) {
                String prefixUsed = IdeResourcesUtil.ensureNamespaceImported((XmlFile)file2, this.myEntry.myNewNamespace, null);
                xmlTag.setName(prefixUsed + ":" + this.myEntry.myNewTagName);
            } else {
                xmlTag.setName(this.myEntry.myNewTagName);
            }
            return null;
        }
    }

    static class ReplaceMethodUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry myEntry;

        public ReplaceMethodUsageInfo(@NotNull PsiReference element2, @NotNull AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry entry) {
            super(element2);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration psiMigration) {
            PsiElement element2 = this.getElement();
            if (!(element2 instanceof PsiReference) || !this.isValid()) {
                return null;
            }
            PsiReference reference = (PsiReference)element2;
            PsiClass psiClass = AndroidRefactoringUtil.findOrCreateClass(this.getProject(), psiMigration, this.myEntry.myNewClassName);
            String methodFragment = this.myEntry.myNewMethodName;
            if (!(element2 instanceof PsiReferenceExpression) || ((PsiReferenceExpression)element2).getQualifierExpression() == null) {
                return null;
            }
            PsiMethodCallExpression oldMethodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiMethodCallExpression.class);
            if (oldMethodCall == null) {
                return null;
            }
            PsiExpressionList argList = oldMethodCall.getArgumentList();
            PsiExpression qualifierExpression = ((PsiReferenceExpression)element2).getQualifierExpression();
            PsiElementFactory factory2 = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            String methodCallText = "Foo." + methodFragment + "()";
            PsiMethodCallExpression call = (PsiMethodCallExpression)factory2.createExpressionFromText(methodCallText, null);
            PsiExpressionList newArgList = call.getArgumentList();
            PsiExpression[] prevExpressions = argList.getExpressions();
            if (prevExpressions.length == 0) {
                newArgList.add((PsiElement)qualifierExpression);
            } else {
                for (int i = 0; i < prevExpressions.length; ++i) {
                    PsiExpression arg = prevExpressions[i];
                    if (this.myEntry.myQualifierParamIndex == i) {
                        newArgList.add((PsiElement)qualifierExpression);
                    }
                    newArgList.add((PsiElement)arg);
                }
            }
            ((PsiReferenceExpression)call.getMethodExpression().getQualifierExpression()).bindToElement((PsiElement)psiClass);
            return oldMethodCall.replace((PsiElement)call);
        }
    }

    static class ChangeCustomViewUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final String mySuggestedSuperClass;

        public ChangeCustomViewUsageInfo(@NotNull PsiElement element2, @NotNull String suggestedSuperClass) {
            super(element2);
            this.mySuggestedSuperClass = suggestedSuperClass;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiClass psiClass = AndroidRefactoringUtil.findOrCreateClass(this.getProject(), migration, this.mySuggestedSuperClass);
            PsiElement element2 = this.getElement();
            assert (element2 != null);
            if (!element2.isValid()) {
                return null;
            }
            PsiReference reference = element2.getReference();
            if (reference != null) {
                return reference.bindToElement((PsiElement)psiClass);
            }
            return null;
        }
    }

    static class ChangeThemeUsageInfo
    extends ChangeStyleUsageInfo {
        ChangeThemeUsageInfo(@NotNull XmlAttributeValue element2, @NotNull String fromValue, @NotNull String toValue) {
            super((PsiElement)element2, fromValue, toValue);
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlAttributeValue.class, (boolean)false);
            if (attributeValue == null) {
                return null;
            }
            String value2 = attributeValue.getValue();
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlAttribute.class, (boolean)true);
            if (attribute != null && value2 != null && value2.equals(this.myFromValue)) {
                attribute.setValue(this.myToValue);
            }
            return null;
        }
    }

    static class ChangeStyleUsageInfo
    extends MigrateToAppCompatUsageInfo {
        protected final String myFromValue;
        protected final String myToValue;

        ChangeStyleUsageInfo(@NotNull PsiElement element2, @NotNull String fromValue, @NotNull String toValue) {
            super(element2);
            this.myFromValue = fromValue;
            this.myToValue = toValue;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            XmlAttributeValue attributeValue;
            PsiElement element2 = this.getElement();
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class, (boolean)false);
            if (tag == null) {
                return null;
            }
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlAttribute.class, (boolean)false);
            XmlAttributeValue xmlAttributeValue = attributeValue = attribute == null ? null : attribute.getValueElement();
            if (attribute != null && attributeValue != null) {
                tag.setAttribute(attribute.getName(), this.myToValue);
            } else {
                XmlTagValue tagValue = tag.getValue();
                tagValue.setText(this.myToValue);
            }
            return null;
        }
    }

    static class PackageMigrationUsageInfo
    extends MigrateToAppCompatUsageInfo {
        final AppCompatMigrationEntry.PackageMigrationEntry mapEntry;

        public PackageMigrationUsageInfo(@NotNull UsageInfo info2, @NotNull AppCompatMigrationEntry.PackageMigrationEntry mapEntry) {
            super(info2.getElement());
            this.mapEntry = mapEntry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            if (this.mapEntry.myOldName.equals(this.mapEntry.myNewName)) {
                return null;
            }
            PsiPackage aPackage = AndroidRefactoringUtil.findOrCreatePackage(this.getProject(), migration, this.mapEntry.myNewName);
            PsiElement element2 = this.getElement();
            if (element2 == null || !element2.isValid()) {
                return element2;
            }
            if (element2 instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element2;
                return referenceElement.bindToElement((PsiElement)aPackage);
            }
            ProperTextRange range = this.getRangeInElement();
            for (PsiReference reference : element2.getReferences()) {
                if (reference == null) continue;
                if (reference instanceof JavaClassReference) {
                    JavaClassReference classReference = (JavaClassReference)reference;
                    if (!classReference.getRangeInElement().equals((Object)range)) continue;
                    return classReference.bindToElement((PsiElement)aPackage);
                }
                if (reference.getElement() instanceof XmlTag) {
                    XmlTag ref = (XmlTag)reference.getElement();
                    String localName = ref.getLocalName();
                    if (!localName.startsWith(this.mapEntry.myOldName)) continue;
                    String newName2 = localName.replace(this.mapEntry.myOldName, this.mapEntry.myNewName);
                    ref.setName(newName2);
                    continue;
                }
                if (reference.getElement() instanceof XmlAttributeValue) {
                    XmlAttribute attribute;
                    String oldValue;
                    PsiElement parent2 = reference.getElement().getParent();
                    if (!(parent2 instanceof XmlAttribute) || !(oldValue = StringUtil.notNullize((String)(attribute = (XmlAttribute)parent2).getValue())).startsWith(this.mapEntry.myOldName)) continue;
                    attribute.setValue(oldValue.replace(this.mapEntry.myOldName, this.mapEntry.myNewName));
                    continue;
                }
                if (!MigrateToAppCompatUtil.isKotlinSimpleNameReference(reference) || element2.getParent() == null || !element2.getParent().getText().equals(this.mapEntry.myOldName)) continue;
                return reference.bindToElement((PsiElement)aPackage);
            }
            return null;
        }
    }

    static class ClassMigrationUsageInfo
    extends MigrateToAppCompatUsageInfo {
        final AppCompatMigrationEntry.ClassMigrationEntry mapEntry;

        public ClassMigrationUsageInfo(@NotNull UsageInfo info2, @NotNull AppCompatMigrationEntry.ClassMigrationEntry mapEntry) {
            super(info2.getElement());
            this.mapEntry = mapEntry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration psiMigration) {
            if (this.mapEntry.myOldName.equals(this.mapEntry.myNewName)) {
                return null;
            }
            PsiClass aClass = AndroidRefactoringUtil.findOrCreateClass(this.getProject(), psiMigration, this.mapEntry.myNewName);
            PsiElement element2 = this.getElement();
            if (element2 == null || !element2.isValid()) {
                return element2;
            }
            if (element2 instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element2;
                return referenceElement.bindToElement((PsiElement)aClass);
            }
            if (element2 instanceof XmlAttributeValue) {
                XmlAttributeValue value2 = (XmlAttributeValue)element2;
                XmlAttribute attribute = (XmlAttribute)value2.getParent();
                if (this.mapEntry.myOldName.equals(value2.getValue())) {
                    attribute.setValue(this.mapEntry.myNewName);
                }
            } else {
                ProperTextRange range = this.getRangeInElement();
                for (PsiReference reference : element2.getReferences()) {
                    if (reference instanceof JavaClassReference) {
                        JavaClassReference classReference = (JavaClassReference)reference;
                        if (!classReference.getRangeInElement().equals((Object)range)) continue;
                        return classReference.bindToElement((PsiElement)aClass);
                    }
                    if (reference != null && reference.getElement() instanceof XmlTag) {
                        XmlTag ref = (XmlTag)reference.getElement();
                        String localName = ref.getLocalName();
                        if (!this.mapEntry.myOldName.equals(localName)) continue;
                        ref.setName(this.mapEntry.myNewName);
                        continue;
                    }
                    if (reference == null || !MigrateToAppCompatUtil.isKotlinSimpleNameReference(reference)) continue;
                    return reference.bindToElement((PsiElement)aClass);
                }
            }
            return null;
        }
    }

    static class ChangeMethodUsageInfo
    extends MigrateToAppCompatUsageInfo {
        final AppCompatMigrationEntry.MethodMigrationEntry myEntry;

        public ChangeMethodUsageInfo(PsiReference ref, @NotNull AppCompatMigrationEntry.MethodMigrationEntry entry) {
            super(ref);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element2 = this.getElement();
            if (element2 instanceof PsiReference && this.isValid()) {
                PsiReference reference = (PsiReference)element2;
                String newName2 = this.myEntry.myNewMethodName;
                return reference.handleElementRename(newName2);
            }
            return null;
        }
    }
}

