/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.support.AndroidxNameUtils;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.android.ProductFlavorModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.model.IdeTestOptions;
import com.android.tools.idea.gradle.project.sync.hyperlink.AddGoogleMavenRepositoryHyperlink;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.AndroidRefactoringUtilKt;
import org.jetbrains.android.refactoring.AppCompatMigrationEntry;
import org.jetbrains.android.refactoring.MigrateToAndroidxProcessor;
import org.jetbrains.android.refactoring.MigrateToAndroidxProcessorKt;
import org.jetbrains.android.refactoring.MigrateToAndroidxUsageViewDescriptor;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.android.refactoring.MigrateToAppCompatUsageInfo;
import org.jetbrains.android.refactoring.MigrateToAppCompatUsageInfoUtilKt;
import org.jetbrains.android.refactoring.MigrateToAppCompatUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.KotlinOptimizeImportsRefactoringHelper;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u000256BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\"\b\u0002\u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0004\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0014\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0014\u00a2\u0006\u0002\u0010\u001eJ6\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u001e\u0010!\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0#\u0012\u0004\u0012\u00020$0\"H\u0002J\b\u0010%\u001a\u00020\u001bH\u0002J\u001b\u0010&\u001a\u00020'2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0014\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020'H\u0014J\b\u0010*\u001a\u00020\tH\u0014J\b\u0010+\u001a\u00020\u001bH\u0014J\u001d\u0010,\u001a\u00020\u001b2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0014\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010-\u001a\u00020\u000b2\u0012\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170/H\u0014J\u001b\u00100\u001a\u00020\u001b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0014\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020\u000bH\u0014J\u0010\u00103\u001a\u0002042\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/android/refactoring/MigrateToAndroidxProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "migrationMap", "", "Lorg/jetbrains/android/refactoring/AppCompatMigrationEntry;", "versionProvider", "Lkotlin/Function3;", "", "callSyncAfterMigration", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lkotlin/jvm/functions/Function3;Z)V", "elements", "", "Lcom/intellij/psi/PsiElement;", "getProject", "()Lcom/intellij/openapi/project/Project;", "refsToShorten", "Lcom/intellij/psi/SmartPsiElementPointer;", "createUsageViewDescriptor", "Lorg/jetbrains/android/refactoring/MigrateToAndroidxUsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lorg/jetbrains/android/refactoring/MigrateToAndroidxUsageViewDescriptor;", "execute", "", "([Lcom/intellij/usageView/UsageInfo;)V", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "findUsagesInBuildFiles", "Lorg/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo;", "gradleDependencyEntries", "", "Lcom/intellij/openapi/util/Pair;", "Lorg/jetbrains/android/refactoring/AppCompatMigrationEntry$GradleMigrationEntry;", "finishFindMigration", "getAfterData", "Lcom/intellij/refactoring/listeners/RefactoringEventData;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/refactoring/listeners/RefactoringEventData;", "getBeforeData", "getCommandName", "performPsiSpoilingRefactoring", "performRefactoring", "preprocessUsages", "refUsages", "Lcom/intellij/openapi/util/Ref;", "refreshElements", "([Lcom/intellij/psi/PsiElement;)V", "skipNonCodeUsages", "startMigration", "Lcom/intellij/psi/PsiMigration;", "KotlinFileWrapper", "UsageAccumulator", "intellij.android.projectSystem.gradle"})
public class MigrateToAndroidxProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final Project project;
    @NotNull
    private final List<AppCompatMigrationEntry> migrationMap;
    private final boolean callSyncAfterMigration;
    @NotNull
    private final List<PsiElement> elements;
    @NotNull
    private final List<SmartPsiElementPointer<PsiElement>> refsToShorten;
    @NotNull
    private final Function3<String, String, String, String> versionProvider;

    public MigrateToAndroidxProcessor(@NotNull Project project, @NotNull List<? extends AppCompatMigrationEntry> migrationMap, @Nullable Function3<? super String, ? super String, ? super String, String> versionProvider2, boolean callSyncAfterMigration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(migrationMap, (String)"migrationMap");
        super(project);
        this.project = project;
        this.migrationMap = migrationMap;
        this.callSyncAfterMigration = callSyncAfterMigration;
        this.elements = new ArrayList();
        this.refsToShorten = new ArrayList();
        Function3 function3 = versionProvider2;
        if (function3 == null) {
            function3 = versionProvider.1.INSTANCE;
        }
        this.versionProvider = function3;
    }

    public /* synthetic */ MigrateToAndroidxProcessor(Project project, List list2, Function3 function3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function3 = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(project, list2, (Function3<? super String, ? super String, ? super String, String>)function3, bl);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final MigrateToAndroidxUsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        Collection $this$toTypedArray$iv = this.elements;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiElement[] psiElementArray = thisCollection$iv.toArray(new PsiElement[0]);
        if (psiElementArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return new MigrateToAndroidxUsageViewDescriptor(psiElementArray);
    }

    private final PsiMigration startMigration(Project project) {
        this.finishFindMigration();
        PsiMigration psiMigration = PsiMigrationManager.getInstance((Project)project).startMigration();
        Intrinsics.checkNotNullExpressionValue((Object)psiMigration, (String)"getInstance(project).startMigration()");
        PsiMigration migration = psiMigration;
        for (AppCompatMigrationEntry entry : this.migrationMap) {
            AppCompatMigrationEntry appCompatMigrationEntry = entry;
            if (appCompatMigrationEntry instanceof AppCompatMigrationEntry.PackageMigrationEntry) {
                String string = ((AppCompatMigrationEntry.PackageMigrationEntry)entry).myNewName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.myNewName");
                AndroidRefactoringUtil.findOrCreatePackage(project, migration, string);
                String string2 = ((AppCompatMigrationEntry.PackageMigrationEntry)entry).myOldName;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.myOldName");
                AndroidRefactoringUtil.findOrCreatePackage(project, migration, string2);
                continue;
            }
            if (!(appCompatMigrationEntry instanceof AppCompatMigrationEntry.ClassMigrationEntry)) continue;
            String string = ((AppCompatMigrationEntry.ClassMigrationEntry)entry).myNewName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.myNewName");
            AndroidRefactoringUtil.findOrCreateClass$default(project, migration, string, null, 8, null);
            String string3 = ((AppCompatMigrationEntry.ClassMigrationEntry)entry).myOldName;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.myOldName");
            AndroidRefactoringUtil.findOrCreateClass$default(project, migration, string3, null, 8, null);
        }
        return migration;
    }

    /*
     * WARNING - void declaration
     */
    protected void execute(@NotNull UsageInfo[] usages) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        UsageInfo[] $this$map$iv = usages;
        boolean $i$f$map = false;
        UsageInfo[] usageInfoArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getFile() instanceof KtFile ? (UsageInfo)new KotlinFileWrapper((UsageInfo)it) : it);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        UsageInfo[] usageInfoArray2 = thisCollection$iv.toArray(new UsageInfo[0]);
        if (usageInfoArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        UsageInfo[] wrapped = usageInfoArray2;
        super.execute(wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        Object object;
        UsageAccumulator usageAccumulator = new UsageAccumulator();
        Function1 generatedCodeUsages2 = (Function1)new Function1<UsageInfo, Boolean>(this){
            final /* synthetic */ MigrateToAndroidxProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull UsageInfo usage) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
                VirtualFile virtualFile = usage.getVirtualFile();
                if (virtualFile != null) {
                    VirtualFile virtualFile2 = virtualFile;
                    MigrateToAndroidxProcessor migrateToAndroidxProcessor = this.this$0;
                    VirtualFile it = virtualFile2;
                    boolean bl2 = false;
                    boolean bl3 = !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)it, (Project)migrateToAndroidxProcessor.getProject());
                    bl = !bl3;
                } else {
                    bl = false;
                }
                return !bl;
            }
        };
        try {
            Map gradleDependencyEntries = new LinkedHashMap();
            for (AppCompatMigrationEntry entry : this.migrationMap) {
                switch (entry.getType()) {
                    case 1: {
                        UsageInfo it;
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv;
                        Iterable $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type org.jetbrains.android.refactoring.AppCompatMigrationEntry.ClassMigrationEntry");
                        AppCompatMigrationEntry.ClassMigrationEntry clsEntry = (AppCompatMigrationEntry.ClassMigrationEntry)entry;
                        List<UsageInfo> classUsages = MigrateToAppCompatUtil.findClassUsages(this.project, clsEntry.myOldName);
                        List infos = new ArrayList();
                        Intrinsics.checkNotNullExpressionValue(classUsages, (String)"classUsages");
                        Iterable iterable = classUsages;
                        boolean $i$f$filter = false;
                        void var11_16 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            if (!((Boolean)generatedCodeUsages2.invoke(element$iv$iv)).booleanValue()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            UsageInfo usageInfo = (UsageInfo)item$iv$iv;
                            object = destination$iv$iv;
                            boolean bl = false;
                            object.add(new MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo(it, clsEntry));
                        }
                        CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)infos);
                        UsageAccumulator.addAll$default(usageAccumulator, infos, false, 2, null);
                        break;
                    }
                    case 9: {
                        UsageInfo it;
                        Iterable $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type org.jetbrains.android.refactoring.AppCompatMigrationEntry.PackageMigrationEntry");
                        AppCompatMigrationEntry.PackageMigrationEntry pkgEntry = (AppCompatMigrationEntry.PackageMigrationEntry)entry;
                        List<UsageInfo> packageUsages = MigrateToAppCompatUtil.findPackageUsages(this.project, pkgEntry.myOldName);
                        List infos = new ArrayList();
                        Intrinsics.checkNotNullExpressionValue(packageUsages, (String)"packageUsages");
                        Iterable $this$map$iv = packageUsages;
                        boolean $i$f$filter = false;
                        void $this$mapTo$iv$iv = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            if (!((Boolean)generatedCodeUsages2.invoke(element$iv$iv)).booleanValue()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            it = (UsageInfo)item$iv$iv;
                            object = destination$iv$iv;
                            boolean bl = false;
                            object.add(new MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo(it, pkgEntry));
                        }
                        CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)infos);
                        UsageAccumulator.addAll$default(usageAccumulator, infos, false, 2, null);
                        break;
                    }
                    case 10: {
                        Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type org.jetbrains.android.refactoring.AppCompatMigrationEntry.GradleDependencyMigrationEntry");
                        AppCompatMigrationEntry.GradleMigrationEntry migrationEntry = (AppCompatMigrationEntry.GradleDependencyMigrationEntry)entry;
                        Map map2 = gradleDependencyEntries;
                        Pair<String, String> pair = ((AppCompatMigrationEntry.GradleDependencyMigrationEntry)migrationEntry).compactKey();
                        Intrinsics.checkNotNullExpressionValue(pair, (String)"migrationEntry.compactKey()");
                        map2.put(pair, migrationEntry);
                        break;
                    }
                    case 11: {
                        Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type org.jetbrains.android.refactoring.AppCompatMigrationEntry.UpdateGradleDependencyVersionMigrationEntry");
                        AppCompatMigrationEntry.GradleMigrationEntry migrationEntry = (AppCompatMigrationEntry.UpdateGradleDependencyVersionMigrationEntry)entry;
                        Map map2 = gradleDependencyEntries;
                        Pair<String, String> pair = ((AppCompatMigrationEntry.UpdateGradleDependencyVersionMigrationEntry)migrationEntry).compactKey();
                        Intrinsics.checkNotNullExpressionValue(pair, (String)"migrationEntry.compactKey()");
                        map2.put(pair, migrationEntry);
                    }
                }
            }
            UsageAccumulator.addAll$default(usageAccumulator, this.findUsagesInBuildFiles(this.project, gradleDependencyEntries), false, 2, null);
        }
        catch (Throwable gradleDependencyEntries) {
            ApplicationManager.getApplication().invokeLater(new Runnable(this){
                final /* synthetic */ MigrateToAndroidxProcessor this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void run() {
                    WriteAction.run((ThrowableRunnable)new ThrowableRunnable(this.this$0){
                        final /* synthetic */ MigrateToAndroidxProcessor this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public final void run() {
                            MigrateToAndroidxProcessor $this$run_u24lambda_u2d0 = this.this$0;
                            boolean bl = false;
                            MigrateToAndroidxProcessor.access$finishFindMigration($this$run_u24lambda_u2d0);
                        }
                    });
                }
            }, this.myProject.getDisposed());
            throw gradleDependencyEntries;
        }
        ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, this.myProject.getDisposed());
        Logger $this$debug$iv = MigrateToAndroidxProcessorKt.access$getLog$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            object = $this$debug$iv;
            boolean bl = false;
            object.debug(CollectionsKt.joinToString$default((Iterable)usageAccumulator.getUsageInfos(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (Throwable)e$iv);
        }
        Collection $this$toTypedArray$iv = usageAccumulator.getUsageInfos();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        UsageInfo[] usageInfoArray = thisCollection$iv.toArray(new UsageInfo[0]);
        if (usageInfoArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return usageInfoArray;
    }

    /*
     * WARNING - void declaration
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        PsiMigration migration = this.startMigration(this.project);
        this.refsToShorten.clear();
        try {
            void $this$forEach$iv;
            PsiElement it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Collection collection2;
            Iterator item$iv$iv2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.project);
            MigrateToAndroidxUtil.setAndroidxProperties$default(this.project, null, 1, null);
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
            UsageInfo[] usageInfoArray = usages;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (Iterator item$iv$iv2 : $this$mapTo$iv$iv) {
                void it2;
                void var12_23 = item$iv$iv2;
                collection2 = destination$iv$iv;
                boolean bl = false;
                KotlinFileWrapper kotlinFileWrapper = it2 instanceof KotlinFileWrapper ? (KotlinFileWrapper)it2 : null;
                if (kotlinFileWrapper == null || (kotlinFileWrapper = kotlinFileWrapper.getDelegate()) == null) {
                    kotlinFileWrapper = it2;
                }
                collection2.add(kotlinFileWrapper);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MigrateToAppCompatUsageInfo)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = MigrateToAppCompatUsageInfoUtilKt.sortToApply((List)destination$iv$iv);
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            item$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
            while (item$iv$iv2.hasNext()) {
                PsiElement it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = item$iv$iv2.next();
                boolean bl = false;
                MigrateToAppCompatUsageInfo it3 = (MigrateToAppCompatUsageInfo)((Object)element$iv$iv);
                boolean bl2 = false;
                if (it3.applyChange(migration) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (PsiElement)element$iv$iv;
                boolean bl = false;
                if (!it.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                it = (PsiElement)item$iv$iv3;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(smartPointerManager.createSmartPsiElementPointer(it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                SmartPsiElementPointer it4 = (SmartPsiElementPointer)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it4, (String)"it");
                this.refsToShorten.add((SmartPsiElementPointer<PsiElement>)it4);
            }
        }
        catch (IncorrectOperationException e) {
            RefactoringUIUtil.processIncorrectOperation((Project)this.project, (IncorrectOperationException)e);
        }
        if (this.callSyncAfterMigration) {
            boolean bl;
            block12: {
                UsageInfo[] $this$any$iv = usages;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    Object element$iv;
                    UsageInfo it = element$iv = $this$any$iv[i];
                    boolean bl4 = false;
                    if (!(it instanceof MigrateToAppCompatUsageInfo.GradleUsageInfo)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
            if (bl) {
                Project project = this.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                AndroidRefactoringUtilKt.syncBeforeFinishingRefactoring(project, GradleSyncStats.Trigger.TRIGGER_REFACTOR_MIGRATE_TO_ANDROIDX, null);
            }
        }
    }

    protected void performPsiSpoilingRefactoring() {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        for (SmartPsiElementPointer<PsiElement> pointer : this.refsToShorten) {
            PsiElement element2;
            if (pointer.getElement() == null) continue;
            styleManager.shortenClassReferences(element2);
        }
        this.refsToShorten.clear();
        this.finishFindMigration();
    }

    @NotNull
    protected String getCommandName() {
        String string = AndroidBundle.message("android.refactoring.migrateto.androidx", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.refactoring.migrateto.androidx\")");
        return string;
    }

    @NotNull
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData refactoringEventData;
        RefactoringEventData $this$getBeforeData_u24lambda_u2d10 = refactoringEventData = new RefactoringEventData();
        boolean bl = false;
        $this$getBeforeData_u24lambda_u2d10.addElements((Collection)this.elements);
        return refactoringEventData;
    }

    @NotNull
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        RefactoringEventData refactoringEventData;
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        RefactoringEventData $this$getAfterData_u24lambda_u2d11 = refactoringEventData = new RefactoringEventData();
        boolean bl = false;
        $this$getAfterData_u24lambda_u2d11.addElements((Collection)this.elements);
        return refactoringEventData;
    }

    protected boolean skipNonCodeUsages() {
        return true;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
    }

    /*
     * WARNING - void declaration
     */
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(refUsages, (String)"refUsages");
        Object object = refUsages.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"refUsages.get()");
        Object[] $this$filter$iv = (Object[])object;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            UsageInfo it = (UsageInfo)element$iv$iv;
            boolean bl = false;
            UsageInfo usageInfo = it;
            boolean bl2 = usageInfo instanceof MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo ? !Intrinsics.areEqual((Object)((MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo)it).mapEntry.myOldName, (Object)((MigrateToAppCompatUsageInfo.ClassMigrationUsageInfo)it).mapEntry.myNewName) : (usageInfo instanceof MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo ? !Intrinsics.areEqual((Object)((MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo)it).mapEntry.myOldName, (Object)((MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo)it).mapEntry.myNewName) : true);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        UsageInfo[] usageInfoArray = thisCollection$iv.toArray(new UsageInfo[0]);
        if (usageInfoArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        UsageInfo[] filtered = usageInfoArray;
        if (filtered.length == 0) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                Messages.showInfoMessage((Project)this.myProject, (String)JavaRefactoringBundle.message((String)"migration.no.usages.found.in.the.project", (Object[])new Object[0]), (String)AndroidBundle.message("android.refactoring.migrateto.androidx", new Object[0]));
            }
            return false;
        }
        refUsages.set((Object)filtered);
        this.setPreviewUsages(true);
        return true;
    }

    private final void finishFindMigration() {
        block0: {
            PsiMigrationManager psiMigrationManager = PsiMigrationManager.getInstance((Project)this.project);
            if (psiMigrationManager == null || (psiMigrationManager = psiMigrationManager.getCurrentMigration()) == null) break block0;
            psiMigrationManager.finish();
        }
    }

    private final List<MigrateToAppCompatUsageInfo> findUsagesInBuildFiles(Project project, Map<Pair<String, String>, ? extends AppCompatMigrationEntry.GradleMigrationEntry> gradleDependencyEntries) {
        List gradleUsages = new ArrayList();
        if (gradleDependencyEntries.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(project);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel2, (String)"get(project)");
        ProjectBuildModel projectBuildModel3 = projectBuildModel2;
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getInstance(project).modules");
        for (Module module2 : moduleArray) {
            ResolvedPropertyModel resolvedPropertyModel;
            AndroidModel androidBlock;
            DependenciesModel dependencies2;
            GradleBuildModel gradleBuildModel;
            if (projectBuildModel3.getModuleBuildModel(module2) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)gradleBuildModel.dependencies(), (String)"gradleBuildModel.dependencies()");
            for (DependencyModel dependencyModel : dependencies2.all()) {
                PsiElement psiElement;
                GradleCoordinate migrationEntryCoordinates;
                AppCompatMigrationEntry.GradleMigrationEntry entry;
                Pair key;
                GradleCoordinate gc;
                String compactDependencyNotation;
                if (!(dependencyModel instanceof ArtifactDependencyModel)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)((ArtifactDependencyModel)dependencyModel).compactNotation(), (String)"dep.compactNotation()");
                if (((ArtifactDependencyModel)dependencyModel).completeModel().getResultModel().getExpressionPsiElement() == null || GradleCoordinate.parseCoordinateString((String)compactDependencyNotation) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)Pair.create((Object)gc.getGroupId(), (Object)gc.getArtifactId()), (String)"create(gc.groupId, gc.artifactId)");
                if (gradleDependencyEntries.get(key) == null || GradleCoordinate.parseCoordinateString((String)entry.toCompactNotation(entry.getNewBaseVersion())) == null || gc.isSameArtifact(migrationEntryCoordinates) && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(migrationEntryCoordinates, gc) <= 0) continue;
                Function3<String, String, String, String> function3 = this.versionProvider;
                gradleUsages.add(new MigrateToAppCompatUsageInfo.GradleDependencyUsageInfo(psiElement, projectBuildModel3, (ArtifactDependencyModel)dependencyModel, entry, new MigrateToAppCompatUsageInfo.TriFunction(function3){
                    private final /* synthetic */ Function3 function;
                    {
                        this.function = function;
                    }

                    public final /* synthetic */ Object apply(Object a, Object b, Object c) {
                        return this.function.invoke(a, b, c);
                    }
                }));
            }
            Intrinsics.checkNotNullExpressionValue((Object)gradleBuildModel.android(), (String)"gradleBuildModel.android()");
            List<ProductFlavorModel> list2 = androidBlock.productFlavors();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"androidBlock.productFlavors()");
            for (ProductFlavorModel flavorBlock : CollectionsKt.plus((Collection)list2, (Object)androidBlock.defaultConfig())) {
                String runnerName;
                String newRunnerName;
                GradlePropertyModel runnerModel;
                Intrinsics.checkNotNullExpressionValue((Object)flavorBlock.testInstrumentationRunner().getResultModel(), (String)"flavorBlock.testInstrume\u2026ationRunner().resultModel");
                if (runnerModel.getValue(GradlePropertyModel.STRING_TYPE) == null || Intrinsics.areEqual((Object)(newRunnerName = AndroidxNameUtils.getNewName((String)runnerName)), (Object)runnerName)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)newRunnerName, (String)"newRunnerName");
                MigrateToAndroidxProcessor.findUsagesInBuildFiles$addStringUsage(gradleUsages, gradleBuildModel, runnerModel, runnerName, newRunnerName);
            }
            Intrinsics.checkNotNullExpressionValue((Object)androidBlock.testOptions().execution(), (String)"androidBlock.testOptions().execution()");
            String executionValue = resolvedPropertyModel.getValue(GradlePropertyModel.STRING_TYPE);
            if (!StringsKt.equals((String)executionValue, (String)IdeTestOptions.Execution.ANDROID_TEST_ORCHESTRATOR.name(), (boolean)true)) continue;
            GradlePropertyModel gradlePropertyModel = resolvedPropertyModel;
            String string = executionValue;
            Intrinsics.checkNotNull((Object)string);
            MigrateToAndroidxProcessor.findUsagesInBuildFiles$addStringUsage(gradleUsages, gradleBuildModel, gradlePropertyModel, string, IdeTestOptions.Execution.ANDROIDX_TEST_ORCHESTRATOR.name());
        }
        if (!((Collection)gradleUsages).isEmpty()) {
            for (Object e : AddGoogleMavenRepositoryHyperlink.getBuildFileForPlugin(project)) {
                GradleBuildModel gradleBuildModel;
                Intrinsics.checkNotNullExpressionValue(e, (String)"AddGoogleMavenRepository\u2026ildFileForPlugin(project)");
                VirtualFile file2 = (VirtualFile)e;
                Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel3.getModuleBuildModel(file2), (String)"projectBuildModel.getModuleBuildModel(file)");
                RepositoriesModel repositoriesModel = gradleBuildModel.buildscript().repositories();
                Intrinsics.checkNotNullExpressionValue((Object)repositoriesModel, (String)"gradleBuildModel.buildscript().repositories()");
                MigrateToAndroidxProcessor.findUsagesInBuildFiles$addGoogleRepoUsage(gradleUsages, projectBuildModel3, repositoriesModel);
                RepositoriesModel repositoriesModel2 = gradleBuildModel.repositories();
                Intrinsics.checkNotNullExpressionValue((Object)repositoriesModel2, (String)"gradleBuildModel.repositories()");
                MigrateToAndroidxProcessor.findUsagesInBuildFiles$addGoogleRepoUsage(gradleUsages, projectBuildModel3, repositoriesModel2);
            }
        }
        return gradleUsages;
    }

    /*
     * WARNING - void declaration
     */
    private static final void findUsagesInBuildFiles$addStringUsage(List<MigrateToAppCompatUsageInfo> gradleUsages, GradleBuildModel gradleBuildModel, GradlePropertyModel model2, String oldString, String newString) {
        PsiElement psiElement = model2.getPsiElement();
        if (psiElement == null) {
            return;
        }
        PsiElement psiElement2 = psiElement;
        if (Intrinsics.areEqual((Object)model2.getValue(GradlePropertyModel.STRING_TYPE), (Object)oldString)) {
            model2.setValue(newString);
            gradleUsages.add(new MigrateToAppCompatUsageInfo.GradleStringUsageInfo(psiElement2, newString, gradleBuildModel));
        } else {
            void $this$filterTo$iv$iv;
            Collection collection2 = PsiTreeUtil.findChildrenOfType((PsiElement)psiElement2, PsiElement.class);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"findChildrenOfType(psiEl\u2026, PsiElement::class.java)");
            Iterable $this$filter$iv = collection2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PsiElement it = (PsiElement)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getText(), (Object)oldString)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (PsiElement literal : (List)destination$iv$iv) {
                gradleUsages.add(new MigrateToAppCompatUsageInfo.GradleStringUsageInfo(literal, newString, gradleBuildModel));
            }
        }
    }

    private static final void findUsagesInBuildFiles$addGoogleRepoUsage(List<MigrateToAppCompatUsageInfo> gradleUsages, ProjectBuildModel projectBuildModel2, RepositoriesModel repositoriesModel) {
        PsiElement repositoriesModelPsiElement;
        if (!repositoriesModel.hasGoogleMavenRepository() && (repositoriesModelPsiElement = repositoriesModel.getPsiElement()) != null) {
            gradleUsages.add(new MigrateToAppCompatUsageInfo.AddGoogleRepositoryUsageInfo(projectBuildModel2, repositoriesModel, repositoriesModelPsiElement));
        }
    }

    public static final /* synthetic */ void access$finishFindMigration(MigrateToAndroidxProcessor $this) {
        $this.finishFindMigration();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"Lorg/jetbrains/android/refactoring/MigrateToAndroidxProcessor$KotlinFileWrapper;", "Lcom/intellij/usageView/UsageInfo;", "delegate", "(Lcom/intellij/usageView/UsageInfo;)V", "getDelegate", "()Lcom/intellij/usageView/UsageInfo;", "getFile", "Lcom/intellij/psi/PsiFile;", "isKotlinOptimizerCall", "", "intellij.android.projectSystem.gradle"})
    private static final class KotlinFileWrapper
    extends UsageInfo {
        @NotNull
        private final UsageInfo delegate;

        public KotlinFileWrapper(@NotNull UsageInfo delegate2) {
            Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
            super(delegate2.getSmartPointer(), delegate2.getPsiFileRange(), delegate2.isDynamicUsage(), delegate2.isNonCodeUsage);
            this.delegate = delegate2;
        }

        @NotNull
        public final UsageInfo getDelegate() {
            return this.delegate;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isKotlinOptimizerCall() {
            boolean bl;
            block4: {
                void $this$mapTo$iv$iv;
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"currentThread().stackTrace");
                Iterable $this$map$iv = ArraysKt.take((Object[])stackTraceElementArray, (int)5);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    StackTraceElement stackTraceElement = (StackTraceElement)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    collection2.add(it.getClassName());
                }
                Iterable $this$any$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(KotlinOptimizeImportsRefactoringHelper.class).getQualifiedName(), (Object)it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Nullable
        public PsiFile getFile() {
            return this.isKotlinOptimizerCall() ? (PsiFile)null : super.getFile();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J&\u0010\u0016\u001a\u00020\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0002R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/android/refactoring/MigrateToAndroidxProcessor$UsageAccumulator;", "", "()V", "fileToRangeMap", "", "Lcom/intellij/psi/PsiFile;", "Lcom/google/common/collect/RangeMap;", "", "Lcom/intellij/usageView/UsageInfo;", "usageInfos", "", "getUsageInfos", "()Ljava/util/List;", "addAll", "", "infos", "", "checkOverlappingUsages", "", "getInfoUsageRange", "Lcom/intellij/openapi/util/Segment;", "info", "hasOverlappingUsage", "rangeMap", "segment", "intellij.android.projectSystem.gradle"})
    public static final class UsageAccumulator {
        @NotNull
        private final List<UsageInfo> usageInfos = new ArrayList();
        @NotNull
        private final Map<PsiFile, RangeMap<Integer, UsageInfo>> fileToRangeMap = new LinkedHashMap();

        @NotNull
        public final List<UsageInfo> getUsageInfos() {
            return this.usageInfos;
        }

        private final Segment getInfoUsageRange(UsageInfo info2) {
            PsiElement element2 = info2.getElement();
            if (info2 instanceof MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo && !(element2 instanceof PsiPackage)) {
                PsiElement psiElement;
                PsiElement psiElement2 = element2;
                if (!Intrinsics.areEqual((Object)(psiElement2 != null ? psiElement2.getText() : null), (Object)((MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo)info2).mapEntry.myOldName) && Intrinsics.areEqual((Object)((psiElement = element2) != null && (psiElement = psiElement.getParent()) != null ? psiElement.getText() : null), (Object)((MigrateToAppCompatUsageInfo.PackageMigrationUsageInfo)info2).mapEntry.myOldName)) {
                    return (Segment)element2.getParent().getTextRange();
                }
            }
            return info2.getSmartPointer().getPsiRange();
        }

        private final boolean hasOverlappingUsage(RangeMap<Integer, UsageInfo> rangeMap, Segment segment) {
            Segment segment2 = segment;
            if (segment2 == null) {
                return false;
            }
            int startOffset = segment2.getStartOffset();
            return rangeMap.get((Comparable)Integer.valueOf(startOffset)) != null;
        }

        public final void addAll(@NotNull List<? extends UsageInfo> infos, boolean checkOverlappingUsages) {
            Intrinsics.checkNotNullParameter(infos, (String)"infos");
            for (UsageInfo usageInfo : infos) {
                PsiFile containingFile;
                if (usageInfo.getSmartPointer().getContainingFile() == null) continue;
                TreeRangeMap treeRangeMap = TreeRangeMap.create();
                Intrinsics.checkNotNullExpressionValue((Object)treeRangeMap, (String)"create()");
                RangeMap<Integer, UsageInfo> rangeMap = this.fileToRangeMap.getOrDefault(containingFile, (RangeMap<Integer, UsageInfo>)treeRangeMap);
                Segment segment = this.getInfoUsageRange(usageInfo);
                if (checkOverlappingUsages && this.hasOverlappingUsage(rangeMap, segment)) continue;
                if (segment != null) {
                    Segment it;
                    boolean bl = false;
                    rangeMap.put(Range.closed((Comparable)Integer.valueOf(it.getStartOffset()), (Comparable)Integer.valueOf(it.getEndOffset())), (Object)usageInfo);
                }
                this.fileToRangeMap.put(containingFile, rangeMap);
                this.usageInfos.add(usageInfo);
            }
        }

        public static /* synthetic */ void addAll$default(UsageAccumulator usageAccumulator, List list2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            usageAccumulator.addAll(list2, bl);
        }
    }
}

