/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.repository.AgpVersion;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.support.AndroidxMigrationParserKt;
import com.android.support.MigrationParserVisitor;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.api.util.PsiElementHolder;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.AppCompatMigrationEntry;
import org.jetbrains.android.refactoring.MigrateToAndroidxProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J/\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0097\u0002J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0097\u0002\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0003J\u001c\u0010!\u001a\u0004\u0018\u00010\"*\u0010\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010%0#H\u0002J\u000e\u0010&\u001a\u0004\u0018\u00010\"*\u00020'H\u0002R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006("}, d2={"Lorg/jetbrains/android/refactoring/MigrateToAndroidxHandler;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "showWarningDialog", "", "callSyncAfterMigration", "checkPrerequisites", "(ZZZ)V", "getCallSyncAfterMigration", "()Z", "setCallSyncAfterMigration", "(Z)V", "getCheckPrerequisites", "setCheckPrerequisites", "getShowWarningDialog", "setShowWarningDialog", "checkRefactoringPrerequisites", "project", "Lcom/intellij/openapi/project/Project;", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "parseMigrationMap", "", "Lorg/jetbrains/android/refactoring/AppCompatMigrationEntry;", "findBuildSdk", "Lcom/android/sdklib/AndroidVersion;", "Lkotlin/Pair;", "Lcom/intellij/openapi/module/Module;", "Lcom/android/tools/idea/gradle/dsl/api/GradleBuildModel;", "toAndroidVersion", "", "intellij.android.projectSystem.gradle"})
public final class MigrateToAndroidxHandler
implements RefactoringActionHandler {
    private boolean showWarningDialog;
    private boolean callSyncAfterMigration;
    private boolean checkPrerequisites;

    public MigrateToAndroidxHandler(boolean showWarningDialog, boolean callSyncAfterMigration, boolean checkPrerequisites) {
        this.showWarningDialog = showWarningDialog;
        this.callSyncAfterMigration = callSyncAfterMigration;
        this.checkPrerequisites = checkPrerequisites;
    }

    public /* synthetic */ MigrateToAndroidxHandler(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            bl3 = true;
        }
        this(bl, bl2, bl3);
    }

    public final boolean getShowWarningDialog() {
        return this.showWarningDialog;
    }

    public final void setShowWarningDialog(boolean bl) {
        this.showWarningDialog = bl;
    }

    public final boolean getCallSyncAfterMigration() {
        return this.callSyncAfterMigration;
    }

    public final void setCallSyncAfterMigration(boolean bl) {
        this.callSyncAfterMigration = bl;
    }

    public final boolean getCheckPrerequisites() {
        return this.checkPrerequisites;
    }

    public final void setCheckPrerequisites(boolean bl) {
        this.checkPrerequisites = bl;
    }

    @UiThread
    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file2, @Nullable DataContext dataContext) {
        PsiElement[] psiElementArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (file2 == null) {
            psiElementArray = new PsiElement[]{};
        } else {
            PsiElement[] psiElementArray2 = new PsiElement[]{(PsiElement)file2};
            psiElementArray = psiElementArray2;
        }
        this.invoke(project, psiElementArray, dataContext);
    }

    @UiThread
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if (this.checkPrerequisites && !this.checkRefactoringPrerequisites(project)) {
            return;
        }
        Function0 runProcessor2 = (Function0)new Function0<Unit>(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ MigrateToAndroidxHandler this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                MigrateToAndroidxProcessor processor;
                MigrateToAndroidxProcessor $this$invoke_u24lambda_u2d0 = processor = new MigrateToAndroidxProcessor(this.$project, MigrateToAndroidxHandler.access$parseMigrationMap(this.this$0), null, this.this$0.getCallSyncAfterMigration(), 4, null);
                boolean bl = false;
                $this$invoke_u24lambda_u2d0.setPreviewUsages(true);
                $this$invoke_u24lambda_u2d0.run();
            }
        };
        if (this.showWarningDialog) {
            AndroidRefactoringUtil.offerToCreateBackupAndRun(project, "Migrate to AndroidX", (Function0<Unit>)runProcessor2);
        } else {
            runProcessor2.invoke();
        }
    }

    private final AndroidVersion toAndroidVersion(String $this$toAndroidVersion) {
        return AndroidTargetHash.getPlatformVersion((String)$this$toAndroidVersion);
    }

    private final AndroidVersion findBuildSdk(Pair<? extends Module, ? extends GradleBuildModel> $this$findBuildSdk) {
        String string;
        ResolvedPropertyModel resolvedPropertyModel;
        AndroidModel androidModel;
        GradleBuildModel gradleBuildModel = (GradleBuildModel)$this$findBuildSdk.getSecond();
        AndroidVersion modelVersion = gradleBuildModel != null && (androidModel = gradleBuildModel.android()) != null && (resolvedPropertyModel = androidModel.compileSdkVersion()) != null && (string = resolvedPropertyModel.toString()) != null ? this.toAndroidVersion(string) : null;
        Object object = modelVersion;
        if (object == null) {
            AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance((Module)$this$findBuildSdk.getFirst());
            object = androidModuleInfo != null ? androidModuleInfo.getBuildSdkVersion() : null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkRefactoringPrerequisites(Project project) {
        boolean supportedAgpVersion;
        boolean bl;
        String agpVersionString;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        PsiElementHolder it;
        Collection collection2;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv;
        Pair it$iv$iv;
        Module it2;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv3;
        void $this$mapNotNull$iv2;
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(project);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel2, (String)"get(project)");
        ProjectBuildModel buildModel = projectBuildModel2;
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getInstance(project).modules");
        Object[] objectArray = moduleArray;
        boolean $i$f$mapNotNull22 = false;
        void var6_7 = $this$mapNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            element$iv$iv = element$iv$iv$iv;
            boolean bl2 = false;
            it2 = (Module)element$iv$iv;
            boolean bl3 = false;
            if (TuplesKt.to((Object)it2, (Object)buildModel.getModuleBuildModel(it2)) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List moduleModels = (List)destination$iv$iv;
        Iterable $i$f$mapNotNull22 = moduleModels;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv2) {
            element$iv$iv = element$iv$iv$iv;
            boolean bl5 = false;
            it2 = (Pair)element$iv$iv;
            boolean bl6 = false;
            if (this.findBuildSdk((Pair<? extends Module, ? extends GradleBuildModel>)it2) == null) continue;
            boolean bl7 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        AndroidVersion highestCompileSdkVersion = (AndroidVersion)CollectionsKt.lastOrNull((List)CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)));
        boolean supportedCompileSdk = highestCompileSdkVersion != null ? new AndroidVersion(28).compareTo(highestCompileSdkVersion) <= 0 || highestCompileSdkVersion.getCodename() != null : true;
        Iterable $this$mapNotNull$iv3 = moduleModels;
        boolean $i$f$mapNotNull3 = false;
        Iterable $i$f$mapNotNullTo22 = $this$mapNotNull$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        element$iv$iv = $this$forEach$iv$iv$iv3.iterator();
        while (element$iv$iv.hasNext()) {
            GradleBuildModel it$iv$iv2;
            Object element$iv$iv$iv;
            Object element$iv$iv2 = element$iv$iv$iv = element$iv$iv.next();
            boolean bl8 = false;
            Pair it3 = (Pair)element$iv$iv2;
            boolean bl9 = false;
            if ((GradleBuildModel)it3.getSecond() == null) continue;
            boolean bl10 = false;
            destination$iv$iv3.add(it$iv$iv2);
        }
        $this$mapNotNull$iv3 = (List)destination$iv$iv3;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            element$iv$iv = (GradleBuildModel)item$iv$iv;
            collection2 = destination$iv$iv3;
            boolean bl11 = false;
            collection2.add(it.buildscript().dependencies());
        }
        $this$map$iv = (List)destination$iv$iv3;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv3 : $this$flatMapTo$iv$iv) {
            it = (DependenciesModel)element$iv$iv3;
            boolean bl12 = false;
            List<ArtifactDependencyModel> list2 = it.artifacts();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"it.artifacts()");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv3;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv4 : $this$filterTo$iv$iv) {
            it = (ArtifactDependencyModel)element$iv$iv4;
            boolean bl13 = false;
            if (!(Intrinsics.areEqual((Object)it.name().forceString(), (Object)"gradle") && Intrinsics.areEqual((Object)it.group().forceString(), (Object)"com.android.tools.build"))) continue;
            destination$iv$iv3.add(element$iv$iv4);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ArtifactDependencyModel)item$iv$iv;
            collection2 = destination$iv$iv3;
            boolean bl14 = false;
            collection2.add(it.version().getValue(GradlePropertyModel.STRING_TYPE));
        }
        String string = agpVersionString = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv3));
        boolean bl15 = string != null ? !StringsKt.startsWith$default((CharSequence)string, (char)'$', (boolean)false, (int)2, null) : false;
        if (bl15) {
            AgpVersion agpVersion = AgpVersion.Companion.tryParse(agpVersionString);
            bl = agpVersion != null ? agpVersion.isAtLeastIncludingPreviews(3, 2, 0) : false;
        } else {
            bl = supportedAgpVersion = true;
        }
        if (supportedCompileSdk && supportedAgpVersion) {
            return true;
        }
        String warningContent = (!supportedCompileSdk ? "You need to have compileSdk set to at least 28 in your module build.gradle to migrate to AndroidX." : "") + (!supportedAgpVersion ? "The gradle plugin version in your project build.gradle file needs to be set to at least com.android.tools.build:gradle:3.2.0 in order to migrate to AndroidX." : "");
        Messages.showErrorDialog((String)warningContent, (String)"Unable to migrate to AndroidX");
        return false;
    }

    @VisibleForTesting
    private final List<AppCompatMigrationEntry> parseMigrationMap() {
        List classesAndCoordinates = new ArrayList();
        List packages = new ArrayList();
        AndroidxMigrationParserKt.parseMigrationFile((MigrationParserVisitor)new MigrationParserVisitor(classesAndCoordinates, packages){
            final /* synthetic */ List<AppCompatMigrationEntry> $classesAndCoordinates;
            final /* synthetic */ List<AppCompatMigrationEntry.PackageMigrationEntry> $packages;
            {
                this.$classesAndCoordinates = $classesAndCoordinates;
                this.$packages = $packages;
            }

            public void visitClass(@NotNull String old2, @NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)old2, (String)"old");
                Intrinsics.checkNotNullParameter((Object)string, (String)"new");
                this.$classesAndCoordinates.add(new AppCompatMigrationEntry.ClassMigrationEntry(old2, string));
            }

            public void visitPackage(@NotNull String old2, @NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)old2, (String)"old");
                Intrinsics.checkNotNullParameter((Object)string, (String)"new");
                this.$packages.add(new AppCompatMigrationEntry.PackageMigrationEntry(old2, string));
            }

            public void visitGradleCoordinate(@NotNull String oldGroupName, @NotNull String oldArtifactName, @NotNull String newGroupName, @NotNull String newArtifactName, @NotNull String newBaseVersion) {
                Intrinsics.checkNotNullParameter((Object)oldGroupName, (String)"oldGroupName");
                Intrinsics.checkNotNullParameter((Object)oldArtifactName, (String)"oldArtifactName");
                Intrinsics.checkNotNullParameter((Object)newGroupName, (String)"newGroupName");
                Intrinsics.checkNotNullParameter((Object)newArtifactName, (String)"newArtifactName");
                Intrinsics.checkNotNullParameter((Object)newBaseVersion, (String)"newBaseVersion");
                this.$classesAndCoordinates.add(new AppCompatMigrationEntry.GradleDependencyMigrationEntry(oldGroupName, oldArtifactName, newGroupName, newArtifactName, newBaseVersion));
            }

            public void visitGradleCoordinateUpgrade(@NotNull String groupName, @NotNull String artifactName, @NotNull String newBaseVersion) {
                Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
                Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
                Intrinsics.checkNotNullParameter((Object)newBaseVersion, (String)"newBaseVersion");
                this.$classesAndCoordinates.add(new AppCompatMigrationEntry.UpdateGradleDependencyVersionMigrationEntry(groupName, artifactName, newBaseVersion));
            }
        });
        List $this$sortByDescending$iv = packages;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AppCompatMigrationEntry.PackageMigrationEntry it = (AppCompatMigrationEntry.PackageMigrationEntry)b;
                    boolean bl = false;
                    it = (AppCompatMigrationEntry.PackageMigrationEntry)a;
                    Comparable comparable = Integer.valueOf(it.myOldName.length());
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.myOldName.length()));
                }
            });
        }
        classesAndCoordinates.addAll(packages);
        return classesAndCoordinates;
    }

    public MigrateToAndroidxHandler() {
        this(false, false, false, 7, null);
    }

    public static final /* synthetic */ List access$parseMigrationMap(MigrateToAndroidxHandler $this) {
        return $this.parseMigrationMap();
    }
}

