/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExtractStyleDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JTextField myStyleNameField;
    private JPanel myAttributeListWrapper;
    private JBLabel myAttributesLabel;
    private JBLabel myModuleLabel;
    private ModulesComboBox myModuleCombo;
    private JBCheckBox mySearchForStyleApplicationsAfter;
    private final Module myModule;
    private final String myFileName;
    private final List<String> myDirNames;
    private final CheckboxTree myTree;
    private final CheckedTreeNode myRootNode;
    private static final String SEARCH_STYLE_APPLICATIONS_PROPERTY = "AndroidExtractStyleSearchStyleApplications";

    public ExtractStyleDialog(@NotNull Module module2, @NotNull String fileName, @Nullable String parentStyleName, @NotNull List<String> dirNames, @NotNull List<XmlAttribute> attributes) {
        super(module2.getProject());
        this.myFileName = fileName;
        this.myDirNames = dirNames;
        this.$$$setupUI$$$();
        if (parentStyleName != null && !parentStyleName.isEmpty()) {
            this.myStyleNameField.setText(parentStyleName + ".");
            this.myStyleNameField.selectAll();
        } else {
            String prefix = IdeResourcesUtil.prependResourcePrefix(module2, null, ResourceFolderType.VALUES);
            if (prefix != null) {
                this.myStyleNameField.setText(prefix);
            }
        }
        HashSet<Module> modulesSet = new HashSet<Module>();
        modulesSet.add(module2);
        for (AndroidFacet depFacet : AndroidDependenciesCache.getAllAndroidDependencies(module2, true)) {
            modulesSet.add(depFacet.getModule());
        }
        assert (!modulesSet.isEmpty());
        if (modulesSet.size() == 1) {
            this.myModule = module2;
            this.myModuleLabel.setVisible(false);
            this.myModuleCombo.setVisible(false);
        } else {
            this.myModule = null;
            this.myModuleCombo.setModules(modulesSet);
            this.myModuleCombo.setSelectedModule(module2);
        }
        this.myRootNode = new CheckedTreeNode(null);
        for (XmlAttribute attribute : attributes) {
            this.myRootNode.add((MutableTreeNode)new CheckedTreeNode((Object)attribute));
        }
        CheckboxTree.CheckboxTreeCellRenderer renderer2 = new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                XmlAttribute attribute;
                if (value2 instanceof CheckedTreeNode && (attribute = (XmlAttribute)((CheckedTreeNode)value2).getUserObject()) != null) {
                    this.getTextRenderer().append(attribute.getLocalName());
                    this.getTextRenderer().append(" [" + attribute.getValue() + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        };
        this.myTree = new CheckboxTree(renderer2, this.myRootNode){

            protected void installSpeedSearch() {
                new TreeSpeedSearch((Tree)this, (Convertor)new Convertor<TreePath, String>(){

                    public String convert(TreePath path2) {
                        XmlAttribute attribute;
                        Object object = path2.getLastPathComponent();
                        if (object instanceof CheckedTreeNode && (attribute = (XmlAttribute)((CheckedTreeNode)object).getUserObject()) != null) {
                            return attribute.getLocalName();
                        }
                        return "";
                    }
                });
            }
        };
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        TreeUtil.expandAll((JTree)this.myTree);
        this.myAttributesLabel.setLabelFor((Component)this.myTree);
        ToolbarDecorator decorator2 = ToolbarDecorator.createDecorator((JTree)this.myTree);
        decorator2.setToolbarPosition(ActionToolbarPosition.RIGHT);
        decorator2.setEditAction(null);
        decorator2.disableUpDownActions();
        AnActionButton selectAll = new AnActionButton("Select All", null, PlatformIcons.SELECT_ALL_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ExtractStyleDialog.this.setChecked(true);
            }
        };
        decorator2.addExtraAction(selectAll);
        AnActionButton unselectAll = new AnActionButton("Unselect All", null, PlatformIcons.UNSELECT_ALL_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ExtractStyleDialog.this.setChecked(false);
            }
        };
        decorator2.addExtraAction(unselectAll);
        this.myAttributeListWrapper.add(decorator2.createPanel());
        String value2 = PropertiesComponent.getInstance().getValue(SEARCH_STYLE_APPLICATIONS_PROPERTY);
        this.mySearchForStyleApplicationsAfter.setSelected(Boolean.parseBoolean(value2));
        this.init();
    }

    private void setChecked(boolean value2) {
        int count2 = this.myRootNode.getChildCount();
        for (int i = 0; i < count2; ++i) {
            ((CheckedTreeNode)this.myRootNode.getChildAt(i)).setChecked(value2);
        }
        this.myTree.repaint();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        super.doOKAction();
        PropertiesComponent.getInstance().setValue(SEARCH_STYLE_APPLICATIONS_PROPERTY, Boolean.toString(this.mySearchForStyleApplicationsAfter.isSelected()));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myStyleNameField;
    }

    protected ValidationInfo doValidate() {
        String styleName = this.getStyleName();
        if (styleName.isEmpty()) {
            return new ValidationInfo("specify style name", (JComponent)this.myStyleNameField);
        }
        if (!IdeResourcesUtil.isCorrectAndroidResourceName(styleName)) {
            return new ValidationInfo("incorrect style name", (JComponent)this.myStyleNameField);
        }
        Module module2 = this.getChosenModule();
        if (module2 == null) {
            return new ValidationInfo("specify module", (JComponent)this.myModuleCombo);
        }
        VirtualFile resourceDir = this.getResourceDirectory();
        if (resourceDir == null) {
            return new ValidationInfo("specify a module with resources", (JComponent)this.myModuleCombo);
        }
        return CreateXmlResourceDialog.checkIfResourceAlreadyExists(module2.getProject(), resourceDir, this.getStyleName(), null, ResourceType.STYLE, this.myDirNames, this.myFileName);
    }

    @NotNull
    public String getStyleName() {
        return this.myStyleNameField.getText().trim();
    }

    @NotNull
    public List<XmlAttribute> getStyledAttributes() {
        ArrayList<XmlAttribute> attributes = new ArrayList<XmlAttribute>();
        int count2 = this.myRootNode.getChildCount();
        for (int i = 0; i < count2; ++i) {
            CheckedTreeNode treeNode = (CheckedTreeNode)this.myRootNode.getChildAt(i);
            if (!treeNode.isChecked()) continue;
            attributes.add((XmlAttribute)treeNode.getUserObject());
        }
        return attributes;
    }

    @Nullable
    private Module getChosenModule() {
        return this.myModule != null ? this.myModule : this.myModuleCombo.getSelectedModule();
    }

    @Nullable
    public VirtualFile getResourceDirectory() {
        Module module2 = this.getChosenModule();
        if (module2 == null) {
            return null;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return null;
        }
        return ResourceFolderManager.getInstance(facet2).getPrimaryFolder();
    }

    public boolean isToSearchStyleApplications() {
        return this.mySearchForStyleApplicationsAfter.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        ModulesComboBox modulesComboBox;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JTextField jTextField;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Style name:");
        jBLabel3.setDisplayedMnemonic('S');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStyleNameField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAttributeListWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(-1, 200), null));
        this.myAttributesLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Attributes:");
        jBLabel2.setDisplayedMnemonic('A');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myModuleLabel = jBLabel = new JBLabel();
        jBLabel.setText("Module:");
        jBLabel.setDisplayedMnemonic('M');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleCombo = modulesComboBox = new ModulesComboBox();
        jPanel2.add((Component)modulesComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.mySearchForStyleApplicationsAfter = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Launch 'Use Style Where Possible' refactoring after the style is extracted");
        jBCheckBox.setMnemonic('L');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        jBLabel3.setLabelFor(jTextField);
        jBLabel.setLabelFor((Component)modulesComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

