/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.tools.idea.res.AndroidRClassBase;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.compiled.ClsFieldImpl;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.ManifestClass;
import org.jetbrains.android.refactoring.AndroidResourceReferenceInCodeUsageTypeProvider;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/android/refactoring/AndroidResourceReferenceInCodeUsageTypeProvider;", "Lcom/intellij/usages/impl/rules/UsageTypeProvider;", "()V", "getUsageType", "Lcom/intellij/usages/impl/rules/UsageType;", "element", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.android.core"})
public final class AndroidResourceReferenceInCodeUsageTypeProvider
implements UsageTypeProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final UsageType RESOURCE_REFERENCE_IN_CODE = new UsageType(AndroidBundle.messagePointer("android.usageType.resource.reference.code", new Object[0]));
    @NotNull
    private static final UsageType PERMISSION_REFERENCE_IN_CODE = new UsageType(AndroidBundle.messagePointer("android.usageType.permission.reference.code", new Object[0]));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public UsageType getUsageType(@NotNull PsiElement element2) {
        UsageType usageType;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!(element2 instanceof PsiReferenceExpression) && !(element2 instanceof KtSimpleNameExpression)) {
            return null;
        }
        PsiReference[] psiReferenceArray = element2.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"element.references");
        PsiField field2 = (PsiField)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])psiReferenceArray), (Function1)getUsageType.field.1.INSTANCE));
        if (field2 instanceof AndroidLightField) {
            PsiClass psiClass = ((AndroidLightField)field2).getContainingClass().getContainingClass();
            if (psiClass instanceof ManifestClass) {
                usageType = PERMISSION_REFERENCE_IN_CODE;
                return usageType;
            } else {
                if (!(psiClass instanceof AndroidRClassBase)) return null;
                usageType = RESOURCE_REFERENCE_IN_CODE;
            }
            return usageType;
        }
        if (!(field2 instanceof ClsFieldImpl)) return null;
        PsiClass psiClass2 = ((ClsFieldImpl)field2).getContainingClass();
        psiClass2 = psiClass2;
        if (psiClass == null) return null;
        PsiClass psiClass2 = psiClass2.getContainingClass();
        psiClass2 = psiClass2;
        if (psiClass3 == null) return null;
        String string = psiClass2.getQualifiedName();
        String string2 = string;
        if (string2 == null) return null;
        int n = -1;
        switch (string2.hashCode()) {
            case 167516910: {
                if (string2.equals("android.Manifest")) {
                    n = 1;
                }
                break;
            }
            case 1131699347: {
                if (string2.equals("android.R")) {
                    n = 2;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                usageType = PERMISSION_REFERENCE_IN_CODE;
                return usageType;
            }
            case 2: {
                usageType = RESOURCE_REFERENCE_IN_CODE;
                return usageType;
            }
            default: {
                return null;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/android/refactoring/AndroidResourceReferenceInCodeUsageTypeProvider$Companion;", "", "()V", "PERMISSION_REFERENCE_IN_CODE", "Lcom/intellij/usages/impl/rules/UsageType;", "RESOURCE_REFERENCE_IN_CODE", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

