/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceType;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.dom.converters.AndroidResourceReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidInlineUtil;
import org.jetbrains.android.refactoring.StyleUsageData;
import org.jetbrains.android.refactoring.errorreporter.HintBasedErrorReporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AndroidInlineStyleHandler
extends InlineActionHandler {
    private static AndroidInlineTestConfig ourTestConfig;

    @TestOnly
    public static void setTestConfig(@Nullable AndroidInlineTestConfig testConfig) {
        ourTestConfig = testConfig;
    }

    public boolean isEnabledForLanguage(Language l) {
        return l == XMLLanguage.INSTANCE || l == Language.ANY;
    }

    public boolean canInlineElement(PsiElement element2) {
        if (element2 instanceof ResourceReferencePsiElement) {
            return ((ResourceReferencePsiElement)element2).getResourceReference().getResourceType().equals((Object)ResourceType.STYLE);
        }
        return element2 != null && AndroidFacet.getInstance((PsiElement)element2) != null && AndroidInlineUtil.getInlinableStyleDataFromContext(element2) != null;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element2) {
        PsiElement[] targetElements;
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor);
        if (psiReference == null) {
            return;
        }
        PsiElement destination = psiReference instanceof AndroidResourceReference ? ((targetElements = ((AndroidResourceReference)psiReference).computeTargetElements()).length > 0 ? targetElements[0] : psiReference.getElement()) : psiReference.getElement();
        AndroidInlineUtil.MyStyleData data2 = AndroidInlineUtil.getInlinableStyleDataFromContext(destination);
        if (data2 != null) {
            HintBasedErrorReporter reporter = new HintBasedErrorReporter(editor);
            StyleUsageData usageData = AndroidInlineStyleHandler.getUsageDataFromEditor(psiReference);
            AndroidInlineUtil.doInlineStyleDeclaration(project, data2, usageData, reporter, ourTestConfig);
        }
    }

    @Nullable
    private static StyleUsageData getUsageDataFromEditor(@NotNull PsiReference reference) {
        PsiElement usageElement = reference.getElement();
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)usageElement, XmlTag.class, (boolean)false);
        return tag != null ? AndroidInlineUtil.getStyleUsageData(tag) : null;
    }

    @Nullable
    public String getActionName(PsiElement element2) {
        return "Inline Android Style";
    }
}

