/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidInlineUtil;
import org.jetbrains.android.refactoring.AndroidRefactoringErrorException;
import org.jetbrains.android.refactoring.LayoutUsageData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidInlineLayoutProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.refactoring.AndroidInlineLayoutProcessor");
    private final XmlFile myLayoutFile;
    private final XmlTag myLayoutRootTag;
    private final PsiElement myUsageElement;
    private final AndroidInlineTestConfig myTestConfig;

    protected AndroidInlineLayoutProcessor(@NotNull Project project, @NotNull XmlFile file2, @NotNull XmlTag rootTag, @Nullable PsiElement usageElement, @Nullable AndroidInlineTestConfig config2) {
        super(project);
        this.myLayoutFile = file2;
        this.myLayoutRootTag = rootTag;
        this.myUsageElement = usageElement;
        this.myTestConfig = config2;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new UsageViewDescriptor(){

            @NotNull
            public PsiElement[] getElements() {
                return new PsiElement[]{AndroidInlineLayoutProcessor.this.myLayoutFile};
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "References to be inlined" + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
            }

            public String getProcessedElementsHeader() {
                return "Layout file to inline";
            }
        };
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        if (this.myUsageElement != null) {
            return new UsageInfo[]{new UsageInfo(this.myUsageElement)};
        }
        HashSet<UsageInfo> usages = new HashSet<UsageInfo>();
        AndroidInlineUtil.addReferences((PsiElement)this.myLayoutFile, usages);
        for (PsiField field2 : IdeResourcesUtil.findResourceFieldsForFileResource((PsiFile)this.myLayoutFile, false)) {
            AndroidInlineUtil.addReferences((PsiElement)field2, usages);
        }
        return usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        ArrayList<LayoutUsageData> inlineInfos = new ArrayList<LayoutUsageData>();
        for (UsageInfo usage : usages) {
            LayoutUsageData usageData;
            PsiElement element2 = usage.getElement();
            if (element2 == null) continue;
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class);
            LayoutUsageData layoutUsageData = usageData = tag != null ? AndroidInlineUtil.getLayoutUsageData(tag) : null;
            if (usageData == null || usageData.getReference().computeTargetElements().length != 1) continue;
            inlineInfos.add(usageData);
        }
        for (LayoutUsageData info2 : inlineInfos) {
            try {
                info2.inline(this.myLayoutRootTag);
            }
            catch (AndroidRefactoringErrorException e) {
                LOG.info((Throwable)e);
                String message2 = e.getMessage();
                if (message2 == null) {
                    message2 = "Refactoring was performed with errors";
                }
                AndroidUtils.reportError(this.myProject, message2, AndroidBundle.message("android.inline.style.title", new Object[0]));
                return;
            }
        }
        if (this.myUsageElement == null) {
            try {
                this.myLayoutFile.delete();
            }
            catch (IncorrectOperationException e) {
                Throwable c = e.getCause();
                if (c instanceof IOException && c.getMessage() != null) {
                    AndroidUtils.reportError(this.myProject, c.getMessage(), AndroidBundle.message("android.inline.style.title", new Object[0]));
                    return;
                }
                throw e;
            }
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        MultiMap<PsiElement, String> conflicts2 = AndroidInlineLayoutProcessor.detectConflicts(usages);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myTestConfig.setConflicts(conflicts2);
            return true;
        }
        return this.showConflicts(conflicts2, usages);
    }

    private static MultiMap<PsiElement, String> detectConflicts(UsageInfo[] usages) {
        ArrayList<PsiElement> nonXmlUsages = new ArrayList<PsiElement>();
        ArrayList<PsiElement> unsupportedUsages = new ArrayList<PsiElement>();
        ArrayList<PsiElement> unambiguousUsages = new ArrayList<PsiElement>();
        for (UsageInfo usage : usages) {
            LayoutUsageData usageData;
            PsiElement element2 = usage.getElement();
            if (element2 == null) continue;
            if (element2.getLanguage() != XMLLanguage.INSTANCE) {
                nonXmlUsages.add(element2);
                continue;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class);
            LayoutUsageData layoutUsageData = usageData = tag != null ? AndroidInlineUtil.getLayoutUsageData(tag) : null;
            if (usageData == null) {
                unsupportedUsages.add(element2);
                continue;
            }
            if (usageData.getReference().computeTargetElements().length <= 1) continue;
            unambiguousUsages.add(element2);
        }
        return AndroidInlineUtil.buildConflicts(nonXmlUsages, unambiguousUsages, unsupportedUsages, Collections.emptyList());
    }

    @NotNull
    protected String getCommandName() {
        return AndroidBundle.message("android.inline.layout.command.name", this.myLayoutFile.getName());
    }

    @NotNull
    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
    }
}

