/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.AndroidExtractStyleAction;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFindStyleApplicationsProcessor
extends BaseRefactoringProcessor {
    private final Module myModule;
    private final Map<AndroidAttributeInfo, String> myAttrMap;
    private final String myStyleName;
    private final XmlTag myStyleTag;
    private final XmlAttributeValue myStyleNameAttrValue;
    private final PsiElement myParentStyleNameAttrValue;
    private final PsiFile myContext;
    private boolean mySearchOnlyInCurrentModule;
    private VirtualFile myFileToScan;

    protected AndroidFindStyleApplicationsProcessor(@NotNull Module module2, @NotNull Map<AndroidAttributeInfo, String> attrMap, @NotNull String styleName, @NotNull XmlTag styleTag, @NotNull XmlAttributeValue styleNameAttrValue, @Nullable PsiElement parentStyleNameAttrValue, @Nullable PsiFile context2) {
        super(module2.getProject());
        this.myModule = module2;
        this.myAttrMap = attrMap;
        this.myStyleName = styleName;
        this.myStyleTag = styleTag;
        this.myParentStyleNameAttrValue = parentStyleNameAttrValue;
        this.myStyleNameAttrValue = styleNameAttrValue;
        this.myContext = context2;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new UsageViewDescriptor(){

            @NotNull
            public PsiElement[] getElements() {
                return new PsiElement[]{AndroidFindStyleApplicationsProcessor.this.myStyleTag};
            }

            public String getProcessedElementsHeader() {
                return "Style to use";
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "Tags the reference to the style will be added to " + UsageViewBundle.getOccurencesString((int)usagesCount, (int)filesCount);
            }
        };
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        List<UsageInfo> usages = this.findAllStyleApplications();
        return usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        super.preprocessUsages(refUsages);
        if (((UsageInfo[])refUsages.get()).length == 0) {
            Messages.showInfoMessage((Project)this.myProject, (String)("IDEA has not found any possible applications of style '" + this.myStyleName + "'"), (String)AndroidBundle.message("android.find.style.applications.title", new Object[0]));
            return false;
        }
        return true;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        HashSet<Pair> attrsInStyle = new HashSet<Pair>();
        for (AndroidAttributeInfo info2 : this.myAttrMap.keySet()) {
            attrsInStyle.add(Pair.create((Object)info2.getNamespace(), (Object)info2.getName()));
        }
        for (UsageInfo usage : usages) {
            DomElement domElement;
            PsiElement element2 = usage.getElement();
            DomElement domElement2 = domElement = element2 instanceof XmlTag ? DomManager.getDomManager((Project)this.myProject).getDomElement((XmlTag)element2) : null;
            if (!(domElement instanceof LayoutViewElement)) continue;
            final ArrayList<XmlAttribute> attributesToDelete = new ArrayList<XmlAttribute>();
            for (XmlAttribute attribute : ((XmlTag)element2).getAttributes()) {
                if (!attrsInStyle.contains(Pair.create((Object)attribute.getNamespace(), (Object)attribute.getLocalName()))) continue;
                attributesToDelete.add(attribute);
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    for (XmlAttribute attribute : attributesToDelete) {
                        attribute.delete();
                    }
                    ((LayoutViewElement)domElement).getStyle().setStringValue("@style/" + AndroidFindStyleApplicationsProcessor.this.myStyleName);
                }
            });
        }
        PsiFile file2 = this.myStyleTag.getContainingFile();
        if (file2 != null) {
            UndoUtil.markPsiFileForUndo((PsiFile)file2);
        }
        if (this.myContext != null) {
            UndoUtil.markPsiFileForUndo((PsiFile)this.myContext);
        }
    }

    @NotNull
    protected String getCommandName() {
        return "Use Style '" + this.myStyleName + "' Where Possible";
    }

    @NotNull
    static List<Module> getAllModulesToScan(@NotNull Module module2) {
        ArrayList<Module> result2 = new ArrayList<Module>();
        for (Module m : ModuleManager.getInstance((Project)module2.getProject()).getModules()) {
            if (!m.equals(module2) && !ModuleRootManager.getInstance((Module)m).isDependsOn(module2)) continue;
            result2.add(module2);
        }
        return result2;
    }

    public Collection<PsiFile> collectFilesToProcess() {
        Project project = this.myModule.getProject();
        ArrayList<VirtualFile> resDirs = new ArrayList<VirtualFile>();
        if (this.mySearchOnlyInCurrentModule) {
            AndroidFindStyleApplicationsProcessor.collectResDir(this.myModule, this.myStyleName, resDirs);
        } else {
            for (Module m : AndroidFindStyleApplicationsProcessor.getAllModulesToScan(this.myModule)) {
                AndroidFindStyleApplicationsProcessor.collectResDir(m, this.myStyleName, resDirs);
            }
        }
        List<VirtualFile> subdirs = IdeResourcesUtil.getResourceSubdirs(ResourceFolderType.LAYOUT, resDirs);
        ArrayList<VirtualFile> filesToProcess = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : subdirs) {
            for (VirtualFile child : virtualFile.getChildren()) {
                if (!FileTypeRegistry.getInstance().isFileOfType(child, (FileType)XmlFileType.INSTANCE) || this.myFileToScan != null && !this.myFileToScan.equals(child)) continue;
                filesToProcess.add(child);
            }
        }
        if (filesToProcess.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<PsiFile> psiFilesToProcess = new HashSet<PsiFile>();
        for (VirtualFile file2 : filesToProcess) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
            if (psiFile == null) continue;
            psiFilesToProcess.add(psiFile);
        }
        CacheManager cacheManager = CacheManager.getInstance((Project)project);
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)project);
        for (Map.Entry<AndroidAttributeInfo, String> entry : this.myAttrMap.entrySet()) {
            AndroidFindStyleApplicationsProcessor.filterFilesToScan(cacheManager, entry.getKey().getName(), psiFilesToProcess, projectScope);
            AndroidFindStyleApplicationsProcessor.filterFilesToScan(cacheManager, entry.getValue(), psiFilesToProcess, projectScope);
        }
        return psiFilesToProcess;
    }

    @NotNull
    private List<UsageInfo> findAllStyleApplications() {
        Collection<PsiFile> psiFilesToProcess = this.collectFilesToProcess();
        if (psiFilesToProcess.isEmpty()) {
            return Collections.emptyList();
        }
        int n = psiFilesToProcess.size();
        boolean i = false;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText("Searching for style applications");
        }
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (PsiFile psiFile : psiFilesToProcess) {
            ProgressManager.checkCanceled();
            VirtualFile vFile = psiFile.getVirtualFile();
            if (vFile == null) continue;
            if (indicator != null) {
                indicator.setFraction((double)i / (double)n);
                indicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)vFile, (Project)this.myProject));
            }
            this.findAllStyleApplications(vFile, usages);
        }
        return usages;
    }

    private static void collectResDir(Module module2, String styleName, List<VirtualFile> resDirs) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(facet2);
        LocalResourceRepository repository2 = repositoryManager.getAppResources();
        List<ResourceItem> styles = repository2.getResources(ResourceNamespace.TODO(), ResourceType.STYLE, styleName);
        if (styles.size() == 1) {
            resDirs.addAll(repositoryManager.getAllResourceDirs());
        }
    }

    private static void filterFilesToScan(CacheManager cacheManager, String s, Set<PsiFile> result2, GlobalSearchScope scope2) {
        for (String word : StringUtil.getWordsInStringLongestFirst((String)s)) {
            PsiFile[] files2 = cacheManager.getFilesWithWord(word, (short)255, scope2, true);
            result2.retainAll(Arrays.asList(files2));
        }
    }

    private void findAllStyleApplications(final VirtualFile layoutVFile, final List<UsageInfo> usages) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiFile layoutFile = PsiManager.getInstance((Project)AndroidFindStyleApplicationsProcessor.this.myProject).findFile(layoutVFile);
                if (!(layoutFile instanceof XmlFile)) {
                    return;
                }
                if (!AndroidResourceDomFileDescription.isFileInResourceFolderType((XmlFile)layoutFile, ResourceFolderType.LAYOUT)) {
                    return;
                }
                AndroidFindStyleApplicationsProcessor.this.collectPossibleStyleApplications(layoutFile, usages);
                PsiManager.getInstance((Project)AndroidFindStyleApplicationsProcessor.this.myProject).dropResolveCaches();
                InjectedLanguageManager.getInstance((Project)AndroidFindStyleApplicationsProcessor.this.myProject).dropFileCaches(layoutFile);
            }
        });
    }

    public void collectPossibleStyleApplications(PsiFile layoutFile, final List<UsageInfo> usages) {
        layoutFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                if (AndroidFindStyleApplicationsProcessor.this.isPossibleApplicationOfStyle(tag)) {
                    usages.add(new UsageInfo((PsiElement)tag));
                }
            }
        });
    }

    @Nullable
    private static PsiElement getStyleNameAttrValueForTag(@NotNull LayoutViewElement element2) {
        PsiElement[] styleElements;
        AndroidResourceReferenceBase styleRef = AndroidDomUtil.getAndroidResourceReference(element2.getStyle(), false);
        if (styleRef != null && (styleElements = styleRef.computeTargetElements()).length == 1) {
            return styleElements[0];
        }
        return null;
    }

    private boolean isPossibleApplicationOfStyle(XmlTag candidate) {
        DomElement domCandidate = DomManager.getDomManager((Project)this.myProject).getDomElement(candidate);
        if (!(domCandidate instanceof LayoutViewElement)) {
            return false;
        }
        LayoutViewElement candidateView = (LayoutViewElement)domCandidate;
        HashMap<Pair, String> attrsInCandidateMap = new HashMap<Pair, String>();
        List<XmlAttribute> attrsInCandidate = AndroidExtractStyleAction.getExtractableAttributes(candidate);
        if (attrsInCandidate.size() < this.myAttrMap.size()) {
            return false;
        }
        for (XmlAttribute xmlAttribute : attrsInCandidate) {
            String attrValue = xmlAttribute.getValue();
            if (attrValue == null) continue;
            attrsInCandidateMap.put(Pair.create((Object)xmlAttribute.getNamespace(), (Object)xmlAttribute.getLocalName()), attrValue);
        }
        for (Map.Entry entry : this.myAttrMap.entrySet()) {
            String ns = ((AndroidAttributeInfo)entry.getKey()).getNamespace();
            String name = ((AndroidAttributeInfo)entry.getKey()).getName();
            String value2 = (String)entry.getValue();
            String valueInCandidate = (String)attrsInCandidateMap.get(Pair.create((Object)ns, (Object)name));
            if (valueInCandidate != null && valueInCandidate.equals(value2)) continue;
            return false;
        }
        if (candidateView.getStyle().getStringValue() != null) {
            if (this.myParentStyleNameAttrValue == null) {
                return false;
            }
            PsiElement styleNameAttrValueForTag = AndroidFindStyleApplicationsProcessor.getStyleNameAttrValueForTag(candidateView);
            if (!this.myParentStyleNameAttrValue.equals(styleNameAttrValueForTag)) {
                return false;
            }
        } else if (this.myParentStyleNameAttrValue != null) {
            return false;
        }
        return true;
    }

    public void setSearchOnlyInCurrentModule(boolean searchOnlyInCurrentModule) {
        this.mySearchOnlyInCurrentModule = searchOnlyInCurrentModule;
    }

    public void setFileToScan(VirtualFile fileToScan) {
        this.myFileToScan = fileToScan;
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public String getStyleName() {
        return this.myStyleName;
    }

    public void configureScope(MyScope scope2, @Nullable VirtualFile context2) {
        if (scope2 == MyScope.MODULE) {
            this.setSearchOnlyInCurrentModule(true);
        } else if (scope2 == MyScope.FILE) {
            this.setSearchOnlyInCurrentModule(true);
            this.setFileToScan(context2);
        }
    }

    static enum MyScope {
        PROJECT,
        MODULE,
        FILE;

    }
}

