/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidAttributeInfo {
    private final String myName;
    private final String myPackage;

    public AndroidAttributeInfo(@NotNull String name, @Nullable String aPackage) {
        this.myName = name;
        this.myPackage = aPackage;
    }

    public String getNamespace() {
        boolean system = "android".equals(this.myPackage);
        return system ? "http://schemas.android.com/apk/res/android" : null;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getPackage() {
        return this.myPackage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidAttributeInfo info2 = (AndroidAttributeInfo)o;
        if (!this.myName.equals(info2.myName)) {
            return false;
        }
        return !(this.myPackage != null ? !this.myPackage.equals(info2.myPackage) : info2.myPackage != null);
    }

    public int hashCode() {
        int result2 = this.myName.hashCode();
        result2 = 31 * result2 + (this.myPackage != null ? this.myPackage.hashCode() : 0);
        return result2;
    }

    @NotNull
    public String getAttributeId() {
        return this.myPackage != null ? this.myPackage + ":" + this.myName : this.myName;
    }

    public String toString() {
        return this.getAttributeId();
    }
}

