/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.quickDefinitions;

import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.codeInsight.hint.ImplementationViewSession;
import com.intellij.codeInsight.hint.ImplementationViewSessionFactory;
import com.intellij.codeInsight.hint.PsiImplementationViewElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.quickDefinitions.AndroidImplementationViewSessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J&\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010&\u001a\u00020'2\u000e\u0010(\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150)H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006*"}, d2={"Lorg/jetbrains/android/quickDefinitions/AndroidImplementationViewSession;", "Lcom/intellij/codeInsight/hint/ImplementationViewSession;", "resourceReferencePsiElement", "Lcom/android/tools/idea/res/psi/ResourceReferencePsiElement;", "contextElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/android/tools/idea/res/psi/ResourceReferencePsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "factory", "Lcom/intellij/codeInsight/hint/ImplementationViewSessionFactory;", "getFactory", "()Lcom/intellij/codeInsight/hint/ImplementationViewSessionFactory;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "implementationElements", "", "Lcom/intellij/codeInsight/hint/ImplementationViewElement;", "getImplementationElements", "()Ljava/util/List;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "text", "", "getText", "()Ljava/lang/String;", "dispose", "", "elementRequiresIncludeSelf", "", "needUpdateInBackground", "searchImplementationsInBackground", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "processor", "Lcom/intellij/util/Processor;", "intellij.android.core"})
public final class AndroidImplementationViewSession
implements ImplementationViewSession {
    @NotNull
    private final ResourceReferencePsiElement resourceReferencePsiElement;
    @NotNull
    private final PsiElement contextElement;
    @Nullable
    private final Editor editor;
    @Nullable
    private final VirtualFile file;
    @Nullable
    private final String text;
    @NotNull
    private final Project project;

    public AndroidImplementationViewSession(@NotNull ResourceReferencePsiElement resourceReferencePsiElement, @NotNull PsiElement contextElement, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)((Object)resourceReferencePsiElement), (String)"resourceReferencePsiElement");
        Intrinsics.checkNotNullParameter((Object)contextElement, (String)"contextElement");
        this.resourceReferencePsiElement = resourceReferencePsiElement;
        this.contextElement = contextElement;
        this.editor = editor;
        this.file = this.contextElement.getContainingFile().getVirtualFile();
        this.text = this.contextElement.getText();
        this.project = this.resourceReferencePsiElement.getProject();
    }

    @Nullable
    public Editor getEditor() {
        return this.editor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ImplementationViewElement> getImplementationElements() {
        void $this$mapTo$iv$iv;
        PsiElement[] psiElementArray = AndroidResourceToPsiResolver.getInstance().getGotoDeclarationTargets(this.resourceReferencePsiElement.getResourceReference(), this.contextElement);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getInstance()\n        .g\u2026eference, contextElement)");
        Object[] $this$map$iv = psiElementArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection2.add(new PsiImplementationViewElement((PsiElement)it));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.file;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    @NotNull
    public ImplementationViewSessionFactory getFactory() {
        Object object = ImplementationViewSessionFactory.EP_NAME.findExtensionOrFail(AndroidImplementationViewSessionFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EP_NAME.findExtensionOrF\u2026ssionFactory::class.java)");
        return (ImplementationViewSessionFactory)object;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public List<ImplementationViewElement> searchImplementationsInBackground(@NotNull ProgressIndicator indicator, @NotNull Processor<? super ImplementationViewElement> processor) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        return CollectionsKt.emptyList();
    }

    public boolean elementRequiresIncludeSelf() {
        return false;
    }

    public boolean needUpdateInBackground() {
        return false;
    }

    public void dispose() {
    }
}

