/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.android.AndroidXConstants;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.macro.VariableOfTypeMacro;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.actions.CreateXmlResourceDialog;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAddStringResourceAction
extends AbstractIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getText() {
        return AndroidBundle.message("add.string.resource.intention.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
        if (facet2 == null) {
            return false;
        }
        PsiElement element2 = AndroidAddStringResourceAction.getPsiElement(file2, editor);
        return element2 != null && AndroidAddStringResourceAction.getStringLiteralValue(project, element2, file2, this.getType()) != null;
    }

    protected ResourceType getType() {
        return ResourceType.STRING;
    }

    @Nullable
    protected static String getStringLiteralValue(@NotNull Project project, @NotNull PsiElement element2, @NotNull PsiFile file2, ResourceType resourceType) {
        ResourceValue value2;
        Converter converter;
        GenericAttributeValue domAttribute;
        XmlAttribute attribute;
        if (file2 instanceof PsiJavaFile && element2 instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element2;
            Object value3 = literalExpression.getValue();
            if (resourceType == ResourceType.STRING && value3 instanceof String) {
                return (String)value3;
            }
            if (resourceType == ResourceType.DIMEN && (value3 instanceof Integer || value3 instanceof Float)) {
                return value3.toString();
            }
        } else if (file2 instanceof XmlFile && element2 instanceof XmlAttributeValue && (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlAttribute.class)) != null && (domAttribute = DomManager.getDomManager((Project)project).getDomElement(attribute)) != null && (converter = domAttribute.getConverter()) instanceof ResourceReferenceConverter && (value2 = (ResourceValue)domAttribute.getValue()) != null && !value2.isReference()) {
            Set<ResourceType> types2 = ((ResourceReferenceConverter)converter).getResourceTypes((DomElement)domAttribute);
            for (ResourceType type : types2) {
                if (resourceType != type) continue;
                String attributeText = ((XmlAttributeValue)element2).getValue();
                if (attributeText != null) {
                    return ValueXmlHelper.unescapeResourceString((String)attributeText, (boolean)true, (boolean)true);
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static PsiClass getContainingInheritorOf(@NotNull PsiElement element2, String ... baseClassNames) {
        PsiClass c = null;
        do {
            c = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)(c == null ? element2 : c), PsiClass.class);
            for (String name : baseClassNames) {
                if (!InheritanceUtil.isInheritor((PsiClass)c, (String)name)) continue;
                return c;
            }
        } while (c != null);
        return null;
    }

    @Nullable
    protected static PsiElement getPsiElement(PsiFile file2, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element2 = file2.findElementAt(offset);
        return element2 != null ? element2.getParent() : null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        AndroidAddStringResourceAction.doInvoke(project, editor, file2, null, this.getType());
    }

    static void doInvoke(Project project, Editor editor, PsiFile file2, @Nullable String resName, ResourceType type) {
        PsiElement element2 = AndroidAddStringResourceAction.getPsiElement(file2, editor);
        assert (element2 != null);
        AndroidAddStringResourceAction.doInvoke(project, editor, file2, resName, element2, type);
    }

    protected static void doInvoke(Project project, Editor editor, PsiFile file2, @Nullable String resName, PsiElement element2, ResourceType type) {
        List<String> dirNames;
        VirtualFile resourceDir;
        String fileName;
        String value2 = AndroidAddStringResourceAction.getStringLiteralValue(project, element2, file2, type);
        assert (value2 != null);
        if (resName == null) {
            resName = IdeResourcesUtil.buildResourceNameFromStringValue(value2);
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
        assert (facet2 != null);
        String aPackage = ProjectSystemUtil.getModuleSystem(facet2).getPackageName();
        if (aPackage == null) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("package.not.found.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        if (resName != null && ApplicationManager.getApplication().isUnitTestMode()) {
            fileName = IdeResourcesUtil.getDefaultResourceFileName(type);
            assert (fileName != null);
            resourceDir = ResourceFolderManager.getInstance(facet2).getPrimaryFolder();
            assert (resourceDir != null);
            dirNames = Collections.singletonList(ResourceFolderType.VALUES.getName());
        } else {
            Module facetModule = facet2.getModule();
            CreateXmlResourceDialog dialog2 = new CreateXmlResourceDialog(facetModule, type, resName, value2, true, null, file2.getVirtualFile());
            dialog2.setTitle("Extract Resource");
            if (!dialog2.showAndGet()) {
                return;
            }
            resourceDir = dialog2.getResourceDirectory();
            if (resourceDir == null) {
                AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", facetModule));
                return;
            }
            fileName = dialog2.getFileName();
            resName = dialog2.getResourceName();
            dirNames = dialog2.getDirNames();
            value2 = dialog2.getValue();
        }
        String finalValue = value2;
        String finalResName = resName;
        if (IdeResourcesUtil.createValueResource(project, resourceDir, finalResName, type, fileName, dirNames, finalValue)) {
            AndroidAddStringResourceAction.doAddStringResource(editor, file2, finalResName, element2, type, facet2, aPackage);
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            UndoUtil.markPsiFileForUndo((PsiFile)file2);
            PsiManager.getInstance((Project)project).dropResolveCaches();
        }
    }

    private static void doAddStringResource(Editor editor, PsiFile file2, @Nullable String resName, PsiElement element2, ResourceType type, AndroidFacet facet2, String aPackage) {
        WriteAction.run(() -> {
            if (file2 instanceof PsiJavaFile) {
                AndroidAddStringResourceAction.createJavaResourceReference(facet2.getModule(), editor, file2, element2, aPackage, resName, type);
            } else {
                XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlAttribute.class);
                if (attribute != null) {
                    attribute.setValue(ResourceValue.referenceTo('@', null, type.getName(), resName).toString());
                }
            }
        });
    }

    private static boolean hasMethodOnlyOverloadedWithOneIntParameter(PsiMethod method2, int index2) {
        PsiMethod[] sameNameMethods;
        if (method2.getNameIdentifier() == null) {
            return false;
        }
        PsiParameterList parameterList = method2.getParameterList();
        int parameterCount = parameterList.getParametersCount();
        if (parameterCount == 0) {
            return false;
        }
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String methodName = method2.getName();
        for (PsiMethod sameNameMethod : sameNameMethods = aClass.findMethodsByName(methodName, false)) {
            PsiParameterList otherParameterList;
            if (method2.equals(sameNameMethod) || parameterCount != (otherParameterList = sameNameMethod.getParameterList()).getParametersCount()) continue;
            boolean found = true;
            PsiParameter[] parameters2 = parameterList.getParameters();
            PsiParameter[] otherParameters = otherParameterList.getParameters();
            for (int i = 0; i < parameterCount; ++i) {
                PsiParameter parameter = parameters2[i];
                PsiParameter otherParameter = otherParameters[i];
                if (i == index2) {
                    if (!PsiType.INT.equals((Object)otherParameter.getType())) {
                        found = false;
                        break;
                    }
                    if (AnnotationUtil.isAnnotated((PsiModifierListOwner)otherParameter, (String)ResourceEvaluator.STRING_RES_ANNOTATION.oldName(), (int)2) || AnnotationUtil.isAnnotated((PsiModifierListOwner)otherParameter, (String)ResourceEvaluator.STRING_RES_ANNOTATION.newName(), (int)2)) continue;
                    found = false;
                    break;
                }
                if (parameter.getType().equals(otherParameter.getType())) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    private static boolean useGetStringMethodForStringRes(PsiElement element2) {
        if (element2.getParent() instanceof PsiExpressionList) {
            PsiElement resolved;
            PsiExpressionList expressionList = (PsiExpressionList)element2.getParent();
            int index2 = Arrays.asList(expressionList.getExpressions()).indexOf((PsiExpression)element2);
            PsiElement prevSibling = expressionList.getPrevSibling();
            if (prevSibling != null && prevSibling.getReference() != null && (resolved = prevSibling.getReference().resolve()) instanceof PsiMethod && AndroidAddStringResourceAction.hasMethodOnlyOverloadedWithOneIntParameter((PsiMethod)resolved, index2)) {
                return false;
            }
        }
        return true;
    }

    private static void createJavaResourceReference(Module module2, Editor editor, final PsiFile file2, PsiElement element2, String aPackage, String resName, ResourceType resType) {
        TemplateImpl template;
        boolean extendsContext = AndroidAddStringResourceAction.getContainingInheritorOf(element2, "android.content.Context") != null;
        boolean extendsFragment = AndroidAddStringResourceAction.getContainingInheritorOf(element2, "android.app.Fragment") != null || AndroidAddStringResourceAction.getContainingInheritorOf(element2, AndroidXConstants.CLASS_V4_FRAGMENT.oldName()) != null || AndroidAddStringResourceAction.getContainingInheritorOf(element2, AndroidXConstants.CLASS_V4_FRAGMENT.newName()) != null;
        String rJavaFieldName = IdeResourcesUtil.getRJavaFieldName(resName);
        String field2 = aPackage + ".R." + resType.getName() + "." + rJavaFieldName;
        String methodName = AndroidAddStringResourceAction.getGetterNameForResourceType(resType, element2);
        assert (methodName != null);
        boolean inStaticContext = CommonJavaRefactoringUtil.isInStaticContext((PsiElement)element2, null);
        final Project project = module2.getProject();
        if ((extendsContext || extendsFragment) && !inStaticContext) {
            if (ResourceType.STRING == resType) {
                template = AndroidAddStringResourceAction.useGetStringMethodForStringRes(element2) ? new TemplateImpl("", methodName + "(" + field2 + ")", "") : new TemplateImpl("", field2, "");
            } else {
                template = new TemplateImpl("", "$resources$." + methodName + "(" + field2 + ")", "");
                MacroCallNode node = new MacroCallNode((Macro)new MyVarOfTypeExpression("getResources()"));
                node.addParameter((Expression)new ConstantNode("android.content.res.Resources"));
                template.addVariable("resources", (Expression)node, (Expression)new ConstantNode(""), true);
            }
        } else {
            boolean addContextVariable = true;
            if (ResourceType.STRING == resType) {
                if (AndroidAddStringResourceAction.useGetStringMethodForStringRes(element2)) {
                    template = new TemplateImpl("", "$context$." + methodName + "(" + field2 + ")", "");
                } else {
                    template = new TemplateImpl("", field2, "");
                    addContextVariable = false;
                }
            } else {
                template = new TemplateImpl("", "$context$.getResources()." + methodName + "(" + field2 + ")", "");
            }
            if (addContextVariable) {
                boolean extendsView = AndroidAddStringResourceAction.getContainingInheritorOf(element2, "android.view.View") != null;
                MacroCallNode node = new MacroCallNode((Macro)(extendsView && !inStaticContext ? new MyVarOfTypeExpression("getContext()") : new VariableOfTypeMacro()));
                node.addParameter((Expression)new ConstantNode("android.content.Context"));
                template.addVariable("context", (Expression)node, (Expression)new ConstantNode(""), true);
            }
        }
        int offset = element2.getTextOffset();
        editor.getCaretModel().moveToOffset(offset);
        TextRange elementRange = element2.getTextRange();
        editor.getDocument().deleteString(elementRange.getStartOffset(), elementRange.getEndOffset());
        final RangeMarker marker = editor.getDocument().createRangeMarker(offset, offset);
        marker.setGreedyToLeft(true);
        marker.setGreedyToRight(true);
        TemplateManager.getInstance((Project)project).startTemplate(editor, (Template)template, false, null, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void waitingForInput(Template template) {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)file2, marker.getStartOffset(), marker.getEndOffset());
            }

            public void beforeTemplateFinished(@NotNull TemplateState state2, Template template) {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)file2, marker.getStartOffset(), marker.getEndOffset());
            }
        });
    }

    @Nullable
    private static String getGetterNameForResourceType(@NotNull ResourceType resourceType, @NotNull PsiElement element2) {
        String type = resourceType.getName();
        if (type.length() < 2) {
            return null;
        }
        if (resourceType == ResourceType.DIMEN) {
            PsiType targetType = AndroidAddStringResourceAction.computeTargetType(element2);
            if (PsiType.INT.equals((Object)targetType)) {
                return "getDimensionPixelSize";
            }
            return "getDimension";
        }
        return "get" + Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Nullable
    private static PsiType computeTargetType(PsiElement element2) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiMethodCallExpression.class);
        if (call != null) {
            PsiParameterList parameterList;
            PsiParameter psiParameter;
            PsiMethod resolved;
            int index2;
            PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiExpressionList.class, (boolean)true);
            if (expressionList != null && (index2 = ArrayUtil.indexOf((Object[])expressionList.getExpressions(), (Object)element2)) >= 0 && (resolved = call.resolveMethod()) != null && (psiParameter = (parameterList = resolved.getParameterList()).getParameter(index2)) != null) {
                return psiParameter.getType();
            }
        } else {
            PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiLocalVariable.class, (boolean)false);
            if (variable != null) {
                return variable.getType();
            }
        }
        return null;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement element2 = file2.findElementAt(editor.getCaretModel().getOffset());
        if (element2 == null) {
            return super.generatePreview(project, editor, file2);
        }
        PsiElement parent2 = element2.getParent();
        if (parent2 instanceof XmlAttributeValue) {
            String value2;
            Object defaultName = this.getType().getName() + "_name";
            PsiElement parentParent = parent2.getParent();
            if (parentParent instanceof XmlAttribute && this.getType() == ResourceType.STRING && (value2 = ((XmlAttribute)parentParent).getValue()) != null) {
                defaultName = IdeResourcesUtil.buildResourceNameFromStringValue(value2);
            }
            int start2 = element2.getTextOffset();
            int end = start2 + element2.getTextLength();
            editor.getDocument().replaceString(start2, end, (CharSequence)("@" + this.getType().getName() + "/" + (String)defaultName));
            return IntentionPreviewInfo.DIFF;
        }
        return super.generatePreview(project, editor, file2);
    }

    private static class MyVarOfTypeExpression
    extends VariableOfTypeMacro {
        private final String myDefaultValue;

        private MyVarOfTypeExpression(@NotNull String defaultValue) {
            this.myDefaultValue = defaultValue;
        }

        public Result calculateResult(@NotNull Expression[] params2, ExpressionContext context2) {
            return new TextResult(this.myDefaultValue);
        }

        public Result calculateQuickResult(@NotNull Expression[] params2, ExpressionContext context2) {
            return new TextResult(this.myDefaultValue);
        }

        public LookupElement[] calculateLookupItems(@NotNull Expression[] params2, ExpressionContext context2) {
            PsiElement[] vars = this.getVariables(params2, context2);
            if (vars == null || vars.length == 0) {
                return null;
            }
            LinkedHashSet set = new LinkedHashSet();
            for (PsiElement var : vars) {
                JavaTemplateUtil.addElementLookupItem(set, (PsiElement)var);
            }
            LookupElement[] elements = set.toArray(LookupElement.EMPTY_ARRAY);
            if (elements.length == 0) {
                return elements;
            }
            LookupElementBuilder lookupElementForDefValue = LookupElementBuilder.create((String)this.myDefaultValue);
            LookupElement[] result2 = new LookupElement[elements.length + 1];
            result2[0] = lookupElementForDefValue;
            System.arraycopy(elements, 0, result2, 1, elements.length);
            return result2;
        }
    }
}

